<?php
/**
 * ============================================
 * APROVAR API - BACKUP PARA COMPROVANTES
 * ============================================
 */
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// DEBUG - descomente para ver erros
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

// Carrega config
require_once __DIR__ . '/config.php';

// Senha do admin (altere isso!)
define('ADMIN_SENHA', 'admin123');

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$senha = $_GET['senha'] ?? $_POST['senha'] ?? '';

// Verifica senha
if ($senha !== ADMIN_SENHA) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Senha inválida']);
    exit;
}

// Diretório dos comprovantes
$comprovantesDir = __DIR__ . '/../comprovantes/';
$pendentesFile = $comprovantesDir . 'pendentes.json';
$aprovadosFile = $comprovantesDir . 'aprovados.json';
$rejeitadosFile = $comprovantesDir . 'rejeitados.json';

// ========== FUNÇÃO: Garante que diretório e arquivos existam ==========
function garantirArquivos($dir, $arquivos) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
    foreach ($arquivos as $arquivo) {
        if (!file_exists($arquivo)) {
            file_put_contents($arquivo, '[]');
            chmod($arquivo, 0644);
        }
    }
}

garantirArquivos($comprovantesDir, [$pendentesFile, $aprovadosFile, $rejeitadosFile]);

// ========== FUNÇÃO: Ler JSON com segurança ==========
function lerJSON($arquivo) {
    if (!file_exists($arquivo)) {
        return [];
    }
    $conteudo = file_get_contents($arquivo);
    if ($conteudo === false || empty($conteudo)) {
        return [];
    }
    $dados = json_decode($conteudo, true);
    return is_array($dados) ? $dados : [];
}

// ========== FUNÇÃO: Salvar JSON ==========
function salvarJSON($arquivo, $dados) {
    $json = json_encode($dados, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $resultado = file_put_contents($arquivo, $json, LOCK_EX);
    return $resultado !== false;
}

// ========== LISTAR PENDENTES ==========
if ($action === 'listar') {
    $todos = lerJSON($pendentesFile);
    $pendentes = array_filter($todos, function($p) {
        return ($p['status'] ?? '') === 'pendente';
    });
    $pendentes = array_values($pendentes);
    echo json_encode(['success' => true, 'pendentes' => $pendentes]);
    exit;
}

// ========== APROVAR ==========
if ($action === 'aprovar') {
    $id = $_POST['id'] ?? '';
    if (empty($id)) {
        echo json_encode(['success' => false, 'error' => 'ID não informado']);
        exit;
    }
    
    $pendentes = lerJSON($pendentesFile);
    $aprovados = lerJSON($aprovadosFile);
    
    $encontrado = false;
    $comprovanteData = null;
    $indexRemover = -1;
    
    foreach ($pendentes as $index => $p) {
        if ($p['id'] === $id) {
            $comprovanteData = $p;
            $comprovanteData['status'] = 'aprovado';
            $comprovanteData['aprovado_em'] = date('Y-m-d H:i:s');
            $indexRemover = $index;
            $encontrado = true;
            break;
        }
    }
    
    if (!$encontrado) {
        echo json_encode(['success' => false, 'error' => 'Comprovante não encontrado']);
        exit;
    }
    
    // Remove do pendentes
    array_splice($pendentes, $indexRemover, 1);
    
    // Adiciona aos aprovados
    $aprovados[] = $comprovanteData;
    
    // Salva
    if (!salvarJSON($pendentesFile, $pendentes)) {
        echo json_encode(['success' => false, 'error' => 'Erro ao salvar pendentes']);
        exit;
    }
    
    if (!salvarJSON($aprovadosFile, $aprovados)) {
        echo json_encode(['success' => false, 'error' => 'Erro ao salvar aprovados']);
        exit;
    }
    
    echo json_encode([
        'success' => true, 
        'message' => 'Comprovante aprovado'
    ]);
    exit;
}

// ========== REJEITAR ==========
if ($action === 'rejeitar') {
    $id = $_POST['id'] ?? '';
    $motivo = $_POST['motivo'] ?? 'Não especificado';
    
    if (empty($id)) {
        echo json_encode(['success' => false, 'error' => 'ID não informado']);
        exit;
    }
    
    $pendentes = lerJSON($pendentesFile);
    $rejeitados = lerJSON($rejeitadosFile);
    
    $encontrado = false;
    $comprovanteRejeitado = null;
    $indexRemover = -1;
    
    foreach ($pendentes as $index => $p) {
        if ($p['id'] === $id) {
            $comprovanteRejeitado = $p;
            $comprovanteRejeitado['status'] = 'rejeitado';
            $comprovanteRejeitado['rejeitado_em'] = date('Y-m-d H:i:s');
            $comprovanteRejeitado['motivo'] = $motivo;
            $indexRemover = $index;
            $encontrado = true;
            break;
        }
    }
    
    if (!$encontrado) {
        echo json_encode(['success' => false, 'error' => 'Comprovante não encontrado com ID: ' . $id]);
        exit;
    }
    
    array_splice($pendentes, $indexRemover, 1);
    $rejeitados[] = $comprovanteRejeitado;
    
    if (!salvarJSON($pendentesFile, $pendentes)) {
        echo json_encode(['success' => false, 'error' => 'Erro ao salvar pendentes']);
        exit;
    }
    
    if (!salvarJSON($rejeitadosFile, $rejeitados)) {
        echo json_encode(['success' => false, 'error' => 'Erro ao salvar rejeitados']);
        exit;
    }
    
    echo json_encode([
        'success' => true, 
        'message' => 'Comprovante rejeitado e removido da lista'
    ]);
    exit;
}

// ========== VERIFICAR ==========
if ($action === 'verificar') {
    $pixId = $_GET['pix_id'] ?? '';
    if (empty($pixId)) {
        echo json_encode(['success' => false, 'error' => 'PIX ID não informado']);
        exit;
    }
    
    $aprovados = lerJSON($aprovadosFile);
    $rejeitados = lerJSON($rejeitadosFile);
    
    $aprovado = false;
    $rejeitado = false;
    $motivoRejeicao = '';
    
    // Verifica se foi aprovado
    foreach ($aprovados as $a) {
        if (($a['pix_id'] ?? '') === $pixId) {
            $aprovado = true;
            break;
        }
    }
    
    // Se não foi aprovado, verifica se foi rejeitado
    if (!$aprovado) {
        foreach ($rejeitados as $r) {
            if (($r['pix_id'] ?? '') === $pixId) {
                $rejeitado = true;
                $motivoRejeicao = $r['motivo'] ?? 'Comprovante não aceito';
                break;
            }
        }
    }
    
    echo json_encode([
        'success' => true, 
        'aprovado' => $aprovado,
        'rejeitado' => $rejeitado,
        'motivo' => $motivoRejeicao
    ]);
    exit;
}

// ========== DEBUG ==========
if ($action === 'debug') {
    $info = [
        'diretorio' => $comprovantesDir,
        'diretorio_existe' => is_dir($comprovantesDir),
        'diretorio_gravavel' => is_writable($comprovantesDir),
        'pendentes_existe' => file_exists($pendentesFile),
        'pendentes_gravavel' => is_writable($pendentesFile),
        'aprovados_existe' => file_exists($aprovadosFile),
        'aprovados_gravavel' => is_writable($aprovadosFile),
        'rejeitados_existe' => file_exists($rejeitadosFile),
        'rejeitados_gravavel' => is_writable($rejeitadosFile),
        'php_version' => PHP_VERSION
    ];
    echo json_encode(['success' => true, 'debug' => $info], JSON_PRETTY_PRINT);
    exit;
}

echo json_encode(['success' => false, 'error' => 'Ação não especificada: ' . $action]);