<?php 
/**
 * ============================================
 * FACEBOOK CAPI - COMPLETO
 * ============================================
 * Envia eventos de conversão para o Facebook
 * Suporta múltiplos Pixels
 */

class FacebookCAPI {
    
    private $pixelId = '3061241000727171';
    private $pixelId2 = '1566519044674500';
    private $accessToken = 'EAARtphyE16sBQAYRIu5AVFC9PZAZBSUGA875QI6QdZCHrvk0Q1UVEXALi6fhLQ7pZBJbFhAhggv2k1bIYKZAgpcWdxtGFmPHnauDQhmFhLV0GTMhTBbnsSsQjctdw8mbHPvZAHOuTtxQZCDpBGlX3ZArHdjTTBiv0GHYKAFZB0UAxU0P9GLIqm6ZB3i5Q0VrImZABqldAZDZD';
    private $accessToken2 = 'EAARtphyE16sBQYeNQQI9DwQVtZCqV5mCwa8AVvphzwrtO3P7XOuQQligZApnPuP3pcGNsCAoVcnUlidvrKnvx1AijJPCTcAUPeWQ69JfPDdn1ZA4UmPXNtBAHyoIDjMPgIITjoaZCHFCTjviqDg5pjpXvTRZBCnHMmwfZBkLPZCA47RMYdqzrm086NA4z8G2MFs4wZDZD';
    private $testEventCode = ''; // Deixe vazio em produção
    
    // ============================================
    // MÉTODOS PÚBLICOS - EVENTOS PADRÃO
    // ============================================
    
    /**
     * PageView
     */
    public function pageView($userData, $sourceUrl = '', $eventId = null) {
        return $this->sendEvent('PageView', $userData, [], $sourceUrl, $eventId);
    }
    
    /**
     * ViewContent
     */
    public function viewContent($userData, $value = 0, $sourceUrl = '', $eventId = null) {
        $customData = [
            'currency' => 'BRL',
            'value' => floatval($value),
            'content_name' => $userData['content_name'] ?? 'Viva Sorte+',
            'content_ids' => [$userData['content_id'] ?? 'vivasorte-001'],
            'content_type' => 'product'
        ];
        
        return $this->sendEvent('ViewContent', $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * AddToCart
     */
    public function addToCart($userData, $value = 0, $numItems = 1, $sourceUrl = '', $eventId = null) {
        $customData = [
            'currency' => 'BRL',
            'value' => floatval($value),
            'content_name' => $userData['content_name'] ?? 'Viva Sorte+',
            'content_ids' => [$userData['content_id'] ?? 'vivasorte-001'],
            'content_type' => 'product',
            'num_items' => intval($numItems)
        ];
        
        return $this->sendEvent('AddToCart', $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * InitiateCheckout
     */
    public function initiateCheckout($userData, $value = 0, $numItems = 1, $sourceUrl = '', $eventId = null) {
        $customData = [
            'currency' => 'BRL',
            'value' => floatval($value),
            'content_name' => $userData['content_name'] ?? 'Viva Sorte+',
            'content_ids' => [$userData['content_id'] ?? 'vivasorte-001'],
            'content_type' => 'product',
            'num_items' => intval($numItems)
        ];
        
        return $this->sendEvent('InitiateCheckout', $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * AddPaymentInfo
     */
    public function addPaymentInfo($userData, $value = 0, $sourceUrl = '', $eventId = null) {
        $customData = [
            'currency' => 'BRL',
            'value' => floatval($value),
            'content_name' => $userData['content_name'] ?? 'Viva Sorte+',
            'content_ids' => [$userData['content_id'] ?? 'vivasorte-001'],
            'content_type' => 'product'
        ];
        
        return $this->sendEvent('AddPaymentInfo', $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * Purchase
     */
    public function purchase($userData, $value, $orderId, $numItems = 1, $sourceUrl = '', $eventId = null) {
        $customData = [
            'currency' => 'BRL',
            'value' => floatval($value),
            'content_name' => $userData['content_name'] ?? 'Viva Sorte+',
            'content_ids' => [$userData['content_id'] ?? 'vivasorte-001'],
            'content_type' => 'product',
            'num_items' => intval($numItems),
            'order_id' => $orderId
        ];
        
        return $this->sendEvent('Purchase', $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * Evento customizado
     */
    public function customEvent($eventName, $userData, $customData = [], $sourceUrl = '', $eventId = null) {
        return $this->sendEvent($eventName, $userData, $customData, $sourceUrl, $eventId);
    }
    
    /**
     * Método legado - sendPurchase (para webhook)
     */
    public function sendPurchase($txId, $valorReais, $utmData = []) {
        $this->log("Iniciando envio Purchase (webhook)", [
            'txId' => $txId,
            'valor' => $valorReais
        ]);
        
        // Prepara dados do usuário
        $userData = $this->prepareUserDataFromUtm($utmData);
        
        // Dados do evento
        $eventData = [
            'event_name' => 'Purchase',
            'event_time' => time(),
            'event_id' => 'purchase_' . $txId . '_' . time(),
            'event_source_url' => $utmData['source_url'] ?? 'https://vivasorteaoficial.com',
            'action_source' => 'website',
            'user_data' => $userData,
            'custom_data' => [
                'currency' => 'BRL',
                'value' => floatval($valorReais),
                'content_type' => 'product',
                'content_name' => $utmData['produto'] ?? 'Viva Sorte+',
                'content_ids' => [$utmData['produto_id'] ?? 'vivasorte-001'],
                'num_items' => intval($utmData['cotas'] ?? 1),
                'order_id' => $txId
            ]
        ];
        
        // Payload para a API
        $payload = ['data' => [$eventData]];
        
        if (!empty($this->testEventCode)) {
            $payload['test_event_code'] = $this->testEventCode;
        }

        // Envia para ambos os Pixels
        $this->sendToAllPixels($payload);
        
        return [
            'success' => true,
            'event_id' => $eventData['event_id']
        ];
    }
    
    // ============================================
    // MÉTODOS PRIVADOS
    // ============================================
    
    /**
     * Envia evento genérico
     */
    private function sendEvent($eventName, $userData, $customData = [], $sourceUrl = '', $eventId = null) {
        $eventId = $eventId ?: strtolower($eventName) . '_' . uniqid() . '_' . time();
        
        // Prepara user_data com hash
        $hashedUserData = $this->hashUserData($userData);
        
        // Evento
        $eventData = [
            'event_name' => $eventName,
            'event_time' => time(),
            'event_id' => $eventId,
            'action_source' => 'website',
            'user_data' => $hashedUserData
        ];
        
        if (!empty($sourceUrl)) {
            $eventData['event_source_url'] = $sourceUrl;
        }
        
        if (!empty($customData)) {
            $eventData['custom_data'] = $customData;
        }
        
        // Payload
        $payload = ['data' => [$eventData]];
        
        if (!empty($this->testEventCode)) {
            $payload['test_event_code'] = $this->testEventCode;
        }
        
        // Envia para ambos os Pixels
        $result = $this->sendToAllPixels($payload);
        
        return [
            'success' => $result,
            'event_id' => $eventId,
            'http_code' => 200
        ];
    }
    
    /**
     * Hash dos dados do usuário
     */
    private function hashUserData($userData) {
        $hashed = [];
        
        // Email
        if (!empty($userData['email'])) {
            $email = strtolower(trim($userData['email']));
            $hashed['em'] = [hash('sha256', $email)];
        }
        
        // Telefone
        if (!empty($userData['phone'])) {
            $phone = preg_replace('/\D/', '', $userData['phone']);
            if (strlen($phone) <= 11) {
                $phone = '55' . $phone;
            }
            $hashed['ph'] = [hash('sha256', $phone)];
        }
        
        // Nome
        if (!empty($userData['name'])) {
            $nameParts = explode(' ', trim($userData['name']));
            $hashed['fn'] = [hash('sha256', strtolower($nameParts[0]))];
            if (count($nameParts) > 1) {
                $hashed['ln'] = [hash('sha256', strtolower(end($nameParts)))];
            }
        }
        
        // CPF como external_id
        if (!empty($userData['document'])) {
            $cpf = preg_replace('/\D/', '', $userData['document']);
            $hashed['external_id'] = [hash('sha256', $cpf)];
        }
        
        // País
        $hashed['country'] = [hash('sha256', 'br')];
        
        // IP (sem hash)
        if (!empty($userData['ip'])) {
            $hashed['client_ip_address'] = $userData['ip'];
        }
        
        // User Agent (sem hash)
        if (!empty($userData['user_agent'])) {
            $hashed['client_user_agent'] = $userData['user_agent'];
        }
        
        // FBC (sem hash)
        if (!empty($userData['fbc'])) {
            $hashed['fbc'] = $userData['fbc'];
        }
        
        // FBP (sem hash)
        if (!empty($userData['fbp'])) {
            $hashed['fbp'] = $userData['fbp'];
        }
        
        return $hashed;
    }
    
    /**
     * Prepara userData a partir de UTM data (para webhook)
     */
    private function prepareUserDataFromUtm($utmData) {
        $userData = [];
        
        // Email
        $email = $utmData['customer']['email'] ?? $utmData['email'] ?? null;
        if ($email) {
            $userData['em'] = [hash('sha256', strtolower(trim($email)))];
        }
        
        // Telefone
        $phone = $utmData['customer']['phone'] ?? $utmData['telefone'] ?? $utmData['celular'] ?? null;
        if ($phone) {
            $phone = preg_replace('/\D/', '', $phone);
            if (strlen($phone) <= 11) {
                $phone = '55' . $phone;
            }
            $userData['ph'] = [hash('sha256', $phone)];
        }
        
        // Nome
        $name = $utmData['customer']['name'] ?? $utmData['nome'] ?? null;
        if ($name) {
            $nameParts = explode(' ', trim($name));
            $userData['fn'] = [hash('sha256', strtolower($nameParts[0]))];
            if (count($nameParts) > 1) {
                $userData['ln'] = [hash('sha256', strtolower(end($nameParts)))];
            }
        }
        
        // CPF como external_id
        $cpf = $utmData['customer']['document'] ?? $utmData['cpf'] ?? null;
        if ($cpf) {
            $cpf = preg_replace('/\D/', '', $cpf);
            $userData['external_id'] = [hash('sha256', $cpf)];
        }
        
        // País
        $userData['country'] = [hash('sha256', 'br')];
        
        // IP
        $ip = $utmData['customer_ip'] ?? $utmData['ip'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
        if ($ip) {
            $userData['client_ip_address'] = $ip;
        }
        
        // User Agent
        $userData['client_user_agent'] = $utmData['user_agent'] ?? $_SERVER['HTTP_USER_AGENT'] ?? '';
        
        // FBC
        if (!empty($utmData['fbc'])) {
            $userData['fbc'] = $utmData['fbc'];
        }
        
        // FBP
        if (!empty($utmData['fbp'])) {
            $userData['fbp'] = $utmData['fbp'];
        }
        
        return $userData;
    }
    
    /**
     * Envia para todos os Pixels configurados
     */
    private function sendToAllPixels($payload) {
        $success = true;
        
        // Pixel 1
        $result1 = $this->sendToPixel($this->pixelId, $payload, $this->accessToken);
        if (!$result1) $success = false;
        
        // Pixel 2
        $result2 = $this->sendToPixel($this->pixelId2, $payload, $this->accessToken2);
        if (!$result2) $success = false;
        
        return $success;
    }
    
    /**
     * Envia evento para um Pixel específico
     */
    private function sendToPixel($pixelId, $payload, $accessToken) {
        $url = "https://graph.facebook.com/v18.0/{$pixelId}/events?access_token={$accessToken}";
        
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => true
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        $this->log("Resposta Pixel {$pixelId}", [
            'http_code' => $httpCode,
            'response' => json_decode($response, true),
            'error' => $error ?: null
        ]);
        
        return $httpCode >= 200 && $httpCode < 300;
    }

    /**
     * Log para debug
     */
    private function log($message, $data = []) {
        $logDir = __DIR__ . '/logs';
        if (!is_dir($logDir)) {
            @mkdir($logDir, 0755, true);
        }
        
        $logFile = $logDir . '/facebook_capi.log';
        $timestamp = date('Y-m-d H:i:s');
        
        $logLine = "[$timestamp] $message";
        if (!empty($data)) {
            $logLine .= ' | ' . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        }
        $logLine .= "\n";
        
        @file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
    }
}