<?php
/**
 * ============================================
 * DASHBOARD DE CAMPANHAS - ESTILO UTMIFY
 * ============================================
 * Visualização completa de vendas por campanha
 */

// Proteção com senha (opcional)
$senha = 'carlinhos2024';
$autenticado = !$senha || (isset($_GET['key']) && $_GET['key'] === $senha);

if (!$autenticado && $senha) {
    // Mostra form de login
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['senha'])) {
        if ($_POST['senha'] === $senha) {
            header('Location: ?key=' . $senha);
            exit;
        }
    }
    ?>
    <!DOCTYPE html>
    <html><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login - Dashboard</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: system-ui, sans-serif; background: #0f172a; min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .login { background: #1e293b; padding: 40px; border-radius: 16px; width: 100%; max-width: 400px; }
        h1 { color: #fff; margin-bottom: 24px; font-size: 24px; text-align: center; }
        input { width: 100%; padding: 14px; border: 1px solid #334155; border-radius: 8px; background: #0f172a; color: #fff; font-size: 16px; margin-bottom: 16px; }
        button { width: 100%; padding: 14px; background: #3b82f6; color: #fff; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; }
        button:hover { background: #2563eb; }
    </style>
    </head><body>
    <form class="login" method="POST">
        <h1>🔐 Dashboard</h1>
        <input type="password" name="senha" placeholder="Senha de acesso" autofocus>
        <button type="submit">Entrar</button>
    </form>
    </body></html>
    <?php
    exit;
}

// Configuração
$utmDir = __DIR__ . '/utm_data/';
$dataInicio = $_GET['inicio'] ?? date('Y-m-d', strtotime('-30 days'));
$dataFim = $_GET['fim'] ?? date('Y-m-d');
$filtroStatus = $_GET['status'] ?? 'paid';
$filtroCampanha = $_GET['campanha'] ?? '';
$visualizacao = $_GET['view'] ?? 'campanhas'; // campanhas, conjuntos, anuncios

// Lê todos os arquivos JSON
$arquivos = glob($utmDir . '*.json');
$transacoes = [];

foreach ($arquivos as $arquivo) {
    $conteudo = @file_get_contents($arquivo);
    $dados = json_decode($conteudo, true);
    
    if (!$dados) continue;
    
    // Filtra por status
    if ($filtroStatus === 'paid') {
        $status = strtolower($dados['webhook_status'] ?? '');
        if (!in_array($status, ['paid', 'pago', 'approved', 'confirmed', 'completed'])) {
            continue;
        }
    }
    
    // Filtra por data
    $dataCriacao = $dados['paid_at'] ?? $dados['created_at'] ?? null;
    if ($dataCriacao) {
        $dataTransacao = date('Y-m-d', strtotime($dataCriacao));
        if ($dataTransacao < $dataInicio || $dataTransacao > $dataFim) continue;
    }
    
    $transacoes[] = $dados;
}

// Processa dados
$campanhas = [];
$conjuntos = [];
$anuncios = [];
$totais = ['vendas' => 0, 'faturamento' => 0, 'cotas' => 0];

foreach ($transacoes as $t) {
    $source = $t['utm_source'] ?? 'Direto';
    $campaign = $t['utm_campaign'] ?? 'Sem campanha';
    $medium = $t['utm_medium'] ?? 'Sem conjunto';
    $content = $t['utm_content'] ?? 'Sem anúncio';
    $term = $t['utm_term'] ?? '';
    $valor = ($t['valor_centavos'] ?? 0) / 100;
    $cotas = $t['cotas'] ?? 1;
    $dataVenda = $t['paid_at'] ?? $t['created_at'] ?? date('Y-m-d H:i:s');
    
    // Extrai nome e ID
    $campaignParts = explode('|', $campaign);
    $campaignNome = trim($campaignParts[0]);
    $campaignId = $campaignParts[1] ?? '';
    
    $mediumParts = explode('|', $medium);
    $mediumNome = trim($mediumParts[0]);
    $mediumId = $mediumParts[1] ?? '';
    
    $contentParts = explode('|', $content);
    $contentNome = trim($contentParts[0]);
    $contentId = $contentParts[1] ?? '';
    
    // Totais
    $totais['vendas']++;
    $totais['faturamento'] += $valor;
    $totais['cotas'] += $cotas;
    
    // Por Campanha
    $chaveC = $campaignNome;
    if (!isset($campanhas[$chaveC])) {
        $campanhas[$chaveC] = [
            'nome' => $campaignNome,
            'id' => $campaignId,
            'source' => $source,
            'vendas' => 0,
            'faturamento' => 0,
            'cotas' => 0,
            'ultima_venda' => null,
            'conjuntos' => []
        ];
    }
    $campanhas[$chaveC]['vendas']++;
    $campanhas[$chaveC]['faturamento'] += $valor;
    $campanhas[$chaveC]['cotas'] += $cotas;
    if (!$campanhas[$chaveC]['ultima_venda'] || $dataVenda > $campanhas[$chaveC]['ultima_venda']) {
        $campanhas[$chaveC]['ultima_venda'] = $dataVenda;
    }
    
    // Por Conjunto (dentro da campanha)
    $chaveJ = $mediumNome;
    if (!isset($campanhas[$chaveC]['conjuntos'][$chaveJ])) {
        $campanhas[$chaveC]['conjuntos'][$chaveJ] = [
            'nome' => $mediumNome,
            'id' => $mediumId,
            'vendas' => 0,
            'faturamento' => 0,
            'cotas' => 0,
            'ultima_venda' => null,
            'anuncios' => []
        ];
    }
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['vendas']++;
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['faturamento'] += $valor;
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['cotas'] += $cotas;
    if (!$campanhas[$chaveC]['conjuntos'][$chaveJ]['ultima_venda'] || $dataVenda > $campanhas[$chaveC]['conjuntos'][$chaveJ]['ultima_venda']) {
        $campanhas[$chaveC]['conjuntos'][$chaveJ]['ultima_venda'] = $dataVenda;
    }
    
    // Por Anúncio
    $chaveA = $contentNome;
    if (!isset($campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA])) {
        $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA] = [
            'nome' => $contentNome,
            'id' => $contentId,
            'posicionamento' => $term,
            'vendas' => 0,
            'faturamento' => 0,
            'cotas' => 0,
            'ultima_venda' => null
        ];
    }
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['vendas']++;
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['faturamento'] += $valor;
    $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['cotas'] += $cotas;
    if (!$campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['ultima_venda'] || $dataVenda > $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['ultima_venda']) {
        $campanhas[$chaveC]['conjuntos'][$chaveJ]['anuncios'][$chaveA]['ultima_venda'] = $dataVenda;
    }
    
    // Lista plana de conjuntos
    $chaveConj = $campaignNome . '|' . $mediumNome;
    if (!isset($conjuntos[$chaveConj])) {
        $conjuntos[$chaveConj] = [
            'campanha' => $campaignNome,
            'nome' => $mediumNome,
            'id' => $mediumId,
            'vendas' => 0,
            'faturamento' => 0,
            'cotas' => 0,
            'ultima_venda' => null
        ];
    }
    $conjuntos[$chaveConj]['vendas']++;
    $conjuntos[$chaveConj]['faturamento'] += $valor;
    $conjuntos[$chaveConj]['cotas'] += $cotas;
    if (!$conjuntos[$chaveConj]['ultima_venda'] || $dataVenda > $conjuntos[$chaveConj]['ultima_venda']) {
        $conjuntos[$chaveConj]['ultima_venda'] = $dataVenda;
    }
    
    // Lista plana de anúncios
    $chaveAnun = $campaignNome . '|' . $mediumNome . '|' . $contentNome;
    if (!isset($anuncios[$chaveAnun])) {
        $anuncios[$chaveAnun] = [
            'campanha' => $campaignNome,
            'conjunto' => $mediumNome,
            'nome' => $contentNome,
            'id' => $contentId,
            'posicionamento' => $term,
            'vendas' => 0,
            'faturamento' => 0,
            'cotas' => 0,
            'ultima_venda' => null
        ];
    }
    $anuncios[$chaveAnun]['vendas']++;
    $anuncios[$chaveAnun]['faturamento'] += $valor;
    $anuncios[$chaveAnun]['cotas'] += $cotas;
    if (!$anuncios[$chaveAnun]['ultima_venda'] || $dataVenda > $anuncios[$chaveAnun]['ultima_venda']) {
        $anuncios[$chaveAnun]['ultima_venda'] = $dataVenda;
    }
}

// Ordena por faturamento
uasort($campanhas, fn($a, $b) => $b['faturamento'] <=> $a['faturamento']);
uasort($conjuntos, fn($a, $b) => $b['faturamento'] <=> $a['faturamento']);
uasort($anuncios, fn($a, $b) => $b['faturamento'] <=> $a['faturamento']);

// Funções auxiliares
function brl($v) { return 'R$ ' . number_format($v, 2, ',', '.'); }
function formatarData($d) { return $d ? date('d/m/Y H:i', strtotime($d)) : '-'; }

// JSON export
if (isset($_GET['json'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'periodo' => ['inicio' => $dataInicio, 'fim' => $dataFim],
        'totais' => $totais,
        'campanhas' => $campanhas,
        'conjuntos' => $conjuntos,
        'anuncios' => $anuncios
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$keyParam = $senha ? '&key=' . $senha : '';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Campanhas</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { 
            font-family: Inter, system-ui, sans-serif; 
            background: #0f172a; 
            color: #e2e8f0;
            min-height: 100vh;
        }
        
        /* Header */
        .header {
            background: #1e293b;
            border-bottom: 1px solid #334155;
            padding: 16px 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .header-left { display: flex; align-items: center; gap: 16px; }
        .header h1 { font-size: 18px; font-weight: 700; display: flex; align-items: center; gap: 8px; }
        .header-right { display: flex; align-items: center; gap: 16px; font-size: 13px; }
        .header-stat { text-align: right; }
        .header-stat .label { color: #94a3b8; font-size: 11px; }
        .header-stat .value { font-weight: 700; color: #10b981; }
        
        /* Alerta */
        .alert {
            background: #7c2d12;
            color: #fed7aa;
            padding: 12px 24px;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .alert a { color: #fbbf24; }
        
        /* Tabs */
        .tabs {
            background: #1e293b;
            border-bottom: 1px solid #334155;
            display: flex;
            gap: 0;
        }
        .tab {
            padding: 16px 32px;
            font-size: 14px;
            font-weight: 500;
            color: #94a3b8;
            text-decoration: none;
            border-bottom: 2px solid transparent;
            transition: all 0.2s;
        }
        .tab:hover { color: #e2e8f0; background: rgba(255,255,255,0.05); }
        .tab.active { 
            color: #3b82f6; 
            border-bottom-color: #3b82f6;
            background: rgba(59, 130, 246, 0.1);
        }
        
        /* Filtros */
        .filtros {
            background: #1e293b;
            padding: 16px 24px;
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
            align-items: center;
            border-bottom: 1px solid #334155;
        }
        .filtro-group { display: flex; flex-direction: column; gap: 4px; }
        .filtro-group label { font-size: 11px; color: #94a3b8; font-weight: 500; }
        .filtro-group input, .filtro-group select {
            padding: 8px 12px;
            background: #0f172a;
            border: 1px solid #334155;
            border-radius: 6px;
            color: #e2e8f0;
            font-size: 13px;
        }
        .filtro-group input:focus, .filtro-group select:focus {
            outline: none;
            border-color: #3b82f6;
        }
        .btn {
            padding: 10px 20px;
            background: #3b82f6;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .btn:hover { background: #2563eb; }
        .btn-outline {
            background: transparent;
            border: 1px solid #334155;
            color: #94a3b8;
        }
        .btn-outline:hover { background: #334155; color: #fff; }
        
        /* Badge de vendas */
        .badge-vendas {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            padding: 4px 10px;
            background: #166534;
            color: #4ade80;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        
        /* Tabela */
        .table-container {
            overflow-x: auto;
            padding: 0 24px 24px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 13px;
            min-width: 1200px;
        }
        th {
            background: #1e293b;
            padding: 12px 16px;
            text-align: left;
            font-weight: 600;
            color: #94a3b8;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 1px solid #334155;
        }
        th.right, td.right { text-align: right; }
        td {
            padding: 14px 16px;
            border-bottom: 1px solid #1e293b;
            vertical-align: middle;
        }
        tr:hover td { background: rgba(255,255,255,0.02); }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
        }
        .status-ativo { background: #166534; color: #4ade80; }
        .status-inativo { background: #334155; color: #94a3b8; }
        
        .campanha-nome {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }
        .campanha-nome .nome { font-weight: 600; color: #f1f5f9; }
        .campanha-nome .id { font-size: 11px; color: #64748b; }
        
        .valor-positivo { color: #4ade80; }
        .valor-negativo { color: #f87171; }
        .valor-neutro { color: #94a3b8; }
        
        .data-cell {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }
        .data-cell .info { font-size: 11px; color: #64748b; }
        
        /* Cards de resumo */
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            padding: 24px;
        }
        .card {
            background: #1e293b;
            border: 1px solid #334155;
            border-radius: 12px;
            padding: 20px;
        }
        .card .label { font-size: 12px; color: #94a3b8; margin-bottom: 8px; }
        .card .value { font-size: 28px; font-weight: 800; }
        .card.destaque { 
            background: linear-gradient(135deg, #166534 0%, #15803d 100%);
            border: none;
        }
        .card.destaque .value { color: #fff; }
        .card.destaque .label { color: rgba(255,255,255,0.8); }
        
        /* Toggle */
        .toggle {
            position: relative;
            width: 44px;
            height: 24px;
            background: #334155;
            border-radius: 12px;
            cursor: pointer;
            transition: background 0.2s;
        }
        .toggle.on { background: #3b82f6; }
        .toggle::after {
            content: '';
            position: absolute;
            top: 2px;
            left: 2px;
            width: 20px;
            height: 20px;
            background: #fff;
            border-radius: 50%;
            transition: transform 0.2s;
        }
        .toggle.on::after { transform: translateX(20px); }
        
        /* Responsivo */
        @media (max-width: 768px) {
            .header { flex-direction: column; gap: 12px; }
            .tabs { overflow-x: auto; }
            .tab { padding: 12px 20px; white-space: nowrap; }
            .filtros { flex-direction: column; align-items: stretch; }
            .cards { grid-template-columns: 1fr 1fr; }
        }
        
        /* Linha expandida */
        .row-details {
            display: none;
            background: #0f172a;
        }
        .row-details.show { display: table-row; }
        .row-details td { padding: 0; }
        .details-content {
            padding: 16px 24px 16px 48px;
        }
        .sub-table {
            width: 100%;
            margin: 0;
            min-width: auto;
        }
        .sub-table th { 
            background: #1e293b; 
            position: static;
            font-size: 10px;
        }
        .sub-table td { 
            padding: 10px 12px; 
            font-size: 12px;
            border-bottom-color: #1e293b;
        }
        
        .expand-btn {
            background: none;
            border: none;
            color: #64748b;
            cursor: pointer;
            padding: 4px;
            font-size: 16px;
            transition: transform 0.2s;
        }
        .expand-btn.open { transform: rotate(90deg); color: #3b82f6; }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #64748b;
        }
        .empty-state .icon { font-size: 48px; margin-bottom: 16px; }
    </style>
</head>
<body>

<!-- Header -->
<div class="header">
    <div class="header-left">
        <h1>📊 Dashboard - Principal</h1>
    </div>
    <div class="header-right">
        <div class="header-stat">
            <div class="label">Período</div>
            <div class="value"><?= date('d/m', strtotime($dataInicio)) ?> - <?= date('d/m', strtotime($dataFim)) ?></div>
        </div>
        <div class="header-stat">
            <div class="label">Faturamento</div>
            <div class="value"><?= brl($totais['faturamento']) ?></div>
        </div>
        <span class="badge-vendas">
            <span>🛒</span> <?= $totais['vendas'] ?> vendas
        </span>
    </div>
</div>

<!-- Tabs -->
<div class="tabs">
    <a href="?view=campanhas<?= $keyParam ?>&inicio=<?= $dataInicio ?>&fim=<?= $dataFim ?>" 
       class="tab <?= $visualizacao === 'campanhas' ? 'active' : '' ?>">
        📢 Campanhas
    </a>
    <a href="?view=conjuntos<?= $keyParam ?>&inicio=<?= $dataInicio ?>&fim=<?= $dataFim ?>" 
       class="tab <?= $visualizacao === 'conjuntos' ? 'active' : '' ?>">
        📦 Conjuntos
    </a>
    <a href="?view=anuncios<?= $keyParam ?>&inicio=<?= $dataInicio ?>&fim=<?= $dataFim ?>" 
       class="tab <?= $visualizacao === 'anuncios' ? 'active' : '' ?>">
        🎨 Anúncios
    </a>
</div>

<!-- Filtros -->
<form class="filtros" method="GET">
    <?php if ($senha): ?>
    <input type="hidden" name="key" value="<?= htmlspecialchars($senha) ?>">
    <?php endif; ?>
    <input type="hidden" name="view" value="<?= htmlspecialchars($visualizacao) ?>">
    
    <div class="filtro-group">
        <label>Período de Visualização</label>
        <div style="display: flex; gap: 8px;">
            <input type="date" name="inicio" value="<?= $dataInicio ?>">
            <input type="date" name="fim" value="<?= $dataFim ?>">
        </div>
    </div>
    
    <div class="filtro-group">
        <label>Status</label>
        <select name="status">
            <option value="paid" <?= $filtroStatus === 'paid' ? 'selected' : '' ?>>Somente Pagos</option>
            <option value="all" <?= $filtroStatus === 'all' ? 'selected' : '' ?>>Todos</option>
        </select>
    </div>
    
    <div style="margin-top: 18px; display: flex; gap: 8px;">
        <button type="submit" class="btn">🔍 Atualizar</button>
        <a href="?json=1<?= $keyParam ?>&inicio=<?= $dataInicio ?>&fim=<?= $dataFim ?>" class="btn btn-outline">📥 JSON</a>
    </div>
</form>

<!-- Cards de resumo -->
<div class="cards">
    <div class="card destaque">
        <div class="label">Faturamento Total</div>
        <div class="value"><?= brl($totais['faturamento']) ?></div>
    </div>
    <div class="card">
        <div class="label">Vendas</div>
        <div class="value" style="color: #3b82f6;"><?= $totais['vendas'] ?></div>
    </div>
    <div class="card">
        <div class="label">Cotas Vendidas</div>
        <div class="value" style="color: #f59e0b;"><?= $totais['cotas'] ?></div>
    </div>
    <div class="card">
        <div class="label">Ticket Médio</div>
        <div class="value" style="color: #a855f7;"><?= $totais['vendas'] > 0 ? brl($totais['faturamento'] / $totais['vendas']) : 'R$ 0' ?></div>
    </div>
</div>

<!-- Tabela -->
<div class="table-container">

<?php if ($visualizacao === 'campanhas'): ?>
<!-- Tabela de Campanhas -->
<table>
    <thead>
        <tr>
            <th style="width: 40px;"></th>
            <th>Status</th>
            <th>Campanha</th>
            <th>Fonte</th>
            <th class="right">Última Atualização</th>
            <th class="right">Vendas</th>
            <th class="right">Cotas</th>
            <th class="right">Faturamento</th>
            <th class="right">Ticket Médio</th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($campanhas)): ?>
        <tr>
            <td colspan="9">
                <div class="empty-state">
                    <div class="icon">📭</div>
                    <div>Nenhuma campanha encontrada no período selecionado</div>
                </div>
            </td>
        </tr>
        <?php else: ?>
        <?php $i = 0; foreach ($campanhas as $c): $i++; ?>
        <tr onclick="toggleRow(<?= $i ?>)" style="cursor: pointer;">
            <td><button class="expand-btn" id="btn-<?= $i ?>">▶</button></td>
            <td>
                <span class="status-badge status-ativo">
                    <span style="width: 6px; height: 6px; background: currentColor; border-radius: 50%;"></span>
                    Ativo
                </span>
            </td>
            <td>
                <div class="campanha-nome">
                    <span class="nome"><?= htmlspecialchars($c['nome']) ?></span>
                    <?php if ($c['id']): ?>
                    <span class="id">ID: <?= htmlspecialchars($c['id']) ?></span>
                    <?php endif; ?>
                </div>
            </td>
            <td>
                <span class="status-badge" style="background: #1e3a5f; color: #60a5fa;">
                    <?= htmlspecialchars($c['source'] ?: 'N/A') ?>
                </span>
            </td>
            <td class="right">
                <div class="data-cell">
                    <span><?= formatarData($c['ultima_venda']) ?></span>
                </div>
            </td>
            <td class="right"><strong class="valor-positivo"><?= $c['vendas'] ?></strong></td>
            <td class="right"><?= $c['cotas'] ?></td>
            <td class="right"><strong class="valor-positivo"><?= brl($c['faturamento']) ?></strong></td>
            <td class="right"><?= $c['vendas'] > 0 ? brl($c['faturamento'] / $c['vendas']) : '-' ?></td>
        </tr>
        <!-- Linha expandida com conjuntos -->
        <tr class="row-details" id="row-<?= $i ?>">
            <td colspan="9">
                <div class="details-content">
                    <h4 style="margin-bottom: 12px; color: #94a3b8; font-size: 12px;">📦 Conjuntos de Anúncios</h4>
                    <table class="sub-table">
                        <thead>
                            <tr>
                                <th>Conjunto</th>
                                <th class="right">Vendas</th>
                                <th class="right">Cotas</th>
                                <th class="right">Faturamento</th>
                                <th class="right">Última Venda</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($c['conjuntos'] as $conj): ?>
                            <tr>
                                <td>
                                    <div class="campanha-nome">
                                        <span class="nome"><?= htmlspecialchars($conj['nome']) ?></span>
                                        <?php if ($conj['id']): ?>
                                        <span class="id">ID: <?= htmlspecialchars($conj['id']) ?></span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="right valor-positivo"><?= $conj['vendas'] ?></td>
                                <td class="right"><?= $conj['cotas'] ?></td>
                                <td class="right valor-positivo"><?= brl($conj['faturamento']) ?></td>
                                <td class="right" style="color: #64748b;"><?= formatarData($conj['ultima_venda']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>

<?php elseif ($visualizacao === 'conjuntos'): ?>
<!-- Tabela de Conjuntos -->
<table>
    <thead>
        <tr>
            <th>Campanha</th>
            <th>Conjunto</th>
            <th class="right">Vendas</th>
            <th class="right">Cotas</th>
            <th class="right">Faturamento</th>
            <th class="right">Ticket Médio</th>
            <th class="right">Última Venda</th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($conjuntos)): ?>
        <tr>
            <td colspan="7">
                <div class="empty-state">
                    <div class="icon">📭</div>
                    <div>Nenhum conjunto encontrado</div>
                </div>
            </td>
        </tr>
        <?php else: ?>
        <?php foreach ($conjuntos as $conj): ?>
        <tr>
            <td style="color: #94a3b8; font-size: 12px;"><?= htmlspecialchars($conj['campanha']) ?></td>
            <td>
                <div class="campanha-nome">
                    <span class="nome"><?= htmlspecialchars($conj['nome']) ?></span>
                    <?php if ($conj['id']): ?>
                    <span class="id">ID: <?= htmlspecialchars($conj['id']) ?></span>
                    <?php endif; ?>
                </div>
            </td>
            <td class="right"><strong class="valor-positivo"><?= $conj['vendas'] ?></strong></td>
            <td class="right"><?= $conj['cotas'] ?></td>
            <td class="right"><strong class="valor-positivo"><?= brl($conj['faturamento']) ?></strong></td>
            <td class="right"><?= $conj['vendas'] > 0 ? brl($conj['faturamento'] / $conj['vendas']) : '-' ?></td>
            <td class="right" style="color: #64748b;"><?= formatarData($conj['ultima_venda']) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>

<?php else: ?>
<!-- Tabela de Anúncios -->
<table>
    <thead>
        <tr>
            <th>Campanha</th>
            <th>Conjunto</th>
            <th>Anúncio</th>
            <th>Posicionamento</th>
            <th class="right">Vendas</th>
            <th class="right">Cotas</th>
            <th class="right">Faturamento</th>
            <th class="right">Última Venda</th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($anuncios)): ?>
        <tr>
            <td colspan="8">
                <div class="empty-state">
                    <div class="icon">📭</div>
                    <div>Nenhum anúncio encontrado</div>
                </div>
            </td>
        </tr>
        <?php else: ?>
        <?php foreach ($anuncios as $an): ?>
        <tr>
            <td style="color: #94a3b8; font-size: 11px; max-width: 150px; overflow: hidden; text-overflow: ellipsis;">
                <?= htmlspecialchars($an['campanha']) ?>
            </td>
            <td style="color: #94a3b8; font-size: 11px; max-width: 150px; overflow: hidden; text-overflow: ellipsis;">
                <?= htmlspecialchars($an['conjunto']) ?>
            </td>
            <td>
                <div class="campanha-nome">
                    <span class="nome"><?= htmlspecialchars($an['nome']) ?></span>
                    <?php if ($an['id']): ?>
                    <span class="id">ID: <?= htmlspecialchars($an['id']) ?></span>
                    <?php endif; ?>
                </div>
            </td>
            <td>
                <?php if ($an['posicionamento']): ?>
                <span class="status-badge" style="background: #1e293b; color: #94a3b8;">
                    <?= htmlspecialchars($an['posicionamento']) ?>
                </span>
                <?php else: ?>
                <span style="color: #64748b;">-</span>
                <?php endif; ?>
            </td>
            <td class="right"><strong class="valor-positivo"><?= $an['vendas'] ?></strong></td>
            <td class="right"><?= $an['cotas'] ?></td>
            <td class="right"><strong class="valor-positivo"><?= brl($an['faturamento']) ?></strong></td>
            <td class="right" style="color: #64748b;"><?= formatarData($an['ultima_venda']) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>
<?php endif; ?>

</div>

<!-- Footer -->
<div style="text-align: center; padding: 24px; color: #64748b; font-size: 12px; border-top: 1px solid #1e293b;">
    <?= count($campanhas) ?> campanhas · <?= count($conjuntos) ?> conjuntos · <?= count($anuncios) ?> anúncios<br>
    Atualizado em <?= date('d/m/Y H:i:s') ?>
</div>

<script>
function toggleRow(id) {
    const row = document.getElementById('row-' + id);
    const btn = document.getElementById('btn-' + id);
    
    if (row.classList.contains('show')) {
        row.classList.remove('show');
        btn.classList.remove('open');
    } else {
        // Fecha todos os outros
        document.querySelectorAll('.row-details').forEach(r => r.classList.remove('show'));
        document.querySelectorAll('.expand-btn').forEach(b => b.classList.remove('open'));
        
        row.classList.add('show');
        btn.classList.add('open');
    }
}
</script>

</body>
</html>