<?php
/**
 * ============================================
 * FACEBOOK CAPI - SIMPLIFICADO
 * ============================================
 * Envia eventos de conversão para o Facebook
 */

class FacebookCAPI {
    
    private $pixelId = '3061241000727171';
    private $accessToken = 'EAARtphyE16sBQAYRIu5AVFC9PZAZBSUGA875QI6QdZCHrvk0Q1UVEXALi6fhLQ7pZBJbFhAhggv2k1bIYKZAgpcWdxtGFmPHnauDQhmFhLV0GTMhTBbnsSsQjctdw8mbHPvZAHOuTtxQZCDpBGlX3ZArHdjTTBiv0GHYKAFZB0UAxU0P9GLIqm6ZB3i5Q0VrImZABqldAZDZD';
    private $testEventCode = ''; // Deixe vazio em produção
    
    /**
     * Envia evento Purchase para o Facebook
     */
    public function sendPurchase($txId, $valorReais, $utmData = []) {
        $this->log("Iniciando envio Purchase", [
            'txId' => $txId,
            'valor' => $valorReais
        ]);
        
        // Prepara dados do usuário
        $userData = [];
        
        // Email
        $email = $utmData['customer']['email'] ?? $utmData['email'] ?? null;
        if ($email) {
            $userData['em'] = [hash('sha256', strtolower(trim($email)))];
        }
        
        // Telefone
        $phone = $utmData['customer']['phone'] ?? $utmData['telefone'] ?? $utmData['celular'] ?? null;
        if ($phone) {
            $phone = preg_replace('/\D/', '', $phone);
            if (strlen($phone) <= 11) {
                $phone = '55' . $phone;
            }
            $userData['ph'] = [hash('sha256', $phone)];
        }
        
        // Nome
        $name = $utmData['customer']['name'] ?? $utmData['nome'] ?? null;
        if ($name) {
            $nameParts = explode(' ', trim($name));
            $userData['fn'] = [hash('sha256', strtolower($nameParts[0]))];
            if (count($nameParts) > 1) {
                $userData['ln'] = [hash('sha256', strtolower(end($nameParts)))];
            }
        }
        
        // CPF como external_id
        $cpf = $utmData['customer']['document'] ?? $utmData['cpf'] ?? null;
        if ($cpf) {
            $cpf = preg_replace('/\D/', '', $cpf);
            $userData['external_id'] = [hash('sha256', $cpf)];
        }
        
        // País
        $userData['country'] = [hash('sha256', 'br')];
        
        // IP
        $ip = $utmData['customer_ip'] ?? $utmData['ip'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
        if ($ip) {
            $userData['client_ip_address'] = $ip;
        }
        
        // User Agent
        $userData['client_user_agent'] = $utmData['user_agent'] ?? $_SERVER['HTTP_USER_AGENT'] ?? '';
        
        // FBC (Facebook Click ID)
        if (!empty($utmData['fbc'])) {
            $userData['fbc'] = $utmData['fbc'];
        }
        
        // FBP (Facebook Browser ID)
        if (!empty($utmData['fbp'])) {
            $userData['fbp'] = $utmData['fbp'];
        }
        
        // Dados do evento
        $eventData = [
            'event_name' => 'Purchase',
            'event_time' => time(),
            'event_id' => 'purchase_' . $txId . '_' . time(),
            'event_source_url' => $utmData['source_url'] ?? 'https://checkout-carlinhosmaia.com',
            'action_source' => 'website',
            'user_data' => $userData,
            'custom_data' => [
                'currency' => 'BRL',
                'value' => floatval($valorReais),
                'content_type' => 'product',
                'content_name' => $utmData['produto'] ?? 'Cotas',
                'content_ids' => [$utmData['produto_id'] ?? 'premios-001'],
                'num_items' => intval($utmData['cotas'] ?? 1),
                'order_id' => $txId
            ]
        ];
        
        // Payload para a API
        $payload = ['data' => [$eventData]];
        
        if (!empty($this->testEventCode)) {
            $payload['test_event_code'] = $this->testEventCode;
        }
        
        // URL da API
        $url = "https://graph.facebook.com/v18.0/{$this->pixelId}/events?access_token={$this->accessToken}";
        
        $this->log("Enviando para Facebook API", [
            'event_id' => $eventData['event_id'],
            'value' => $valorReais,
            'has_email' => isset($userData['em']),
            'has_phone' => isset($userData['ph']),
            'has_fbc' => isset($userData['fbc']),
            'has_fbp' => isset($userData['fbp'])
        ]);
        
        // Envia requisição
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => true
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
        curl_close($ch);
        
        $responseData = json_decode($response, true);
        $success = $httpCode >= 200 && $httpCode < 300;
        
        $this->log("Resposta Facebook API", [
            'success' => $success,
            'http_code' => $httpCode,
            'events_received' => $responseData['events_received'] ?? 0,
            'curl_error' => $curlError ?: null
        ]);
        
        return [
            'success' => $success,
            'event_id' => $eventData['event_id'],
            'http_code' => $httpCode,
            'events_received' => $responseData['events_received'] ?? 0,
            'response' => $responseData
        ];
    }
    
    /**
     * Log para debug
     */
    private function log($message, $data = []) {
        $logDir = __DIR__ . '/logs';
        if (!is_dir($logDir)) {
            @mkdir($logDir, 0755, true);
        }
        
        $logFile = $logDir . '/facebook_capi.log';
        $timestamp = date('Y-m-d H:i:s');
        
        $logLine = "[$timestamp] $message";
        if (!empty($data)) {
            $logLine .= ' | ' . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        }
        $logLine .= "\n";
        
        @file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
    }
}
