<?php
// Arquivo: config-tool.php
// Esta ferramenta ajuda a definir as posições dos textos na imagem

// Verificar se é uma requisição POST com coordenadas
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['salvar'])) {
    // Obter posições
    $posicoes = [
        'nome' => [
            'x' => intval($_POST['nome_x']),
            'y' => intval($_POST['nome_y']),
            'tamanho' => intval($_POST['nome_tamanho'])
        ],
        'emissao' => [
            'x' => intval($_POST['emissao_x']),
            'y' => intval($_POST['emissao_y']),
            'tamanho' => intval($_POST['emissao_tamanho'])
        ],
        'vencimento' => [
            'x' => intval($_POST['vencimento_x']),
            'y' => intval($_POST['vencimento_y']),
            'tamanho' => intval($_POST['vencimento_tamanho'])
        ],
        'taxa' => [
            'x' => intval($_POST['taxa_x']),
            'y' => intval($_POST['taxa_y']),
            'tamanho' => intval($_POST['taxa_tamanho'])
        ]
    ];
    
    // Gerar código PHP para ser usado no comprovante.php
    $codigo = "// Coordenadas para inserir os textos\n";
    $codigo .= "\$posicoes = [\n";
    foreach ($posicoes as $campo => $valores) {
        $codigo .= "    '$campo' => ['x' => {$valores['x']}, 'y' => {$valores['y']}, 'tamanho' => {$valores['tamanho']}],\n";
    }
    $codigo .= "];\n";
    
    // Salvar em um arquivo de configuração (opcional)
    file_put_contents('posicoes_config.php', "<?php\n" . $codigo . "\n?>");
    
    $mensagem = "Configurações salvas com sucesso!";
}

// Carregar configurações atuais, se existirem
$posicoes = [
    'nome' => ['x' => 150, 'y' => 100, 'tamanho' => 14],
    'emissao' => ['x' => 150, 'y' => 150, 'tamanho' => 14],
    'vencimento' => ['x' => 150, 'y' => 200, 'tamanho' => 14],
    'taxa' => ['x' => 150, 'y' => 250, 'tamanho' => 14]
];

if (file_exists('posicoes_config.php')) {
    include 'posicoes_config.php';
}

// Função para testar as posições atuais
if (isset($_GET['testar'])) {
    header('Content-Type: image/png');
    
    // Carregar a imagem base
    $imagem_base = 'template.png';
    $imagem = imagecreatefrompng($imagem_base);
    
    if (!$imagem) {
        die('Não foi possível carregar a imagem base');
    }
    
    // Definir cor do texto (preto)
    $cor_texto = imagecolorallocate($imagem, 0, 0, 0);
    $cor_texto_branco = imagecolorallocate($imagem, 255, 255, 255);
    
    // Definir fonte (opcional)
    $fonte = 'arialbd.ttf';
    
    // Adicionar textos de exemplo
    if (file_exists($fonte)) {
        imagettftext($imagem, $posicoes['nome']['tamanho'], 0, $posicoes['nome']['x'], $posicoes['nome']['y'], $cor_texto, $fonte, "Nome de Exemplo");
        imagettftext($imagem, $posicoes['emissao']['tamanho'], 0, $posicoes['emissao']['x'], $posicoes['emissao']['y'], $cor_texto, $fonte, "29/03/2025");
        imagettftext($imagem, $posicoes['vencimento']['tamanho'], 0, $posicoes['vencimento']['x'], $posicoes['vencimento']['y'], $cor_texto_branco, $fonte, "29/03/2025");
        imagettftext($imagem, $posicoes['taxa']['tamanho'], 0, $posicoes['taxa']['x'], $posicoes['taxa']['y'], $cor_texto_branco, $fonte, "R$ 59,90");
    } else {
        imagestring($imagem, 5, $posicoes['nome']['x'], $posicoes['nome']['y'], "Nome de Exemplo", $cor_texto);
        imagestring($imagem, 5, $posicoes['emissao']['x'], $posicoes['emissao']['y'], "29/03/2025", $cor_texto);
        imagestring($imagem, 5, $posicoes['vencimento']['x'], $posicoes['vencimento']['y'], "29/03/2025", $cor_texto_branco);
        imagestring($imagem, 5, $posicoes['taxa']['x'], $posicoes['taxa']['y'], "R$ 59,90", $cor_texto_branco);
    }
    
    // Mostrar coordenadas na imagem para referência
    $cor_coord = imagecolorallocate($imagem, 255, 0, 0);
    foreach ($posicoes as $campo => $pos) {
        imagefilledellipse($imagem, $pos['x'], $pos['y'], 5, 5, $cor_coord);
    }
    
    // Gerar a imagem
    imagepng($imagem);
    imagedestroy($imagem);
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuração de Posições</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-7xl mx-auto bg-white rounded-xl shadow-md overflow-hidden p-6">
        <h1 class="text-2xl font-bold text-center mb-6">Configuração de Posições do Texto</h1>
        
        <?php if (isset($mensagem)): ?>
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            <?php echo $mensagem; ?>
        </div>
        <?php endif; ?>
        
        <div class="flex flex-col md:flex-row gap-6">
            <div class="md:w-1/2">
                <h2 class="text-xl font-semibold mb-4">Definir Posições</h2>
                <form method="post" class="space-y-6">
                    <!-- Nome -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-medium mb-2">Campo: Nome</h3>
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição X</label>
                                <input type="number" name="nome_x" value="<?php echo $posicoes['nome']['x']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição Y</label>
                                <input type="number" name="nome_y" value="<?php echo $posicoes['nome']['y']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Tamanho Fonte</label>
                                <input type="number" name="nome_tamanho" value="<?php echo $posicoes['nome']['tamanho']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Emissao -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-medium mb-2">Campo: Emissao</h3>
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição X</label>
                                <input type="number" name="emissao_x" value="<?php echo $posicoes['emissao']['x']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição Y</label>
                                <input type="number" name="emissao_y" value="<?php echo $posicoes['emissao']['y']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Tamanho Fonte</label>
                                <input type="number" name="emissao_tamanho" value="<?php echo $posicoes['emissao']['tamanho']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                        </div>
                    </div>

                    <!-- Vencimento -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-medium mb-2">Campo: Vencimento</h3>
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição X</label>
                                <input type="number" name="vencimento_x" value="<?php echo $posicoes['vencimento']['x']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição Y</label>
                                <input type="number" name="vencimento_y" value="<?php echo $posicoes['vencimento']['y']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Tamanho Fonte</label>
                                <input type="number" name="vencimento_tamanho" value="<?php echo $posicoes['vencimento']['tamanho']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Taxa -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-medium mb-2">Campo: Taxa</h3>
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição X</label>
                                <input type="number" name="taxa_x" value="<?php echo $posicoes['taxa']['x']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Posição Y</label>
                                <input type="number" name="taxa_y" value="<?php echo $posicoes['taxa']['y']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Tamanho Fonte</label>
                                <input type="number" name="taxa_tamanho" value="<?php echo $posicoes['taxa']['tamanho']; ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex space-x-4">
                        <button type="submit" name="salvar" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Salvar Configurações
                        </button>
                        <a href="?testar=1" target="_blank" class="inline-flex justify-center py-2 px-4 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Testar Posições Atuais
                        </a>
                    </div>
                </form>
            </div>
            
            <div class="md:w-1/2">
                <h2 class="text-xl font-semibold mb-4">Visualização</h2>
                <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 flex justify-center">
                    <img src="?testar=1" alt="Preview da configuração" class="max-w-full h-auto">
                </div>
                
                <div class="mt-6">
                    <h3 class="text-lg font-medium mb-2">Código Gerado</h3>
                    <pre class="bg-gray-800 text-white p-4 rounded-md overflow-x-auto">
$posicoes = [
    'nome' => ['x' => <?php echo $posicoes['nome']['x']; ?>, 'y' => <?php echo $posicoes['nome']['y']; ?>, 'tamanho' => <?php echo $posicoes['nome']['tamanho']; ?>],
    'emissao' => ['x' => <?php echo $posicoes['emissao']['x']; ?>, 'y' => <?php echo $posicoes['emissao']['y']; ?>, 'tamanho' => <?php echo $posicoes['emissao']['tamanho']; ?>],
    'vencimento' => ['x' => <?php echo $posicoes['vencimento']['x']; ?>, 'y' => <?php echo $posicoes['vencimento']['y']; ?>, 'tamanho' => <?php echo $posicoes['vencimento']['tamanho']; ?>],
    'taxa' => ['x' => <?php echo $posicoes['taxa']['x']; ?>, 'y' => <?php echo $posicoes['taxa']['y']; ?>, 'tamanho' => <?php echo $posicoes['taxa']['tamanho']; ?>]; ?>]
];
                    </pre>
                </div>
            </div>
        </div>
    </div>
</body>
</html>