<?php
// Arquivo: comprovante.php

// Token válido para acesso
$valid_token = '1tl4LKWefNgnh0Z3pYD0Ag';

// Verificar se os parâmetros obrigatórios foram enviados
if (!isset($_GET['token']) || $_GET['token'] !== $valid_token) {
    die('Token inválido ou não fornecido');
}

date_default_timezone_set('America/Sao_Paulo');

// Obter parâmetros da URL
$nome = isset($_GET['nome']) ? urldecode($_GET['nome']) : '';
$emissao = isset($_GET['emissao']) && !empty($_GET['emissao']) ? urldecode($_GET['emissao']) : date('d/m/Y');
$vencimento = isset($_GET['vencimento']) && !empty($_GET['vencimento']) ? urldecode($_GET['vencimento']) : date('d/m/Y');
$taxa = isset($_GET['taxa']) ? urldecode($_GET['taxa']) : '';

// Se for uma solicitação para a imagem
if (isset($_GET['get_image'])) {
    // Configurações para gerar a imagem
    header('Content-Type: image/png');
    
    // Carregar a imagem base (template do comprovante)
    $imagem_base = 'template.png'; // Substitua pelo caminho real da sua imagem
    $imagem = imagecreatefrompng($imagem_base);
    
    if (!$imagem) {
        die('Não foi possível carregar a imagem base');
    }
    
    // Definir cor do texto
    $cor_texto = imagecolorallocate($imagem, 0, 0, 0);
    $cor_texto_branco = imagecolorallocate($imagem, 255, 255, 255);
    
    // Definir fonte
    $fonte = 'arialbd.ttf';
    
    // Coordenadas para inserir os textos
    $posicoes = [
        'nome' => ['x' => 27, 'y' => 215, 'tamanho' => 18],
        'emissao' => ['x' => 222, 'y' => 292, 'tamanho' => 18],
        'vencimento' => ['x' => 700, 'y' => 292, 'tamanho' => 18],
        'taxa' => ['x' => 700, 'y' => 372, 'tamanho' => 18],
    ];
    
    // Inserir textos na imagem
    if (file_exists($fonte)) {
        // Com fonte TrueType
        imagettftext($imagem, $posicoes['nome']['tamanho'], 0, $posicoes['nome']['x'], $posicoes['nome']['y'], $cor_texto, $fonte, $nome);
        imagettftext($imagem, $posicoes['emissao']['tamanho'], 0, $posicoes['emissao']['x'], $posicoes['emissao']['y'], $cor_texto, $fonte, $emissao);
        imagettftext($imagem, $posicoes['vencimento']['tamanho'], 0, $posicoes['vencimento']['x'], $posicoes['vencimento']['y'], $cor_texto_branco, $fonte, $vencimento);
        imagettftext($imagem, $posicoes['taxa']['tamanho'], 0, $posicoes['taxa']['x'], $posicoes['taxa']['y'], $cor_texto_branco, $fonte, 'R$ ' . $taxa);
    } else {
        // Fallback para fonte padrão
        imagestring($imagem, 5, $posicoes['nome']['x'], $posicoes['nome']['y'], $nome, $cor_texto);
        imagestring($imagem, 5, $posicoes['emissao']['x'], $posicoes['emissao']['y'], $emissao, $cor_texto);
        imagestring($imagem, 5, $posicoes['vencimento']['x'], $posicoes['vencimento']['y'], $vencimento, $cor_texto_branco);
        imagestring($imagem, 5, $posicoes['taxa']['x'], $posicoes['taxa']['y'], 'R$ ' . $taxa, $cor_texto_branco);
    }
    
    // Gerar a imagem de saída
    imagepng($imagem);
    
    // Liberar memória
    imagedestroy($imagem);
    exit; // Termina a execução aqui para não processar o HTML
}

// Se não for a solicitação da imagem, exibe a página HTML
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reparação Governamental</title>
  <style>
        .container {
            position: relative;
            width: 95%;
            max-width: 800px; /* Aumentei o tamanho máximo */
            margin: 0 auto;
            padding-bottom: 100%; /* Aumentei para mostrar mais da imagem */
            background-size: contain;
            background-position: center;
            background-repeat: no-repeat;
        }
    </style>
</head>
<body>
    <!-- Aqui usamos um src que aponta para o mesmo script, mas com o parâmetro get_image -->
    <div class="container" style="background-image: url('<?php echo $_SERVER['PHP_SELF'] . '?' . http_build_query(array_merge($_GET, ['get_image' => 1])); ?>');">
    </div>
</body>
</html>