<?php
// consulta.php - Este arquivo só aceita requisições do servidor ou do site autorizado
header('Content-Type: application/json');

// 1. Restrição por IP e domínio
$ips_permitidos = array(
    '172.98.73.38',    // IP DO SERVIDOR PHP
    '193.203.174.161', // IP DO TYPEBOT
    '127.0.0.1',       // localhost (para testes locais)
    '::1',             // localhost IPv6 (para testes locais)
    'localhost'        // nome do localhost
);

// Domínios permitidos
$dominios_permitidos = array(
    'https://indenizebrasil.com/',
    'https://canal-gvonline.com/',
    // Adicione outros domínios conforme necessário
);

// Verificar se o IP está na lista de permitidos
$ip_cliente = $_SERVER['REMOTE_ADDR'];
$acesso_permitido = false;

// 1. Primeiro verifica se é um IP permitido
if (in_array($ip_cliente, $ips_permitidos)) {
    $acesso_permitido = true;
    // É um IP permitido, permite qualquer origem (para flexibilidade do servidor)
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST');
} else {
    // 2. Se não for um IP permitido, verificar o Origin/Referer
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
    
    // Verifica se o origin ou referer começa com um dos domínios permitidos
    foreach ($dominios_permitidos as $dominio) {
        if (strpos($origin, $dominio) === 0 || strpos($referer, $dominio) === 0) {
            $acesso_permitido = true;
            // Define o CORS para permitir apenas este domínio específico
            header('Access-Control-Allow-Origin: ' . $origin);
            header('Access-Control-Allow-Methods: GET, POST');
            break;
        }
    }
}

// Se não estiver autorizado, bloqueia o acesso
//Origem não autorizada.
if (!$acesso_permitido) {
    echo json_encode(['erro' => 'Acesso negado. ORG N ATRZ.']);
    http_response_code(403); // Forbidden
    exit;
}

// Dados da API (protegidos no servidor)
$token = 'r3xjx15z4ksksksks8fkk2xx';
$api_base = 'https://app.metadisparo.pro/consultar-filtrada/cpf';

// Verifica se o CPF foi fornecido
if (isset($_GET['cpf']) && !empty($_GET['cpf'])) {
    $cpf = $_GET['cpf'];
    
    // Sanitiza o CPF (remove caracteres não numéricos)
    $cpf = preg_replace('/[^0-9]/', '', $cpf);
    
    // Verifica se o CPF tem 11 dígitos
    if (strlen($cpf) !== 11) {
        echo json_encode(['erro' => 'CPF inválido']);
        http_response_code(400); // Bad Request
        exit;
    }
    
    // Monta a URL da API
    $apiUrl = $api_base . "?cpf={$cpf}&token={$token}";
    
    // Inicializa o cURL
    $ch = curl_init();
    
    // Configura as opções do cURL
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Desativa verificação SSL
    
    // Executa a requisição
    $response = curl_exec($ch);
    
    // Verifica se houve erro na requisição
    if(curl_errno($ch)) {
        echo json_encode(['erro' => 'Erro na consulta: ' . curl_error($ch)]);
        http_response_code(500); // Internal Server Error
        exit;
    }
    
    // Fecha a sessão cURL
    curl_close($ch);
    
    // Retorna a resposta da API
    echo $response;
} else {
    // CPF não fornecido
    echo json_encode(['erro' => 'CPF não foi fornecido']);
    http_response_code(400); // Bad Request
}
?>