function animateBar(barId, imgId) {
  const traco = document.getElementById(barId);
  let startTime = null;
  window.requestAnimationFrame(function step(timestamp) {
    startTime || (startTime = timestamp);
    const progress = timestamp - startTime,
      percentage = Math.min(progress / 900, 1);
    (traco.style.background = `linear-gradient(to right, #E5E7EB 0%, #E5E7EB ${
      63 * (1 - percentage)
    }%, #4CAF50 ${63 * (1 - percentage)}%, #4CAF50 100%)`),
      (traco.style.background = `linear-gradient(to right, #4CAF50 ${
        100 * percentage
      }%, #E5E7EB ${100 * percentage}%)`),
      progress < 900
        ? window.requestAnimationFrame(step)
        : ((traco.style.background = "#4CAF50"),
          (document.getElementById(imgId).src =
            "img3" == imgId
              ? "./images/failed.svg?" + imgId
              : "./images/success.svg?" + imgId));
  });
}
function showProgressAndCheck(barId, checkId, imgId, textId, delay) {
  setTimeout(() => {
    animateBar(barId, imgId),
      setTimeout(() => {
        "check3" === checkId &&
          setTimeout(() => {
            document.getElementById("more-information").style.opacity = 1;
            //(document.getElementById("more-information").style.opacity = 1),
            //(document.getElementById("show-offer").disabled = !1);
          }, 1500);
      }, 900);
  }, delay);
}
document.addEventListener("DOMContentLoaded", function () {
  showProgressAndCheck("bar1", "check1", "img1", "text1", 0),
    showProgressAndCheck("bar2", "check2", "img2", "text2", 2e3),
    showProgressAndCheck("bar3", "check3", "img3", "text3", 4e3);
});
