<?php

class PixPayment
{
    private $apiUrl;
    private $apiToken;

    public function __construct($apiUrl, $apiToken)
    {
        $this->apiUrl = $apiUrl;
        $this->apiToken = $apiToken;
    }
    
    private function generateNumericOrderId()
    {
        return time() . mt_rand(1000, 9999);
    }

    // Gera UUID (para orderId e productId)
    private function generateUUID()
    {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }

    // Função para enviar a requisição à API
    public function sendRequest($data)
    {
        $headers = [
            "Content-Type: application/json",
            "x-api-token: " . $this->apiToken
        ];

        $ch = curl_init($this->apiUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return ['response' => $response, 'status_code' => $httpCode];
    }
    
    // Função para processar o pedido de Pix Pago
    public function myPix($customerData, $status)
    {
        $mockedData = [
            'orderId' => $this->generateNumericOrderId(), //esse uuuid vai ter que ser gerado na tela do checkout transparente, sempre tem q ser diferente HASH (this->generateUUID()) so q na tela checkout
            'platform' => 'rpxPay',
            'paymentMethod' => 'pix',
            'status' => $status, // <-- Aqui agora usa o status recebido
            'createdAt' => date('Y-m-d H:i:s'), // Data e hora corrente para createdAt (visto que está sendo pago na hora da call na api)
            'approvedDate' => date('Y-m-d H:i:s'), // Data e hora corrente para approvedDate (visto que está sendo pago na hora da call na api)
            'refundedAt' => null, //Nulo pois não houve refund
            'customer' => [
                'name' => $customerData['name'], //Nome do comprador
                'email' => $customerData['email'], //E-mail do comprador
                'phone' => $customerData['phone'], //Telefone do comprador
                'document' => $customerData['document'], //CPF ou CNPJ do comprador
                'country' => 'BR' //País do comprador no formato ISO 3166-1 alfa-2. Não é um campo obrigatório
                //'ip' => $customerData['ip'] //Ip do comprador. Não é um campo obrigatório, porém, é recomendado o envio para um melhor rastreamento das vendas
            ],
            'products' => [
                [
                    'id' => '9d9c4da9-477d-44f2-8b79-76b8d26a7d00', //Identificação do produto (fixo pois sempre vai ser o mesmo produto?)
                    'name' => 'UP1', //Nome do produto
                    'planId' => null, //Id do plano (caso a plataforma disponibilize opção de múltiplos planos para o mesmo produto). Caso não possua essa opção, informe como null
                    'planName' => null, ///Nome do plano (caso a plataforma disponibilize opção de múltiplos planos para o mesmo produto). Caso não possua essa opção, informe como null
                    'quantity' => 1, //Quantidade comprada do produto
                    'priceInCents' => 4782 //Preço do produto na plataforma de vendas
                ]
            ],
            'trackingParameters' => [
                'utm_source' => $customerData['trackingParameters']['utm_source'] ?? null, //Valor do utm_source extraído da url do checkout. Caso o checkout não possua essa variável no momento do pedido, enviar como null
                'utm_campaign' => $customerData['trackingParameters']['utm_campaign'] ?? null, //Valor do utm_campaign extraído da url do checkout. Caso o checkout não possua essa variável no momento do pedido, enviar como null
                'utm_medium' => $customerData['trackingParameters']['utm_medium'] ?? null, //Valor do utm_medium extraído da url do checkout. Caso o checkout não possua essa variável no momento do pedido, enviar como null
                'utm_content' => $customerData['trackingParameters']['utm_content'] ?? null, //Valor do utm_content extraído da url do checkout. Caso o checkout não possua essa variável no momento do pedido, enviar como null
                'utm_term' => $customerData['trackingParameters']['utm_term'] ?? null //Valor do utm_term extraído da url do checkout. Caso o checkout não possua essa variável no momento do pedido, enviar como null
            ],
            'commission' => [
                'totalPriceInCents' => 4782, //Valor total da transação, em centavos
                'gatewayFeeInCents' => 0, //Valor recebido pela plataforma, em centavos //taxa gateway
                'userCommissionInCents' => 4782 //Valor recebido pelo vendedor, em centavos
            ],
            'isTest' => false
        ];

        return $this->sendRequest($mockedData);
    }
    
}