<?php
require 'PixPayment.php';

// Token correto (o que você considera válido)
$validToken = "d1e3be12-16b4-440c-804e-f41f4ea96b80";

// Recebe o token da URL (query string)
$receivedToken = $_GET['token'] ?? null;

if ($receivedToken !== $validToken) {
    // Token inválido
    header('Content-Type: application/json');
    http_response_code(401); // Unauthorized
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid token'
    ]);
    exit;
}

// URL da API e token da API
$apiUrl = "https://api.utmify.com.br/api-credentials/orders";
$apiToken = "wOr8KDhEJJkLpKH5aCuZXWEiAej6E9aO46Rk";

// Instancia a classe PixPayment
$pixPayment = new PixPayment($apiUrl, $apiToken);

// Recebe os dados enviados pelo AJAX (JSON)
$postData = json_decode(file_get_contents('php://input'), true);

// Verifica campos obrigatórios
if (!empty($postData['orderId']) && !empty($postData['customer']) && !empty($postData['products']) && !empty($postData['trackingParameters']) && !empty($postData['commission'])) {
    $response = $pixPayment->pix($postData);

    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'data' => json_decode($response['response'], true),
        'http_code' => $response['status_code']
    ]);
} else {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required fields'
    ]);
}
