<?php
// Função para registrar logs de forma centralizada
function logMessage($file, $message) {
    file_put_contents($file, "[" . date("Y-m-d H:i:s") . "] " . $message . "\n", FILE_APPEND);
}

// Chaves de API
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';
$UTMify_Token = '3uwgd9W2qWRgPv6LcfQjfv0n1hkMitcgilZH';
$UTMify_url = 'https://api.utmify.com.br/api-credentials/orders';


// Captura o payload do webhook
$input = file_get_contents('php://input');
logMessage('ativo_pay_debug.log', "Payload bruto recebido: $input");

// Decodifica os dados
$data = json_decode($input, true);
if (!$data) {
    logMessage('error_log.log', "Dados do webhook inválidos ou não decodificados: $input");
    exit("Erro: Dados inválidos.");
}

// Verificar se os dados estão dentro da chave `data`
$data = $data['data'] ?? $data;

// Validação básica
if (empty($data)) {
    logMessage('error_log.log', "Dados ausentes no payload.");
    exit("Erro: Dados ausentes no payload.");
}

/// Extrair informações da transação
$id_transacao = $data['id'] ?? null;
$status = $data['status'] ?? null;
$price = $data['amount'] ?? null;

// Validação e mapeamento de `customer`
$customer = $data['customer'] ?? [];
$customer_name = $customer['name'] ?? null;
$customer_email = $customer['email'] ?? null;
$customer_document = $customer['document']['number'] ?? null;
$customer_phone = $customer['phone'] ?? null;

// Localizar e carregar as UTMs salvas no QR Code
$utm_file = "utm_storage2/{$id_transacao}.json";
if (file_exists($utm_file)) {
    $utm_data = json_decode(file_get_contents($utm_file), true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        logMessage('utm_debug.log', "Erro ao decodificar arquivo JSON $utm_file: " . json_last_error_msg());
        $utm_data = [
            'utm_source' => 'not_provided',
            'utm_medium' => 'not_provided',
            'utm_campaign' => 'not_provided',
            'utm_term' => 'not_provided',
            'utm_content' => 'not_provided',
        ];
    } else {
        logMessage('utm_debug.log', "UTMs recuperadas do arquivo $utm_file: " . json_encode($utm_data));
    }
} else {
    logMessage('utm_debug.log', "Arquivo de UTMs não encontrado para $id_transacao.");
    $utm_data = [
        'utm_source' => 'not_provided',
        'utm_medium' => 'not_provided',
        'utm_campaign' => 'not_provided',
        'utm_term' => 'not_provided',
        'utm_content' => 'not_provided',
    ];
}
$desiredProductName = 'Ebook - Vida Nova';

// Validação e mapeamento de `products`
$products = $data['products'] ?? $data['items'] ?? [];
$product_info = [];

if (!empty($products)) {
    foreach ($products as $product) {
        // Verifique se o produto atende ao critério
        if (($product['title'] ?? '') === $desiredProductName) {
            $product_info[] = [
                'id' => 'PROD01',
                'name' => $product['title'] ?? $desiredProductName,
                'planId' => 'PLAN01',
                'planName' => 'Plano Mensal',
                'quantity' => $product['quantity'] ?? 1,
                'priceInCents' => $product['priceInCents'] ?? $product['unitPrice'] ?? 8131,
            ];
            break; // Envia apenas o primeiro produto que atende ao critério
        }
    }
}

// Se nenhum produto correspondente for encontrado, registre no log e interrompa o processamento
if (empty($product_info)) {
    logMessage('product_filter_log.log', "Transação {$data['id']}: Produto não permitido ou não encontrado. Dados dos produtos: " . json_encode($products, JSON_UNESCAPED_UNICODE));
    exit("Erro: Produto não permitido ou não encontrado.");
}

// Validação de campos obrigatórios
$missing_fields = [];
if (!$id_transacao) $missing_fields[] = 'id';
if (!$status) $missing_fields[] = 'status';
if (!$price) $missing_fields[] = 'amount';
if (!$customer_name) $missing_fields[] = 'customer.name';
if (!$customer_email) $missing_fields[] = 'customer.email';
if (empty($product_info)) $missing_fields[] = 'products';

if (!empty($missing_fields)) {
    logMessage('error_log.log', "Campos obrigatórios ausentes na transação $id_transacao: " . implode(', ', $missing_fields));
    exit("Erro: Campos obrigatórios ausentes: " . implode(', ', $missing_fields));
}

// Preparar e enviar os dados para UTMify
$infoVenda = [
    'orderId' => $id_transacao,
    'platform' => 'AtivoPay',
    'paymentMethod' => $data['paymentMethod'] ?? 'pix',
    'status' => $status,
    'createdAt' => $data['createdAt'] ?? gmdate('Y-m-d\TH:i:s\Z'),
    'approvedDate' => $data['updatedAt'] ?? null,
    'customer' => [
        'name' => $customer_name,
        'email' => $customer_email,
        'phone' => $customer_phone ? '+55' . $customer_phone : null,
        'document' => $customer_document,
        'country' => 'BR',
        'ip' => $_SERVER['REMOTE_ADDR'] ?? null,
    ],
    'products' => $product_info,
    'trackingParameters' => [
    'utm_campaign' => $utm_data['utm_campaign'] ?? 'not_provided',
    'utm_content' => $utm_data['utm_content'] ?? 'not_provided',
    'utm_medium' => $utm_data['utm_medium'] ?? 'not_provided',
    'utm_source' => $utm_data['utm_source'] ?? 'not_provided',
    'utm_term' => $utm_data['utm_term'] ?? 'not_provided',
],
    'commission' => [
        'totalPriceInCents' => $price,
        'gatewayFeeInCents' => $data['fee']['fixedAmount'] ?? 0,
        'userCommissionInCents' => $data['fee']['netAmount'] ?? 0,
        'currency' => 'BRL',
    ],
    'isTest' => false,
];

// Logar as UTMs no payload
logMessage('utmify_debug.log', "UTMs incluídas no payload para UTMify: " . json_encode($infoVenda['trackingParameters']));

// Enviar os dados para o UTMify
$arrayInfo = json_encode($infoVenda, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
logMessage('utmify_request_log.log', "Corpo da requisição para UTMify (Transação $id_transacao): $arrayInfo");

// Enviar para o UTMify
$UTMify_curl = curl_init();
curl_setopt_array($UTMify_curl, [
    CURLOPT_URL => $UTMify_url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $arrayInfo,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'x-api-token: ' . $UTMify_Token,
    ],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYHOST => 2,
    CURLOPT_SSL_VERIFYPEER => true,
]);

$UTMify_response = curl_exec($UTMify_curl);
$UTMify_error = curl_error($UTMify_curl);
curl_close($UTMify_curl);

if ($UTMify_response) {
    logMessage('utmify_response_log.log', "Resposta do UTMify (Transação $id_transacao): $UTMify_response");
} else {
    logMessage('utmify_error_log.log', "Erro ao enviar para o UTMify (Transação $id_transacao): $UTMify_error");
    exit("Erro ao enviar para o UTMify.");
}

exit("Webhook processado com sucesso.");