<?php
// Configurações
$sk = "sk_k4m1b1FsHf9TS_iaJnEJZbhHEM94XK-lxuPfemLil2RQUxtb";
$pk = "pk_MEmJVg36z3XYtJKourVV3meggnbs5SqZXB28Qi_TFoTKyfdY";
$authHeader = 'Authorization: Basic ' . base64_encode("$sk:$pk");

// Recebido via POST
$id_transacao = $_POST['id_transacao_post'] ?? '';
$sck = $_POST['sck_post'] ?? '';
$src = $_POST['src_post'] ?? '';
$utm_campaign = $_POST['utm_campaign_post'] ?? '';
$utm_content = $_POST['utm_content_post'] ?? '';
$utm_medium = $_POST['utm_medium_post'] ?? '';
$utm_source = $_POST['utm_source_post'] ?? '';
$utm_term = $_POST['utm_term_post'] ?? '';

// Função para registrar logs de forma centralizada
function logMessage($file, $message) {
    file_put_contents($file, "[" . date("Y-m-d H:i:s") . "] " . $message . "\n", FILE_APPEND);
}

// Verificação inicial
if (empty($id_transacao)) {
    logMessage('error_log.log', "ID da transação ausente");
    exit("Erro: ID da transação não fornecido.");
}

// Função para fazer requisição cURL
function makeRequest($url, $method, $data = null, $authHeader = null) {
    $curl = curl_init($url);
    $headers = ['Content-Type: application/json'];
    if ($authHeader) {
        $headers[] = $authHeader;
    }

    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

    if ($data) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    if ($response === false) {
        $error = curl_error($curl);
        curl_close($curl);
        return ['error' => $error, 'httpCode' => $httpCode];
    }

    curl_close($curl);
    return ['response' => json_decode($response, true), 'httpCode' => $httpCode];
}

// Consultar status da transação Pix
function getPixTransactionStatus($authHeader, $transactionId) {
    $url = "https://api.allowpayments.com.br/api/v1/transactions/$transactionId"; // Usando o ID da transação
    return makeRequest($url, 'GET', null, $authHeader);
}

// Obter status da transação
$transactionStatus = getPixTransactionStatus($authHeader, $id_transacao);

// Log do retorno da API
if (isset($transactionStatus['response'])) {
    logMessage('logs/api_response_log.log', "Resposta da API: " . json_encode($transactionStatus['response']));
    echo json_encode($transactionStatus['response']);
} else {
    logMessage('logs/api_error_log.log', "Erro na API: " . json_encode($transactionStatus));
    exit("Erro na comunicação com a API.");
}
?>
