<?php
// Configurações das chaves
$sk = "sk_k4m1b1FsHf9TS_iaJnEJZbhHEM94XK-lxuPfemLil2RQUxtb";
$pk = "pk_MEmJVg36z3XYtJKourVV3meggnbs5SqZXB28Qi_TFoTKyfdY";
$authHeader = 'Authorization: Basic ' . base64_encode("$sk:$pk");

// Dados recebidos via POST
$valor = 8131;  // Valor em centavos
$nome = $_POST['nome'];
$email = $_POST['email'];
$doc_tipo = $_POST['doc_tipo'] ?? 'cpf';
$doc_num = $_POST['doc_num'];

// Captura as UTMs enviadas via POST
$utm_source = $_POST['utm_source'] ?? 'not_provided';
$utm_medium = $_POST['utm_medium'] ?? 'not_provided';
$utm_campaign = $_POST['utm_campaign'] ?? 'not_provided';
$utm_term = $_POST['utm_term'] ?? 'not_provided';
$utm_content = $_POST['utm_content'] ?? 'not_provided';

// Função para fazer requisição cURL
function makeRequest($url, $method, $data = null, $authHeader = null) {
    $curl = curl_init($url);
    $headers = ['Content-Type: application/json'];
    if ($authHeader) {
        $headers[] = $authHeader;
    }

    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

    if ($data) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    return ['response' => json_decode($response, true), 'httpCode' => $httpCode];
}

// Criar transação Pix
function createPixTransaction($authHeader, $amount, $nome, $email, $doc_num, $doc_tipo) {
    $url = 'https://api.allowpayments.com.br/api/v1/transactions';
    $data = [
        "ip" => "38.50.153.154",  // IP do cliente
        "pix" => ["expiresInDays" => 1],  // Expiração do Pix
        "items" => [[
            "title" => "Ebook - Vida Nova",
            "quantity" => 1,
            "tangible" => false,
            "unitPrice" => $amount
        ]],
        "amount" => $amount,  // Valor total
        "customer" => [
            "name" => $nome,
            "email" => $email,
            "phone" => "00000000000",  // Telefone fictício
            "document" => [
                "type" => $doc_tipo,
                "number" => $doc_num
            ]
        ],
        "externalRef" => "refExterna",  // Referência externa
        "postbackUrl" => "https://seu-site.com/postback",  // URL de postback
        "paymentMethod" => "pix"
    ];

    return makeRequest($url, 'POST', $data, $authHeader);
}

// Execução da transação Pix
$pixTransaction = createPixTransaction($authHeader, $valor, $nome, $email, $doc_num, $doc_tipo);

if ($pixTransaction['httpCode'] == 200 && isset($pixTransaction['response']['data'])) {
    $data = $pixTransaction['response']['data'];
    $qrcode = $data['pix']['qrcode'];
    $id = $data['id'];
    $amount = $data['amount'];

    // Função para armazenar UTMs
    function storeUTMData($id, $utm_data) {
        $utm_file = "utm_storage2/{$id}.json";
        if (!file_exists('utm_storage2')) {
            mkdir('utm_storage2', 0777, true); // Cria o diretório, se necessário
        }
        file_put_contents($utm_file, json_encode($utm_data));
    }

    // Função para log de depuração
    function logDebug($message) {
        file_put_contents('utm_debug.log', "[" . date("Y-m-d H:i:s") . "] $message\n", FILE_APPEND);
    }

    // Dados UTM
   $utm_data = [
            'utm_source' => $utm_source,
            'utm_medium' => $utm_medium,
            'utm_campaign' => $utm_campaign,
            'utm_term' => $utm_term,
            'utm_content' => $utm_content,
            'id_transacao' => $id
        ];
        $utm_file = "utm_storage2/{$id}.json";
        file_put_contents($utm_file, json_encode($utm_data));

    // Retorna o QR Code e informações adicionais
    $result = [
        'qrcode' => $qrcode,
        'id' => $id,
        'amount' => $amount
    ];
    echo json_encode($result);
} else {
    // Caso ocorra erro na criação da transação
    echo json_encode(['error' => 'Falha ao criar a transação Pix ou dados inválidos.']);
}
?>
