<?php 
   $valor = 8652;
   $nome = 'Nome do cliente';
   $email = 'email_do_cliente_aqui@gmail.com';
   $doc_tipo = 'cpf';
   $doc_num = '81907057099'; 
      // dados da campanha no facebook 
   $sck = '123384';
   $src = 'example.com';
   $utm_campaign = 'campaign_example';  
   $utm_content = 'content_example';  
   $utm_medium = 'medium_example';  
   $utm_source = 'source_example';  
   $utm_term = 'term_example'; 
   ?>
<html lang="pt-BR">
   <head>
      <meta charset="UTF-8">
      <title>Pagamento via PIX</title>
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
      <style>
         body {
         background-color: white;
         }
         .container {
         padding:0px;
         }
         .qr-code-img {
         padding:3px;
         max-width: 100%;
         border: 3px solid #133a6f;
         border-radius: 20px;
         width: 250px;
         height: 250px;
         object-fit: cover;
         }
         .custom-btn-white {
         background-color: #fff;
         color: #133a6f;
         border-color: #133a6f;
         font-size: 12px;
         font-weight: 500;
         width: 300px;
         margin: 5px 0px;
         }
         .custom-btn-white:hover {
         background-color: #eeeeee;
         }
      </style>
   </head>
   <body>
      <div class="container" style="    max-width: 100%;">
         <div style="text-align: center;padding: 10px 5px 10px;background-color: #133a6f;color: #ffffff;font-weight: 400;">
            <div> Nome do produto </div>
         </div>
         <div class="mt-4" id="div_titulo" style="display:none;">
            <p class="text-center">Escaneie o QR-CODE ou copie o código <br> para realizar o pagamento.</p>
         </div>
         <div class="mt-4" id="div_pag_aprovado" style="display:none;" style="color: #148a14;font-family: sans-serif;font-weight: 500;font-size: 20px;">
            <p class="text-center">
               <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-check-circle" viewBox="0 0 16 16" data-darkreader-inline-fill="" style="--darkreader-inline-fill: currentColor; color: green; margin-bottom: 3px; --darkreader-inline-color: #72ff72;" data-darkreader-inline-color="">
                  <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                  <path d="m10.97 4.97-.02.022-3.473 4.425-2.093-2.094a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05"></path>
               </svg>
               Pagamento aprovado!  <br>
            </p>
         </div>
         <div class="text-center">
            <div id="div_status" style=" color: #133a6f; font-size: 14px; margin: 10px; ">Gerando qr-code...</div>
            <img id="div_qrcode" style="display: none;" src="" class="qr-code-img">
         </div>
         <div id="div_botao" style="display: none;" class="text-center mt-4" style="margin-top: 0.5rem!important" >
            <button onclick="copiarCodigo()" class="btn btn-primary" style="color: #fff;  background-color: #133a6f; border: 1px solid #133a6f; font-size: 12px;font-weight: 500; width: 250px;margin: 5px 0px;height: 40px;">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-copy" viewBox="0 0 16 16" style="margin-top: -3px; margin-right: 5px;">
                  <path fill-rule="evenodd" d="M4 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zM2 5a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-1h1v1a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h1v1z"/>
               </svg>
               COPIAR CÓDIGO PIX
            </button>
         </div>
         <div class="text-center mt-4"style="margin-top: 20px; padding: 10px; font-size: 13px;">
            <table style="width: 100%;">
               <tr>
                  <td style="text-align: center;width: 100%;">
                     <div id="div_transacao" style="display: none;" >
                        <b>Valor do pagamento</b>
                        <div id="div_valor" style="font-size:20px;"></div>
                        <b>ID da transação</b><br>
                        <div id="div_id_transacao"></div>
                     </div>
                  </td>
               </tr>
            </table>
         </div>
      </div>
      <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script> 
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
      <script>
         var qrcodeData;  
         var idTransacaoData;
         var statusPagament;
          
         function verificarStatusPagamento(dataToStatus) { 
            var intervalo = setInterval(function() { 
                statusPagamento(dataToStatus);
            }, 5000);  
            function statusPagamento(dataToStatus) { 
                $.ajax({
                    url: 'cashtimepay/status.php',
                    type: 'POST',
                    dataType: 'json',
                    data: dataToStatus,
                    success: function(response) { 
                        var statusPagamento = response.status;  
                        if (statusPagamento === 'paid'){
                            clearInterval(intervalo); 
                            $('#div_status').hide();
                            $('#div_botao').hide();
                            $('#div_qrcode').hide(); 
                            $('#div_titulo').hide();
                            $('#div_pag_aprovado').show();
                        }else{
                           $('#div_status').text('Aguardando pagamento...');  
                        } 
                    },
                    error: function(xhr, status, error) {
                        console.error('Erro na requisição:', error);
                    }
                });  
            }
         } 
         
         function gerarQRCode(dataToQRcode) {
            $.ajax({
                url: 'cashtimepay/qrcode.php',
                type: 'POST',
                dataType: 'json',
                data: dataToQRcode, 
                success: function(response) { 
                    qrcodeData = response.qrcode;  
                    var idTransacaoData = response.id;
                    var amountData = (response.amount / 100).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }); 
                    var canvas = document.createElement('canvas');
                    QRCode.toCanvas(canvas, qrcodeData, function (error) {
                        if (error) {
                            $('#div_status').text('Ocorreu um erro ao gerar o qr-code.');
                        } else {
                            var qrCodeImage = canvas.toDataURL('image/png');
                            $('#div_qrcode').attr('src', qrCodeImage); 
                            $('#div_titulo').show();
                            $('#div_status').text('QRCode gerado!');
                            $('#div_qrcode').show();
                            $('#div_botao').show();
                            $('#div_transacao').show();
                            $('#div_id_transacao').text(idTransacaoData);
                            $('#div_valor').text(amountData); 
                            
                            var dataToStatus = {
                                id_transacao_post: idTransacaoData,
                                sck_post: '<?php echo $sck ?>', 
                                src_post: '<?php echo $src ?>',
                                utm_campaign_post: '<?php echo $utm_campaign ?>',   
                                utm_content_post: '<?php echo $utm_content ?>',   
                                utm_medium_post: '<?php echo $utm_medium ?>',   
                                utm_source_post: '<?php echo $utm_source ?>',   
                                utm_term_post: '<?php echo $utm_term ?>'
                            };  
                              
                            verificarStatusPagamento(dataToStatus);
                            
                        }
                    });
         },
         error: function(xhr, status, error) {
            console.error('Erro na requisição:', error);
         }
         }); 
         } 
         
         function copiarCodigo() {
         var codigoPix = qrcodeData;  
         navigator.clipboard.writeText(codigoPix).then(function() {
         alert('Código pix copiado!');
         }, function(err) {
         console.error('Não foi possível copiar o cídigo pix.');
         });
         }  
         
         
         $(document).ready(function() {
         var dataToQRcode = { 
         valor: <?php echo json_encode($valor); ?>,
         nome: <?php echo json_encode($nome); ?>,
         email: <?php echo json_encode($email); ?>,
         doc_tipo: <?php echo json_encode($doc_tipo); ?>,
         doc_num: <?php echo json_encode($doc_num); ?>
         }; 
         gerarQRCode(dataToQRcode);
         });
         
          
      </script>
   </body>
</html>