function getUTMParameters() {
    const urlParams = new URLSearchParams(window.location.search);
    return {
        utm_source: urlParams.get('utm_source') || 'not_provided',
        utm_medium: urlParams.get('utm_medium') || 'not_provided',
        utm_campaign: urlParams.get('utm_campaign') || 'not_provided',
        utm_term: urlParams.get('utm_term') || 'not_provided',
        utm_content: urlParams.get('utm_content') || 'not_provided',
    };
}

// Exemplo de como obter o ID da transação dinamicamente
// Pode ser substituído por qualquer lógica de captura de ID.
const idTransacaoData = document.querySelector('#idTransacaoData')?.textContent || "default-id"; // Captura de um elemento ou valor padrão

const utmParams = getUTMParameters();

const transactionData = {
    id_transacao_post: idTransacaoData, // Agora usa a variável
    amount: 8131, // Exemplo de valor
    ...utmParams, // Adiciona as UTMs ao payload
};

// Envio para o backend
fetch('cashtimepay/webhook.php', {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json',
    },
    body: JSON.stringify(transactionData),
})
    .then(response => response.json())
    .then(data => console.log('Resposta do backend:', data))
    .catch(error => console.error('Erro ao enviar dados:', error));
