<?php
if (isset($_GET['cpf'])) {
    $cpf = $_GET['cpf'];
    
    // Monta a URL da API
    $usuario = 'a2ffbbb74f7fe816302b51eb72a7ef73';
    $api_url = "https://apiconsultas.store/api/?usuario={$usuario}&api=cpf&cpf={$cpf}";

    // Faz a consulta à API
    $response = file_get_contents($api_url);
    
    if ($response === FALSE) {
        die('Erro ao consultar a API.');
    }
    
    $data = json_decode($response, true);
    
    if (isset($data['erro'])) {
        die('Erro na consulta: ' . $data['erro']);
    }

    // Extrai os dados necessários da resposta
    $nome = $data['nome'];
    $nascimento = $data['nascimento'];
    $sexo = $data['sexo'];
    $mae = $data['mae'];

    // Obtém o primeiro nome
    $primeiro_nome = explode(' ', trim($nome))[0];

    // Calcula a idade
    $dataNascimento = DateTime::createFromFormat('d/m/Y', $nascimento);
    $hoje = new DateTime();
    $idade = $hoje->diff($dataNascimento)->y;

    // Monta a URL de redirecionamento
    $url = "/seguro/consulta/consultando/?cpf=" . urlencode($cpf) .
           "&nome=" . urlencode($nome) .
           "&sexo=" . urlencode($sexo) .
           "&nascimento=" . urlencode($nascimento) .
           "&mae=" . urlencode($mae) .
           "&primeiro_nome=" . urlencode($primeiro_nome) .
           "&idade=" . urlencode($idade);
    
    // Redireciona para a próxima página
    header("Location: $url");
    exit;
} else {
    die('CPF não fornecido.');
}
?>