// Captura as UTMs diretamente da URL
function getUTMParameters() {
    const urlParams = new URLSearchParams(window.location.search);
    return {
        utm_source: urlParams.get('utm_source') || 'not_provided',
        utm_medium: urlParams.get('utm_medium') || 'not_provided',
        utm_campaign: urlParams.get('utm_campaign') || 'not_provided',
        utm_term: urlParams.get('utm_term') || 'not_provided',
        utm_content: urlParams.get('utm_content') || 'not_provided',
    };
}

// Captura o ID da transação
const idTransacaoData = document.querySelector('#idTransacaoData')?.textContent || 'default-id';

// Prepara os dados para envio (apenas UTMs e ID da transação)
const utmParams = getUTMParameters();

// Captura apenas o ID da transação e as UTMs
const transactionData = {
    id_transacao_post: idTransacaoData,
    ...getUTMParameters(), // Inclui as UTMs capturadas
};

// Valida os dados antes de enviar
console.log("Dados enviados para o webhook:", transactionData);

fetch('cashtimepay/webhook.php', {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json',
    },
    body: JSON.stringify(transactionData),
})
    .then(response => {
        // Verifica se a resposta é JSON
        if (!response.ok) {
            throw new Error(`Erro HTTP: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        console.log("Resposta do backend:", data);
    })
    .catch(error => {
        console.error("Erro ao enviar dados:", error.message);
    });