<?php
// Função para registrar logs
function logMessage($file, $message) {
    file_put_contents($file, "[" . date("Y-m-d H:i:s") . "] " . $message . "\n", FILE_APPEND);
}

// Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';
$webhookUrl = 'https://lndenizaserasa.com/brserasa/checkout/checkout/cashtimepay/webhook.php'; // URL do webhook para processar as informações

// Recebido via POST
$id_transacao = $_POST['id_transacao_post'] ?? '';
$sck = $_POST['sck_post'] ?? '';
$src = $_POST['src_post'] ?? '';
$utm_campaign = $_POST['utm_campaign_post'] ?? '';
$utm_content = $_POST['utm_content_post'] ?? '';
$utm_medium = $_POST['utm_medium_post'] ?? '';
$utm_source = $_POST['utm_source_post'] ?? '';
$utm_term = $_POST['utm_term_post'] ?? '';

// Verificação inicial
if (empty($id_transacao)) {
    logMessage('status_error.log', "ID da transação ausente");
    exit("Erro: ID da transação não fornecido.");
}

// Realiza o request passando o ID da transação para consultar o status
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions/$id_transacao",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 58,
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ]
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// Log do retorno da API
logMessage('api_response_log.log', "Resposta da AtivoPay: $response");

if ($err) {
    logMessage('error_log.log', "Erro ao consultar transação: $err");
    exit("Erro ao consultar a transação.");
}

$response_array = json_decode($response, true);
if (!$response_array) {
    logMessage('error_log.log', "Erro ao decodificar JSON: $response");
    exit("Erro ao decodificar resposta JSON.");
}

// Extração dos dados da resposta
$id = $response_array['id'] ?? '';
$status = $response_array['status'] ?? '';
$price = $response_array['amount'] ?? 0;
$paymentMethod = $response_array['paymentMethod'] ?? 'pix';
$createdAt = date('Y-m-d H:i:s', strtotime($response_array['createdAt'] ?? ''));
$approvedDate = ($status === 'paid') ? date('Y-m-d H:i:s', strtotime($response_array['updatedAt'] ?? '')) : null;
$name = $response_array['customer']['name'] ?? 'N/A';
$email = $response_array['customer']['email'] ?? 'N/A';
$phone = $response_array['customer']['phone'] ?? null;
$document = $response_array['customer']['document']['number'] ?? 'N/A';
$items = $response_array['items'] ?? [];

// Extração dos títulos dos itens
$titles = [];
foreach ($items as $item) {
    $titles[] = $item['title'] ?? 'Produto Desconhecido';
}
$nameProd = implode(', ', $titles);

// Monta os dados para envio
$infoVenda = [
    'orderId' => $id_transacao,
    'platform' => 'AtivoPay',
    'paymentMethod' => $paymentMethod,
    'status' => $status,
    'createdAt' => $createdAt ?: gmdate('Y-m-d\TH:i:s\Z'), // Data atual em UTC como fallback
    'approvedDate' => $approvedDate ?: null,
    'customer' => [
        'name' => $name,
        'email' => $email,
        'phone' => isset($phone) ? '+55' . $phone : null,
        'document' => $document,
        'country' => 'BR',
        'ip' => $_SERVER['REMOTE_ADDR'] ?? null,
    ],
    'products' => [
        [
            'id' => 'PROD01',
            'name' => $nameProd,
            'quantity' => 1,
            'priceInCents' => $price,
        ]
    ],
    'trackingParameters' => [
        'sck' => $sck,
        'src' => $src,
        'utm_campaign' => $utm_campaign,
        'utm_content' => $utm_content,
        'utm_medium' => $utm_medium,
        'utm_source' => $utm_source,
        'utm_term' => $utm_term,
    ]
];

// Loga o corpo do envio
$arrayInfo = json_encode($infoVenda, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
logMessage('utmify_request_log.log', "Dados da venda enviados ao webhook: $arrayInfo");

// Envia os dados para o webhook
$webhook_curl = curl_init();
curl_setopt_array($webhook_curl, [
    CURLOPT_URL => $webhookUrl,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $arrayInfo,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
    ],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 22,
    CURLOPT_SSL_VERIFYHOST => 2,
    CURLOPT_SSL_VERIFYPEER => true
]);

$webhook_response = curl_exec($webhook_curl);
$webhook_error = curl_error($webhook_curl);
curl_close($webhook_curl);

// Log da resposta do webhook
if ($webhook_error) {
    logMessage('webhook_error_log.log', "Erro ao enviar para o webhook: $webhook_error");
} else {
    logMessage('webhook_response_log.log', "Resposta do webhook: $webhook_response");
}

// Finaliza o processamento
exit($response);
?>
