<?php
// Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';
$titulo = 'Ebook - Vida Nova';

// Dados recebidos via POST da função "gerarQRCode"
$valor = $_POST['valor'];
$nome = $_POST['nome'];
$email = $_POST['email'];
$doc_tipo = $_POST['doc_tipo'];
$doc_num = $_POST['doc_num'];

// Captura as UTMs enviadas via POST
$utm_source = $_POST['utm_source'] ?? 'not_provided';
$utm_medium = $_POST['utm_medium'] ?? 'not_provided';
$utm_campaign = $_POST['utm_campaign'] ?? 'not_provided';
$utm_term = $_POST['utm_term'] ?? 'not_provided';
$utm_content = $_POST['utm_content'] ?? 'not_provided';

// Estrutura o array com as variáveis necessárias para criar a transação.
$data = [
    'customer' => [
        'document' => [
            'number' => $doc_num,
            'type' => $doc_tipo
        ],
        'name' => $nome,
        'email' => $email
    ],
    'amount' => (int)$valor,
    'paymentMethod' => 'pix',
    'items' => [
        [
            'tangible' => false,
            'title' => $titulo,
            'unitPrice' => (int)$valor,
            'quantity' => 1
        ]
    ]
];

$curl = curl_init();
// Realiza o request passando os parâmetros do array.
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ],
]);
// Recebe o retorno do gateway em formato JSON
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo "cURL Error #: " . $err;
} else {
    // Faz a leitura do JSON e extrai apenas as informações necessárias para gerar o QR Code.
    $response_array = json_decode($response, true);
    if ($response_array !== null) {
        $qrcode = $response_array['pix']['qrcode'];
        $id = $response_array['id'];
        $amount = $response_array['amount'];

        // Armazena as UTMs associadas ao ID da transação
        $utm_data = [
            'utm_source' => $utm_source,
            'utm_medium' => $utm_medium,
            'utm_campaign' => $utm_campaign,
            'utm_term' => $utm_term,
            'utm_content' => $utm_content,
            'id_transacao' => $id
        ];
        $utm_file = "utm_storage2/{$id}.json";
        file_put_contents($utm_file, json_encode($utm_data));

        // Log para depuração
        file_put_contents('utm_debug.log', "[" . date("Y-m-d H:i:s") . "] UTMs armazenadas: " . json_encode($utm_data) . "\n", FILE_APPEND);

        // Retorna o QR Code e informações adicionais
        $result = [
            'qrcode' => $qrcode,
            'id' => $id,
            'amount' => $amount
        ];
        echo json_encode($result);
    } else {
        echo json_encode(['error' => 'Falha ao decodificar a resposta JSON.']);
    }
}
?>