<?php
// Função para registrar logs de forma centralizada
function logMessage($file, $message) {
    file_put_contents($file, "[" . date("Y-m-d H:i:s") . "] " . $message . "\n", FILE_APPEND);
}

// Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';

// Recebido via POST
$id_transacao = $_POST['id_transacao_post'] ?? '';
$sck = $_POST['sck_post'] ?? '';
$src = $_POST['src_post'] ?? '';

// Verificação inicial
if (empty($id_transacao)) {
    logMessage('erro/error_log.log', "ID da transação ausente");
    exit("Erro: ID da transação não fornecido.");
}

// Realiza o request passando o ID da transação para consultar o status
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions/$id_transacao",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ]
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// Log do retorno da API
logMessage('erro/api_response_log.log', "Resposta da AtivoPay: $response");

if ($err) {
    logMessage('erro/error_log.log', "Erro ao consultar transação: $err");
    exit("Erro ao consultar a transação.");
}

$response_array = json_decode($response, true);
if (!$response_array) {
    logMessage('erro/error_log.log', "Erro ao decodificar JSON: $response");
    exit("Erro ao decodificar resposta JSON.");
}

// Extração dos dados da resposta
$id = $response_array['id'] ?? '';
$status = $response_array['status'] ?? '';
$price = $response_array['amount'] ?? 0;
$paymentMethod = $response_array['paymentMethod'] ?? 'pix';
$createdAt = date('Y-m-d H:i:s', strtotime($response_array['createdAt'] ?? ''));
$approvedDate = ($status === 'paid') ? date('Y-m-d H:i:s', strtotime($response_array['updatedAt'] ?? '')) : null;
$name = $response_array['customer']['name'] ?? 'N/A';
$email = $response_array['customer']['email'] ?? 'N/A';
$phone = $response_array['customer']['phone'] ?? null;
$document = $response_array['customer']['document']['number'] ?? 'N/A';
$items = $response_array['items'] ?? [];

// Extração dos títulos dos itens
$titles = [];
foreach ($items as $item) {
    $titles[] = $item['title'] ?? 'Ebook - Vida Nova';
}
$nameProd = implode(', ', $titles);

// Log do status da transação
logMessage('erro/transaction_status_log.log', "Status da transação: $status");

// Responde com o status da transação
exit(json_encode([
    'id' => $id,
    'status' => $status,
    'amount' => $price,
    'paymentMethod' => $paymentMethod,
    'createdAt' => $createdAt,
    'approvedDate' => $approvedDate,
    'customer' => [
        'name' => $name,
        'email' => $email,
        'phone' => $phone,
        'document' => $document,
    ],
    'products' => $titles
]));
