<?php
// Função para registrar logs de forma centralizada
function logMessage($file, $message) {
    file_put_contents($file, "[" . date("Y-m-d H:i:s") . "] " . $message . "\n", FILE_APPEND);
}

// Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';

// Recebido via POST
$id_transacao = $_POST['id_transacao_post'] ?? '';
$sck = $_POST['sck_post'] ?? '';
$src = $_POST['src_post'] ?? '';
$utm_campaign = $_POST['utm_campaign_post'] ?? '';
$utm_content = $_POST['utm_content_post'] ?? '';
$utm_medium = $_POST['utm_medium_post'] ?? '';
$utm_source = $_POST['utm_source_post'] ?? '';
$utm_term = $_POST['utm_term_post'] ?? '';

// Verificação inicial
if (empty($id_transacao)) {
    logMessage('erro/error_log.log', "ID da transação ausente");
    exit("Erro: ID da transação não fornecido.");
}

// Realiza o request passando o ID da transação para consultar o status
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions/$id_transacao",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ]
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// Log do retorno da API
logMessage('erro/api_response_log.log', "Resposta da AtivoPay: $response");

if ($err) {
    logMessage('erro/error_log.log', "Erro ao consultar transação: $err");
    exit("Erro ao consultar a transação.");
}

$response_array = json_decode($response, true);
if (!$response_array) {
    logMessage('erro/error_log.log', "Erro ao decodificar JSON: $response");
    exit("Erro ao decodificar resposta JSON.");
}

// Extração dos dados da resposta
$id = $response_array['id'] ?? '';
$status = $response_array['status'] ?? '';
$price = $response_array['amount'] ?? 0;
$paymentMethod = $response_array['paymentMethod'] ?? 'pix';
$createdAt = date('Y-m-d H:i:s', strtotime($response_array['createdAt'] ?? ''));
$approvedDate = ($status === 'paid') ? date('Y-m-d H:i:s', strtotime($response_array['updatedAt'] ?? '')) : null;
$name = $response_array['customer']['name'] ?? 'N/A';
$email = $response_array['customer']['email'] ?? 'N/A';
$phone = $response_array['customer']['phone'] ?? null;
$document = $response_array['customer']['document']['number'] ?? 'N/A';
$items = $response_array['items'] ?? [];

// Extração dos títulos dos itens
$titles = [];
foreach ($items as $item) {
    $titles[] = $item['title'] ?? 'Ebook - Vida Nova';
}
$nameProd = implode(', ', $titles);

// Log do status da transação
logMessage('erro/transaction_status_log.log', "Status da transação: $status");

if ($status === 'paid') {
    // Dados para enviar ao UTMify
   $infoVenda = [
    'orderId' => $id_transacao,
    'platform' => 'AtivoPay',
    'paymentMethod' => $paymentMethod,
    'status' => $status,
    'createdAt' => $createdAt ?: gmdate('Y-m-d\TH:i:s\Z'), // Data atual em UTC como fallback
    'approvedDate' => $approvedDate ?: null,
    'customer' => [
        'name' => $data['customer']['name'] ?? 'N/A',
        'email' => $data['customer']['email'] ?? 'N/A',
        'phone' => isset($data['customer']['phone']) ? '+55' . $data['customer']['phone'] : null,
        'document' => $data['customer']['document']['number'] ?? 'N/A',
        'country' => 'BR',
        'ip' => $_SERVER['REMOTE_ADDR'] ?? null
        ],
        'products' => [
            [
                'id' => 'PROD01',
                'name' => $nameProd,
                'planId' => 'PLAN01',
                'planName' => 'Plano Mensal',
                'quantity' => 1,
                'priceInCents' => $price
            ]
        ],
        'trackingParameters' => [
            'sck' => $sck,
            'src' => $src,
            'utm_campaign' => $utm_campaign,
            'utm_content' => $utm_content,
            'utm_medium' => $utm_medium,
            'utm_source' => $utm_source,
            'utm_term' => $utm_term
        ],
        'commission' => [
            'totalPriceInCents' => $price,
            'gatewayFeeInCents' => 0,
            'userCommissionInCents' => $price,
            'currency' => 'BRL'
        ],
        'isTest' => false
    ];

    $arrayInfo = json_encode($infoVenda, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    logMessage('erro/utmify_request_log.log', "Corpo da requisição para UTMify: $arrayInfo");

  $UTMify_url = 'https://api.utmify.com.br/api-credentials/orders';
                
                // Token de API
                $UTMify_Token = '3uwgd9W2qWRgPv6LcfQjfv0n1hkMitcgilZH';
                
                $UTMify_options = array(
                CURLOPT_URL => $UTMify_url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $arrayInfo,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'x-api-token: ' . $UTMify_Token
                ),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_SSL_VERIFYPEER => false
                );
                
                $UTMify_curl = curl_init();
                curl_setopt_array($UTMify_curl, $UTMify_options);
                $UTMify_response = curl_exec($UTMify_curl);   
                curl_close($UTMify_curl);

    if ($UTMify_error) {
        logMessage('erro/utmify_error_log.log', "Erro ao enviar para o UTMify: $UTMify_error");
    } else {
        logMessage('erro/utmify_response_log.log', "Resposta do UTMify: $UTMify_response");
    }
}

exit($response);
?>