<?php
// Configurações de segurança para evitar acesso indevido
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['id_transacao'])) {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';

// Recebido via POST da função "statusPagamento"
$id_transacao = $_POST['id_transacao'];

// Verifica e obtém outras variáveis post
$sck = $_POST['sck_post'] ?? '';
$src = $_POST['src_post'] ?? '';
$utm_campaign = $_POST['utm_campaign_post'] ?? '';
$utm_content = $_POST['utm_content_post'] ?? '';
$utm_medium = $_POST['utm_medium_post'] ?? '';
$utm_source = $_POST['utm_source_post'] ?? '';
$utm_term = $_POST['utm_term_post'] ?? '';

// Realiza o request passando o id da transação para consultar o status.
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions/$id_transacao",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ],
]);

// Recebe o retorno do gateway em formato JSON
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    exit($err);
} else {
    $response_array = json_decode($response, true);
    if ($response_array !== null) {
        $id = $response_array['id'];
        $status = $response_array['status'];
        $price = $response_array['amount'];
        $paymentMethod = $response_array['paymentMethod'];
        $createdAt = date('Y-m-d H:i:s', strtotime($response_array['createdAt']));
        $approvedDate = date('Y-m-d H:i:s', strtotime($response_array['updatedAt']));
        $name = $response_array['customer']['name'];
        $email = $response_array['customer']['email'];
        $phone = $response_array['customer']['phone'];
        $document = $response_array['customer']['document']['number'];

        $items = $response_array['items'];
        $titles = [];
        foreach ($items as $item) {
            $titles[] = $item['title'];
        }
        $nameProd = implode(', ', $titles);

        // Preparar dados para UTMify se o status for 'paid'
        if ($status == 'paid') {
            $infoVenda = [
                'orderId' => $id,
                'platform' => 'Plataforma teste',
                'paymentMethod' => $paymentMethod,
                'status' => $status,
                'createdAt' => $createdAt,
                'approvedDate' => $approvedDate,
                'refundedAt' => null,
                'customer' => [
                    'name' => $name,
                    'email' => $email,
                    'phone' => '+55' . $phone,
                    'document' => $document
                ],
                'product' => [
                    'id' => 'PROD01',
                    'name' => $nameProd,
                    'planId' => 'PLAN01',
                    'planName' => 'Plano Mensal',
                    'quantity' => 1,
                    'priceInCents' => $price
                ],
                'trackingParameters' => [
                    'sck' => $sck,
                    'src' => $src,
                    'utm_campaign' => $utm_campaign,
                    'utm_content' => $utm_content,
                    'utm_medium' => $utm_medium,
                    'utm_source' => $utm_source,
                    'utm_term' => $utm_term
                ],
                'commission' => [
                    'totalPriceInCents' => $price,
                    'gatewayFeeInCents' => 0,
                    'userCommissionInCents' => $price,
                    'currency' => 'BRL'
                ]
            ];

            $arrayInfo = json_encode($infoVenda);

            $UTMify_url = 'https://api.utmify.com.br/api-credentials/orders';

            // Token de API
            $UTMify_Token = 'P95gBeoEGvia3Q8DkK8k1PFlyh12nn51o4Uy';

            $UTMify_options = [
                CURLOPT_URL => $UTMify_url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $arrayInfo,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'x-api-token: ' . $UTMify_Token
                ],
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_SSL_VERIFYPEER => false
            ];

            $UTMify_curl = curl_init();
            curl_setopt_array($UTMify_curl, $UTMify_options);
            $UTMify_response = curl_exec($UTMify_curl);
            curl_close($UTMify_curl);
        }
    }

    echo $response;
    exit;
}
?>