<?php 

// Verifica se o método de requisição é POST e se os parâmetros necessários estão presentes
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['valor']) || !isset($_POST['nome']) 
        || !isset($_POST['email']) || !isset($_POST['doc_tipo']) || !isset($_POST['doc_num'])) {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

//Sua secret_key
$secretKey = 'sk_live_Lw6BiHF7buqOb1FcmgtRzuRRaQEcvAGI8s1XuOlbZZ';  


$titulo = 'Pagamento Único';

// Dados recebidos via post da função "gerarQRCode" na página "index.php" linha: 130
$valor = $_POST['valor'];
$nome = $_POST['nome'];
$email = $_POST['email'];
$doc_tipo = $_POST['doc_tipo'];
$doc_num = $_POST['doc_num'];

//Estrutura o array com as variáveis necessária para criar a transação.
$data = [
    'customer' => [
        'document' => [
            'number' => $doc_num,
            'type' => $doc_tipo
        ],
        'name' => $nome,
        'email' => $email
    ],
    'amount' => (int)$valor,
    'paymentMethod' => 'pix',
    'items' => [
        [
            'tangible' => false,
            'title' => $titulo,
            'unitPrice' => (int)$valor,
            'quantity' => 1
        ]
    ]
];

$curl = curl_init();
//Realiza o request passando os parametros do array.
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.conta.ativopay.com/v1/transactions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ],
]);
// Recebe o return do gateway em formato json
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);


if ($err) {
    echo "cURL Error #: " . $err;
} else {
    // Faz a leitura o json, e extrai apenas as informações necessárias para gerar o qrcode.
    $response_array = json_decode($response, true); 
    if ($response_array !== null) { 
        $qrcode = $response_array['pix']['qrcode'];
        $id = $response_array['id']; 
        $amount = $response_array['amount']; 
        $result = [
            'qrcode' => $qrcode,
            'id' => $id,
           'amount' => $amount
        ]; 
        echo json_encode($result);
    } else { 
        echo json_encode(['error' => 'Falha ao decodificar a resposta JSON.']);
    }

}

?>
