<?php 
include "css2.php";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>  
    <script
      src="https://cdn.utmify.com.br/scripts/utms/latest.js"
      data-utmify-prevent-xcod-sck
      data-utmify-prevent-subids
      async
      defer
    ></script>
    <script>
      window.pixelId = "6928a2f95789dc29daf2f146";
      var a = document.createElement("script");
      a.setAttribute("async", "");
      a.setAttribute("defer", "");
      a.setAttribute("src", "https://cdn.utmify.com.br/scripts/pixel/pixel.js");
      document.head.appendChild(a);
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔥 Black Friday 2025 | Cupons Exclusivos</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Open+Sans:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --amarelo-ml: #FFE600;
            --amarelo-hover: #FFD000;
            --preto: #0a0a0a;
            --preto-card: #111111;
            --vermelho: #E61E4D;
            --verde: #00A650;
            --branco: #FFFFFF;
            --cinza: #888888;
            --cinza-claro: #aaaaaa;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
        }

        body {
            font-family: 'Open Sans', sans-serif;
            background: var(--preto);
            color: var(--branco);
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* ==================== BANNER TOPO ==================== */
        .bf-banner-top {
            background: var(--preto-card);
            padding: 24px 20px;
            text-align: center;
            border-bottom: 1px solid #222;
        }

        .bf-banner-top h1 {
            font-family: 'Bebas Neue', sans-serif;
            font-size: 42px;
            color: var(--branco);
            margin-bottom: 6px;
            font-weight: 400;
            letter-spacing: 2px;
        }

        .bf-banner-top p {
            color: var(--amarelo-ml);
            font-size: 14px;
            font-weight: 500;
        }

        /* ==================== VSL CONTAINER ==================== */
        .vsl-section {
            padding: 30px 16px 40px;
            max-width: 800px;
            margin: 0 auto;
        }

        .vsl-wrapper {
            background: var(--preto-card);
            border-radius: 16px;
            overflow: hidden;
            border: 2px solid var(--amarelo-ml);
            box-shadow: 0 0 40px rgba(255, 230, 0, 0.15);
        }

        /* ==================== HEADER AMARELO ==================== */
        .vsl-header {
            background: var(--amarelo-ml);
            color: var(--preto);
            padding: 10px 16px;
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            align-items: center;
            gap: 12px;
        }

        .vsl-header-left {
            display: flex;
            align-items: center;
            gap: 12px;
            justify-self: start;
        }

        .live-indicator {
            display: flex;
            align-items: center;
            gap: 6px;
            background: var(--vermelho);
            color: white;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
        }

        .live-dot {
            width: 6px;
            height: 6px;
            background: white;
            border-radius: 50%;
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.3; }
        }

        .viewer-count {
            font-weight: 700;
            font-size: 12px;
            color: var(--preto);
        }

        .vsl-header-center {
            justify-self: center;
        }

        .vsl-header-logo {
            height: 32px;
            width: auto;
            display: block;
        }

        .vsl-header-right {
            display: flex;
            align-items: center;
            gap: 8px;
            justify-self: end;
        }

        .progress-bar {
            width: 80px;
            height: 6px;
            background: rgba(0,0,0,0.15);
            border-radius: 3px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: var(--preto);
            width: 0%;
            transition: width 0.3s ease;
            border-radius: 3px;
        }

        .progress-text {
            font-size: 11px;
            font-weight: 700;
            color: var(--preto);
            min-width: 28px;
        }

        /* ==================== ÁREA DO VÍDEO ==================== */
        .vsl-video {
            position: relative;
            padding-bottom: 56.25%;
            background: #000;
        }

        .video-placeholder {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: radial-gradient(ellipse at center, #1a1a1a 0%, #000 100%);
            cursor: pointer;
            padding: 20px;
        }

        .play-btn {
            width: 80px;
            height: 80px;
            background: var(--amarelo-ml);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 16px;
            box-shadow: 0 0 30px rgba(255, 230, 0, 0.5);
            transition: all 0.3s ease;
            animation: playPulse 2s ease-in-out infinite;
        }

        .play-btn:hover {
            transform: scale(1.08);
        }

        @keyframes playPulse {
            0%, 100% { box-shadow: 0 0 30px rgba(255, 230, 0, 0.5); }
            50% { box-shadow: 0 0 50px rgba(255, 230, 0, 0.7), 0 0 0 15px rgba(255, 230, 0, 0.1); }
        }

        .play-btn svg {
            width: 32px;
            height: 32px;
            fill: var(--preto);
            margin-left: 4px;
        }

        .video-placeholder p {
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 6px;
            color: var(--branco);
        }

        .video-placeholder .subtitle {
            color: var(--cinza);
            font-size: 13px;
            text-align: center;
        }

        .video-placeholder .sound-tip {
            margin-top: 16px;
            background: rgba(255,255,255,0.08);
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 11px;
            color: var(--cinza-claro);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        #mainVideo {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: contain;
            background: #000;
        }

        /* ==================== FOOTER DO VÍDEO ==================== */
        .vsl-footer {
            background: var(--preto-card);
            padding: 14px 16px;
            border-top: 1px solid #222;
        }

        .vsl-footer-text {
            text-align: center;
            color: var(--cinza);
            font-size: 12px;
        }

        .vsl-footer-text strong {
            color: var(--amarelo-ml);
        }

        /* ==================== BOTÃO SECRETO ==================== */
        .secret-button-section {
            margin-top: 24px;
            text-align: center;
            display: none;
            animation: fadeInUp 0.6s ease;
        }

        .secret-button-section.visible {
            display: block;
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .unlock-message {
            background: linear-gradient(135deg, var(--verde), #00c853);
            padding: 16px;
            border-radius: 12px;
            margin-bottom: 16px;
        }

        .unlock-message h3 {
            font-size: 18px;
            margin-bottom: 4px;
        }

        .unlock-message p {
            opacity: 0.9;
            font-size: 13px;
        }

        .secret-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            background: linear-gradient(135deg, var(--amarelo-ml), var(--amarelo-hover));
            color: var(--preto);
            text-decoration: none;
            padding: 18px 40px;
            border-radius: 12px;
            font-size: 18px;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            box-shadow: 0 8px 30px rgba(255, 230, 0, 0.35);
            position: relative;
            overflow: hidden;
            border: none;
            cursor: pointer;
            width: 100%;
            max-width: 400px;
        }

        .secret-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            animation: shine 2s infinite;
        }

        @keyframes shine {
            0% { left: -100%; }
            50%, 100% { left: 100%; }
        }

        .secret-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 40px rgba(255, 230, 0, 0.45);
        }

        .secret-btn .icon {
            font-size: 22px;
        }

        .btn-subtext {
            margin-top: 12px;
            color: var(--verde);
            font-size: 12px;
            font-weight: 600;
        }

        /* ==================== BANNER RODAPÉ ==================== */
        .bf-banner-bottom {
            background: var(--preto-card);
            padding: 30px 20px;
            text-align: center;
            border-top: 1px solid #222;
        }

        .bf-banner-bottom h2 {
            font-family: 'Bebas Neue', sans-serif;
            font-size: 36px;
            color: var(--branco);
            margin-bottom: 6px;
            font-weight: 400;
            letter-spacing: 2px;
        }

        .bf-banner-bottom p {
            color: var(--amarelo-ml);
            font-size: 14px;
            font-weight: 500;
        }

        /* ==================== FOOTER ==================== */
        .footer {
            text-align: center;
            padding: 30px 20px;
            border-top: 1px solid #1a1a1a;
            color: var(--cinza);
        }

        .footer-logo {
            font-family: 'Bebas Neue', sans-serif;
            font-size: 22px;
            color: var(--amarelo-ml);
            margin-bottom: 12px;
        }

        .footer-links {
            margin-bottom: 16px;
        }

        .footer-links a {
            color: var(--cinza);
            text-decoration: none;
            margin: 0 12px;
            font-size: 12px;
            transition: color 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--amarelo-ml);
        }

        .footer-copy {
            font-size: 11px;
            color: #555;
        }

        /* ==================== RESPONSIVIDADE ==================== */
        
        /* Tablet */
        @media (max-width: 768px) {
            .bf-banner-top {
                padding: 20px 16px;
            }

            .bf-banner-top h1 {
                font-size: 34px;
            }

            .bf-banner-top p {
                font-size: 13px;
            }

            .vsl-section {
                padding: 24px 12px 32px;
            }

            .vsl-header {
                grid-template-columns: 1fr 1fr;
                grid-template-rows: auto auto;
                padding: 10px 12px;
                gap: 8px;
            }

            .vsl-header-left {
                grid-column: 1;
                grid-row: 2;
            }

            .vsl-header-center {
                grid-column: 1 / -1;
                grid-row: 1;
                justify-self: center;
                padding-bottom: 6px;
                border-bottom: 1px solid rgba(0,0,0,0.1);
                width: 100%;
                display: flex;
                justify-content: center;
            }

            .vsl-header-logo {
                height: 28px;
            }

            .vsl-header-right {
                grid-column: 2;
                grid-row: 2;
            }

            .progress-bar {
                width: 60px;
            }

            .play-btn {
                width: 70px;
                height: 70px;
            }

            .play-btn svg {
                width: 28px;
                height: 28px;
            }

            .video-placeholder p {
                font-size: 15px;
            }

            .video-placeholder .subtitle {
                font-size: 12px;
            }

            .secret-btn {
                padding: 16px 30px;
                font-size: 16px;
            }

            .bf-banner-bottom h2 {
                font-size: 30px;
            }
        }

        /* Mobile */
        @media (max-width: 480px) {
            .bf-banner-top {
                padding: 16px 12px;
            }

            .bf-banner-top h1 {
                font-size: 28px;
                letter-spacing: 1px;
            }

            .bf-banner-top p {
                font-size: 11px;
            }

            .vsl-section {
                padding: 16px 8px 24px;
            }

            .vsl-wrapper {
                border-radius: 12px;
                border-width: 2px;
            }

            .vsl-header {
                padding: 8px 10px;
                gap: 6px;
            }

            .vsl-header-logo {
                height: 55px;
            }

            .live-indicator {
                padding: 3px 8px;
                font-size: 9px;
                gap: 4px;
            }

            .live-dot {
                width: 5px;
                height: 5px;
            }

            .viewer-count {
                font-size: 10px;
            }

            .progress-bar {
                width: 50px;
                height: 5px;
            }

            .progress-text {
                font-size: 10px;
            }

            .play-btn {
                width: 60px;
                height: 60px;
            }

            .play-btn svg {
                width: 24px;
                height: 24px;
            }

            .video-placeholder p {
                font-size: 14px;
            }

            .video-placeholder .subtitle {
                font-size: 11px;
            }

            .video-placeholder .sound-tip {
                font-size: 10px;
                padding: 6px 12px;
            }

            .vsl-footer {
                padding: 12px;
            }

            .vsl-footer-text {
                font-size: 11px;
            }

            .unlock-message {
                padding: 14px;
            }

            .unlock-message h3 {
                font-size: 16px;
            }

            .unlock-message p {
                font-size: 12px;
            }

            .secret-btn {
                padding: 14px 24px;
                font-size: 14px;
                gap: 8px;
            }

            .secret-btn .icon {
                font-size: 18px;
            }

            .btn-subtext {
                font-size: 10px;
            }

            .bf-banner-bottom {
                padding: 24px 16px;
            }

            .bf-banner-bottom h2 {
                font-size: 26px;
            }

            .bf-banner-bottom p {
                font-size: 12px;
            }

            .footer {
                padding: 24px 16px;
            }

            .footer-logo {
                font-size: 20px;
            }

            .footer-links a {
                margin: 0 8px;
                font-size: 10px;
            }

            .footer-copy {
                font-size: 10px;
            }
        }

        /* Mobile muito pequeno */
        @media (max-width: 360px) {
            .bf-banner-top h1 {
                font-size: 24px;
            }

            .vsl-header {
                padding: 6px 8px;
            }

            .vsl-header-logo {
                height: 20px;
            }

            .live-indicator {
                font-size: 8px;
                padding: 2px 6px;
            }

            .viewer-count {
                font-size: 9px;
            }

            .play-btn {
                width: 50px;
                height: 50px;
            }

            .play-btn svg {
                width: 20px;
                height: 20px;
            }
        }
    </style>
</head>
<body>

<!-- Banner Topo -->
<div class="bf-banner-top">
    <h1></h1>
    <p></p>
</div>

<!-- VSL Section -->
<div class="vsl-section">
    <div class="vsl-wrapper">
        
        <!-- Header Amarelo -->
        <div class="vsl-header">
            <div class="vsl-header-left">
                <div class="live-indicator">
                    <span class="live-dot"></span>
                    AO VIVO
                </div>
                <span class="viewer-count">👥 <span id="viewers">10.847</span></span>
            </div>
            
            <div class="vsl-header-center">
                <img src="img/logo.png" alt="Logo" class="vsl-header-logo">
            </div>
            
            <div class="vsl-header-right">
                <div class="progress-bar">
                    <div class="progress-fill" id="headerProgress"></div>
                </div>
                <span class="progress-text" id="progressPercent">0%</span>
            </div>
        </div>
        
        <!-- Área do Vídeo -->
        <div class="vsl-video">
            <div class="video-placeholder" id="videoPlaceholder">
                <div class="play-btn">
                    <svg viewBox="0 0 24 24"><path d="M8 5v14l11-7z"/></svg>
                </div>
                <p>Toque para Assistir</p>
                <span class="subtitle">Descubra as promoções secretas da Black Friday</span>
                <span class="sound-tip">🔊 Ative o som</span>
            </div>
            <video id="mainVideo">
                <source src="vsl/vsl.mp4" type="video/mp4">
            </video>
        </div>
        
        <!-- Footer do Vídeo -->
        <div class="vsl-footer">
            <p class="vsl-footer-text">
                🔥 Após assistir <strong>ao vídeo,</strong> você desbloqueia descontos exclusivos em jogos de panelas.
                
            </p>
        </div>
    </div>

    <!-- Botão Secreto -->
    <div class="secret-button-section" id="secretButtonSection">
        <div class="unlock-message">
            <h3>🎉 PARABÉNS! ACESSO LIBERADO!</h3>
            <p>Você desbloqueou os cupons exclusivos</p>
        </div>
        <a href="#" class="secret-btn" id="secretBtn">
            <span class="icon">🛒</span>
            ACESSAR OFERTAS
            <span class="icon">→</span>
        </a>
        <p class="btn-subtext">
            ✅ Cupons aplicados automaticamente
        </p>
    </div>
</div>

<!-- Banner Rodapé -->
<div class="bf-banner-bottom">
    <h2>Black Friday 2025</h2>
    <p>Cupons de desconto e ofertas | Mercado Livre</p>
</div>

<!-- Footer -->
<footer class="footer">
    <div class="footer-logo">🛒 OFERTAS DO DIA</div>
    <div class="footer-links">
        <a href="#">Termos de Uso</a>
        <a href="#">Privacidade</a>
        <a href="#">Contato</a>
    </div>
    <p class="footer-copy">Copyright © 1999-2025 Ebazar.com.br LTDA. Todos os direitos reservados empresa do grupo Mercado Livre.</p>
</footer>

<script>
    // ===== CONFIGURAÇÕES =====
    const REDIRECT_URL = "https://ofertas-mercadolivre.com/black-friday/";

    // ===== FUNÇÃO PARA MANTER PARÂMETROS DA URL =====
    function getRedirectURL() {
        const params = window.location.search;
        if (params) {
            return REDIRECT_URL.includes('?') 
                ? REDIRECT_URL + '&' + params.substring(1)
                : REDIRECT_URL + params;
        }
        return REDIRECT_URL;
    }

    // ===== ELEMENTOS =====
    const videoPlaceholder = document.getElementById('videoPlaceholder');
    const mainVideo = document.getElementById('mainVideo');
    const headerProgress = document.getElementById('headerProgress');
    const progressPercent = document.getElementById('progressPercent');
    const secretButtonSection = document.getElementById('secretButtonSection');
    const secretBtn = document.getElementById('secretBtn');

    let videoCompleted = false;

    // ===== INICIAR VÍDEO =====
    videoPlaceholder.addEventListener('click', function() {
        videoPlaceholder.style.display = 'none';
        mainVideo.style.display = 'block';
        mainVideo.play();
    });

    // ===== PROGRESSO DO VÍDEO =====
    mainVideo.addEventListener('timeupdate', function() {
        if (mainVideo.duration) {
            const progress = (mainVideo.currentTime / mainVideo.duration) * 100;
            headerProgress.style.width = progress + '%';
            progressPercent.textContent = Math.floor(progress) + '%';
        }
    });

    // ===== FIM DO VÍDEO =====
    mainVideo.addEventListener('ended', function() {
        videoCompleted = true;
        window.location.href = getRedirectURL();
    });

    // ===== BOTÃO SECRETO =====
    secretBtn.addEventListener('click', function(e) {
        e.preventDefault();
        if (videoCompleted) {
            window.location.href = getRedirectURL();
        }
    });

    // ===== CONTADOR DE VIEWERS =====
    setInterval(function() {
        const viewersEl = document.getElementById('viewers');
        let current = parseInt(viewersEl.textContent.replace(/\./g, ''));
        current = Math.max(9000, Math.min(10873, current + Math.floor(Math.random() * 30) - 15));
        viewersEl.textContent = current.toLocaleString('pt-BR');
    }, 4000);
</script>

</body>
</html>