<?php

require __DIR__ . '/info/autoload.php';

// Use as classes do GeoIP2
use GeoIp2\Database\Reader;

// Função para obter o país do visitante usando GeoIP
function getVisitorCountryCode() {
    $ip = $_SERVER['REMOTE_ADDR'];

    try {
        $reader = new Reader('security.mmdb'); // Substitua com o caminho real do seu banco de dados GeoIP2
        $record = $reader->country($ip);
        return $record->country->isoCode;
    } catch (\Exception $e) {
        return null;
    }
}

// Verificar se o país é o Brasil
$con = getVisitorCountryCode();
if ($con !== 'BR') {
    header('Location: /informativo/');
    exit();
}

// Verificar presença e valor dos parâmetros UTM
$utm_source = $_GET['utm_source'] ?? '';
$utm_medium = $_GET['utm_medium'] ?? '';
$utm_campaign = $_GET['utm_campaign'] ?? '';

// Redirecionar se não vier dos parâmetros esperados
if ($utm_source !== 'FB' || empty($utm_campaign) || empty($utm_medium)) {
    header('Location: /informativo/');
    exit();
}

// Configurar um cookie para marcar a sessão do visitante como válida
if (!isset($_COOKIE['from_ad'])) {
    setcookie('from_ad', '1', time() + 3600); // Cookie válido por 1 hora
}
?>
