<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Endereço de Entrega - Checkout</title>
    
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-light.woff2" as="font" type="font/woff2">
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-regular.woff2" as="font" type="font/woff2">
    <link rel="preload" href="https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-semibold.woff2" as="font" type="font/woff2">
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="js/mask.js"></script>

    <style>
        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 300;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-light.woff2') format('woff2');
        }
        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 400;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-regular.woff2') format('woff2');
        }
        @font-face {
            font-family: 'Proxima Nova';
            font-weight: 600;
            src: url('https://http2.mlstatic.com/ui/webfonts/v3.0.0/proxima-nova/proximanova-semibold.woff2') format('woff2');
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Proxima Nova', Arial, sans-serif;
            background: #ebebeb;
            color: #333;
        }

        .header {
            background: #fff159;
            padding: 10px 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .back-btn {
            color: #333;
            text-decoration: none;
            font-size: 24px;
            font-weight: 600;
        }

        .logo {
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: 30px auto;
            padding: 0 20px;
        }

        .progress-bar {
            background: white;
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .progress-step {
            display: flex;
            align-items: center;
            gap: 10px;
            flex: 1;
            position: relative;
        }

        .progress-step::after {
            content: '';
            position: absolute;
            left: calc(50% + 30px);
            width: calc(100% - 60px);
            height: 2px;
            background: #ddd;
            top: 15px;
        }

        .progress-step:last-child::after {
            display: none;
        }

        .step-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #ddd;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            z-index: 1;
        }

        .progress-step.active .step-number {
            background: #3483fa;
            color: white;
        }

        .progress-step.completed .step-number {
            background: #00a650;
            color: white;
        }

        .step-label {
            font-size: 14px;
            font-weight: 600;
        }

        .card {
            background: white;
            border-radius: 6px;
            padding: 30px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .card-title {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            font-family: 'Proxima Nova', Arial, sans-serif;
            transition: border-color 0.2s;
        }

        .form-input:focus {
            outline: none;
            border-color: #3483fa;
        }

        .form-input.error {
            border-color: #f23d4f;
        }

        .error-message {
            color: #f23d4f;
            font-size: 12px;
            margin-top: 4px;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }

        .order-summary {
            background: #f5f5f5;
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 20px;
        }

        .summary-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 16px;
        }

        .summary-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            font-size: 14px;
        }

        .summary-total {
            display: flex;
            justify-content: space-between;
            padding-top: 16px;
            border-top: 2px solid #ddd;
            font-size: 20px;
            font-weight: 600;
            margin-top: 8px;
        }

        .btn-group {
            display: flex;
            gap: 12px;
            margin-top: 30px;
        }

        .btn {
            flex: 1;
            padding: 16px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-primary {
            background: #3483fa;
            color: white;
        }

        .btn-primary:hover {
            background: #2968c8;
        }

        .btn-secondary {
            background: white;
            color: #3483fa;
            border: 1px solid #3483fa;
        }

        .btn-secondary:hover {
            background: #f5f5f5;
        }

        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 16px 24px;
            border-radius: 6px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 1000;
            animation: slideIn 0.3s ease;
        }

        .notification.success { background: #00a650; color: white; }
        .notification.error { background: #f23d4f; color: white; }
        .notification.warning { background: #ff9f0a; color: white; }

        @keyframes slideIn {
            from { transform: translateX(400px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .progress-bar {
                flex-direction: column;
                gap: 15px;
            }
            
            .progress-step::after {
                display: none;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <a href="../carrinho/index.php" class="back-btn">‹</a>
            <div class="logo">Finalizar Compra</div>
        </div>
    </header>

    <div class="container">
        <!-- Progress Bar -->
        <div class="progress-bar">
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Carrinho</div>
            </div>
            <div class="progress-step active">
                <div class="step-number">2</div>
                <div class="step-label">Endereço</div>
            </div>
            <div class="progress-step">
                <div class="step-number">3</div>
                <div class="step-label">Pagamento</div>
            </div>
        </div>

        <!-- Order Summary -->
        <div class="order-summary">
            <div class="summary-title">Resumo do Pedido</div>
            <div id="orderItems"></div>
            <div class="summary-total">
                <span>Total</span>
                <span id="orderTotal">R$ 0,00</span>
            </div>
        </div>

        <!-- Address Form -->
        <div class="card">
            <h2 class="card-title">Endereço de Entrega</h2>
            
            <form id="addressForm">
                <div class="form-group">
                    <label class="form-label" for="cep">CEP *</label>
                    <input type="text" id="cep" class="form-input" placeholder="00000-000" required>
                    <span class="error-message" id="cepError"></span>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label" for="rua">Rua *</label>
                        <input type="text" id="rua" class="form-input" placeholder="Rua, Avenida..." required>
                        <span class="error-message" id="ruaError"></span>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="numero">Número *</label>
                        <input type="text" id="numero" class="form-input" placeholder="123" required>
                        <span class="error-message" id="numeroError"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label" for="complemento">Complemento</label>
                    <input type="text" id="complemento" class="form-input" placeholder="Apto, Bloco...">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label" for="bairro">Bairro *</label>
                        <input type="text" id="bairro" class="form-input" placeholder="Bairro" required>
                        <span class="error-message" id="bairroError"></span>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="cidade">Cidade *</label>
                        <input type="text" id="cidade" class="form-input" placeholder="Cidade" required>
                        <span class="error-message" id="cidadeError"></span>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label" for="estado">Estado *</label>
                        <select id="estado" class="form-input" required>
                            <option value="">Selecione...</option>
                            <option value="AC">Acre</option>
                            <option value="AL">Alagoas</option>
                            <option value="AP">Amapá</option>
                            <option value="AM">Amazonas</option>
                            <option value="BA">Bahia</option>
                            <option value="CE">Ceará</option>
                            <option value="DF">Distrito Federal</option>
                            <option value="ES">Espírito Santo</option>
                            <option value="GO">Goiás</option>
                            <option value="MA">Maranhão</option>
                            <option value="MT">Mato Grosso</option>
                            <option value="MS">Mato Grosso do Sul</option>
                            <option value="MG">Minas Gerais</option>
                            <option value="PA">Pará</option>
                            <option value="PB">Paraíba</option>
                            <option value="PR">Paraná</option>
                            <option value="PE">Pernambuco</option>
                            <option value="PI">Piauí</option>
                            <option value="RJ">Rio de Janeiro</option>
                            <option value="RN">Rio Grande do Norte</option>
                            <option value="RS">Rio Grande do Sul</option>
                            <option value="RO">Rondônia</option>
                            <option value="RR">Roraima</option>
                            <option value="SC">Santa Catarina</option>
                            <option value="SP">São Paulo</option>
                            <option value="SE">Sergipe</option>
                            <option value="TO">Tocantins</option>
                        </select>
                        <span class="error-message" id="estadoError"></span>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="telefone">Telefone *</label>
                        <input type="text" id="telefone" class="form-input" placeholder="(00) 00000-0000" required>
                        <span class="error-message" id="telefoneError"></span>
                    </div>
                </div>

                <div class="btn-group">
                    <button type="button" class="btn btn-secondary" onclick="voltarCarrinho()">Voltar ao Carrinho</button>
                    <button type="submit" class="btn btn-primary">Continuar para Pagamento</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Aplicar máscaras
        $(document).ready(function(){
            $('#cep').mask('00000-000');
            $('#telefone').mask('(00) 00000-0000');
        });

        // Carregar resumo do pedido
        function loadOrderSummary() {
            const cart = JSON.parse(localStorage.getItem('cart')) || [];
            const orderItems = document.getElementById('orderItems');
            const orderTotal = document.getElementById('orderTotal');

            if (cart.length === 0) {
                showNotification('Seu carrinho está vazio', 'error');
                setTimeout(() => window.location.href = '../carrinho/index.php', 2000);
                return;
            }

            let html = '';
            let total = 0;

            cart.forEach(item => {
                total += item.price;
                html += `
                    <div class="summary-item">
                        <span>${item.title}</span>
                        <span>R$ ${item.price.toFixed(2)}</span>
                    </div>
                `;
            });

            orderItems.innerHTML = html;
            orderTotal.textContent = `R$ ${total.toFixed(2)}`;
        }

        // Validação do formulário
        function validateForm() {
            let isValid = true;
            const fields = ['cep', 'rua', 'numero', 'bairro', 'cidade', 'estado', 'telefone'];

            fields.forEach(field => {
                const input = document.getElementById(field);
                const error = document.getElementById(field + 'Error');
                
                if (!input.value.trim()) {
                    input.classList.add('error');
                    if (error) error.textContent = 'Campo obrigatório';
                    isValid = false;
                } else {
                    input.classList.remove('error');
                    if (error) error.textContent = '';
                }
            });

            // Validar CEP
            const cep = document.getElementById('cep').value.replace(/\D/g, '');
            if (cep && cep.length !== 8) {
                document.getElementById('cep').classList.add('error');
                document.getElementById('cepError').textContent = 'CEP inválido';
                isValid = false;
            }

            // Validar telefone
            const telefone = document.getElementById('telefone').value.replace(/\D/g, '');
            if (telefone && telefone.length < 10) {
                document.getElementById('telefone').classList.add('error');
                document.getElementById('telefoneError').textContent = 'Telefone inválido';
                isValid = false;
            }

            return isValid;
        }

        // Buscar CEP
        document.getElementById('cep').addEventListener('blur', function() {
            const cep = this.value.replace(/\D/g, '');
            
            if (cep.length === 8) {
                fetch(`https://viacep.com.br/ws/${cep}/json/`)
                    .then(response => response.json())
                    .then(data => {
                        if (!data.erro) {
                            document.getElementById('rua').value = data.logradouro;
                            document.getElementById('bairro').value = data.bairro;
                            document.getElementById('cidade').value = data.localidade;
                            document.getElementById('estado').value = data.uf;
                            document.getElementById('numero').focus();
                        } else {
                            showNotification('CEP não encontrado', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Erro ao buscar CEP:', error);
                    });
            }
        });

        // Submit do formulário
        document.getElementById('addressForm').addEventListener('submit', function(e) {
            e.preventDefault();

            if (!validateForm()) {
                showNotification('Por favor, preencha todos os campos obrigatórios', 'error');
                return;
            }

            // Salvar endereço
            const address = {
                cep: document.getElementById('cep').value,
                rua: document.getElementById('rua').value,
                numero: document.getElementById('numero').value,
                complemento: document.getElementById('complemento').value,
                bairro: document.getElementById('bairro').value,
                cidade: document.getElementById('cidade').value,
                estado: document.getElementById('estado').value,
                telefone: document.getElementById('telefone').value
            };

            localStorage.setItem('shippingAddress', JSON.stringify(address));
            
            showNotification('Endereço salvo com sucesso!', 'success');
            
            // Simular conclusão da compra
            setTimeout(() => {
                finalizarCompra();
            }, 1500);
        });

        function voltarCarrinho() {
            window.location.href = '../carrinho/index.php?view=cart';
        }

        function finalizarCompra() {
            const cart = JSON.parse(localStorage.getItem('cart')) || [];
            const address = JSON.parse(localStorage.getItem('shippingAddress'));
            const total = cart.reduce((sum, item) => sum + item.price, 0);

            // Limpar carrinho e endereço
            localStorage.removeItem('cart');
            localStorage.removeItem('shippingAddress');

            // Exibir mensagem de sucesso
            alert(`✅ Compra Finalizada com Sucesso!\n\nTotal: R$ ${total.toFixed(2)}\n\nProdutos: ${cart.length}\nEndereço: ${address.rua}, ${address.numero} - ${address.cidade}/${address.estado}\n\nObrigado pela sua compra! 🎉`);

            // Redirecionar para página inicial
            window.location.href = '../carrinho/index.php';
        }

        function showNotification(msg, type = 'success') {
            const notif = document.createElement('div');
            notif.className = `notification ${type}`;
            notif.textContent = msg;
            document.body.appendChild(notif);
            setTimeout(() => notif.remove(), 3000);
        }

        // Limpar erros ao digitar
        document.querySelectorAll('.form-input').forEach(input => {
            input.addEventListener('input', function() {
                this.classList.remove('error');
                const errorEl = document.getElementById(this.id + 'Error');
                if (errorEl) errorEl.textContent = '';
            });
        });

        // Inicializar
        loadOrderSummary();
    </script>
</body>
</html>
