<?php
/**
 * Webhook Umbrellapag → Utmify + Facebook CAPI
 * Envia Purchase quando pagamento é confirmado
 */

$UTMify_Token = '2kN5TCos2BgJfIF19fCj7VbPohKrnzuFXZDv';
$UTMify_url = 'https://api.utmify.com.br/api-credentials/orders';
define('UTM_STORAGE_DIR', __DIR__ . '/utm_storage/');
define('LOG_DIR', __DIR__ . '/logs/');

if (!is_dir(LOG_DIR)) mkdir(LOG_DIR, 0755, true);
require_once __DIR__ . '/facebook_capi.php';

function logMsg($f, $m) { file_put_contents(LOG_DIR . $f, "[" . gmdate("Y-m-d H:i:s") . "] $m\n", FILE_APPEND); }
function emptyToNull($v) { return ($v === null || $v === '' || trim($v) === '') ? null : $v; }

$input = file_get_contents('php://input');
logMsg('webhook_raw.log', $input);

$data = json_decode($input, true);
if (!$data) { http_response_code(400); exit("Dados inválidos"); }

$tx = $data['data'] ?? $data;
$id = $tx['id'] ?? null;
$status = $tx['status'] ?? null;
$price = $tx['amount'] ?? null;

if (!$id || !$status || !$price) { http_response_code(400); exit("Campos ausentes"); }

// Mapeia status
$statusMap = ['pending'=>'waiting_payment','paid'=>'paid','approved'=>'paid','completed'=>'paid','confirmed'=>'paid',
    'cancelled'=>'refused','canceled'=>'refused','failed'=>'refused','expired'=>'refused','refunded'=>'refunded','chargeback'=>'chargeback'];
$utmifyStatus = $statusMap[strtolower($status)] ?? $status;
$isPaid = $utmifyStatus === 'paid';

// Recupera UTMs salvos
$utmFile = UTM_STORAGE_DIR . $id . '.json';
$utm = ['utm_source'=>null,'utm_medium'=>null,'utm_campaign'=>null,'utm_term'=>null,'utm_content'=>null,'sck'=>null,'src'=>null,'fbc'=>null,'fbp'=>null,'customer_ip'=>null,'customer'=>[],'address'=>[]];
if (file_exists($utmFile)) $utm = array_merge($utm, json_decode(file_get_contents($utmFile), true) ?? []);

// Dados cliente
$cust = $tx['customer'] ?? [];
$name = $cust['name'] ?? $utm['customer']['name'] ?? null;
$email = $cust['email'] ?? $utm['customer']['email'] ?? null;
$phone = $cust['phone'] ?? $utm['customer']['phone'] ?? null;
$doc = is_array($cust['document'] ?? null) ? ($cust['document']['number'] ?? null) : ($cust['document'] ?? $utm['customer']['document'] ?? null);

// ✅ FACEBOOK PURCHASE (se pago)
if ($isPaid) {
    $flagFile = UTM_STORAGE_DIR . $id . '_purchase.flag';
    if (!file_exists($flagFile)) {
        try {
            $fb = new FacebookCAPI();
            $fbData = ['name'=>$name,'email'=>$email,'phone'=>$phone,'document'=>$doc,
                'cep'=>$utm['address']['cep']??null,'cidade'=>$utm['address']['cidade']??null,'estado'=>$utm['address']['estado']??null,
                'fbc'=>$utm['fbc'],'fbp'=>$utm['fbp'],'ip'=>$utm['customer_ip']];
            $fb->purchase($fbData, $price/100, $id, 'Produto Digital');
            file_put_contents($flagFile, gmdate('Y-m-d H:i:s'));
            logMsg('facebook_purchase.log', "✅ Purchase | TX: $id | R$ " . ($price/100));
        } catch (Exception $e) {
            logMsg('facebook_error.log', "❌ Purchase | TX: $id | " . $e->getMessage());
        }
    }
}

// Produto
$products = $tx['products'] ?? $tx['items'] ?? [];
$prodInfo = [];
if (!empty($products)) {
    foreach ($products as $i => $p) {
        $prodInfo[] = ['id'=>'PROD'.str_pad($i+1,2,'0',STR_PAD_LEFT),'name'=>$p['title']??$p['name']??'Produto',
            'planId'=>'PLAN01','planName'=>'Plano Único','quantity'=>(int)($p['quantity']??1),'priceInCents'=>(int)($p['unitPrice']??$p['priceInCents']??$price)];
    }
}
if (empty($prodInfo)) $prodInfo[] = ['id'=>'PROD01','name'=>'Produto Digital','planId'=>'PLAN01','planName'=>'Plano Único','quantity'=>1,'priceInCents'=>(int)$price];

// Monta payload Utmify
$fmtPhone = $phone ? '+55' . preg_replace('/\D/', '', $phone) : null;
$createdAt = gmdate('Y-m-d H:i:s', strtotime($tx['createdAt'] ?? 'now'));
$updatedAt = isset($tx['updatedAt']) ? gmdate('Y-m-d H:i:s', strtotime($tx['updatedAt'])) : $createdAt;

$info = [
    'orderId'=>(string)$id,'platform'=>'Umbrellapag','paymentMethod'=>'pix','status'=>$utmifyStatus,
    'createdAt'=>$createdAt,'approvedDate'=>$isPaid?$updatedAt:null,'refundedAt'=>$utmifyStatus==='refunded'?$updatedAt:null,
    'customer'=>['name'=>$name,'email'=>$email,'phone'=>$fmtPhone,'document'=>$doc,'country'=>'BR','ip'=>$utm['customer_ip']],
    'products'=>$prodInfo,
    'trackingParameters'=>['src'=>emptyToNull($utm['src']),'sck'=>emptyToNull($utm['sck']),'utm_source'=>emptyToNull($utm['utm_source']),
        'utm_medium'=>emptyToNull($utm['utm_medium']),'utm_campaign'=>emptyToNull($utm['utm_campaign']),
        'utm_term'=>emptyToNull($utm['utm_term']),'utm_content'=>emptyToNull($utm['utm_content'])],
    'commission'=>['totalPriceInCents'=>(int)$price,'gatewayFeeInCents'=>0,'userCommissionInCents'=>(int)$price,'currency'=>'BRL'],
    'isTest'=>false
];

// Envia Utmify
$ch = curl_init($UTMify_url);
curl_setopt_array($ch, [CURLOPT_POST=>true,CURLOPT_POSTFIELDS=>json_encode($info,JSON_UNESCAPED_UNICODE),
    CURLOPT_HTTPHEADER=>['Content-Type: application/json','x-api-token: '.$UTMify_Token],CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>30]);
$res = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

logMsg('utmify_response.log', "TX: $id | Status: $utmifyStatus | HTTP: $code | $res");

http_response_code(200);
echo json_encode(['success'=>$code>=200&&$code<300,'transactionId'=>$id,'status'=>$utmifyStatus,'facebook_purchase'=>$isPaid]);