<?php
/**
 * Backend - API Umbrellapag + Facebook CAPI + Utmify
 */
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

define('API_BASE_URL', 'https://api-gateway.umbrellapag.com');
define('API_TOKEN', 'd46fa92f-9484-409f-a82a-e2734029979e');
define('USER_AGENT', 'AtivoB2B/1.0');
define('UTMIFY_TOKEN', '3uwgd9W2qWRgPv6LcfQjfv0n1hkMitcgilZH');
define('UTMIFY_URL', 'https://api.utmify.com.br/api-credentials/orders');
define('UTM_STORAGE_DIR', __DIR__ . '/utm_storage/');

if (!is_dir(UTM_STORAGE_DIR)) mkdir(UTM_STORAGE_DIR, 0755, true);

require_once __DIR__ . '/facebook_capi.php';

function logMsg($file, $msg) {
    $dir = __DIR__ . '/logs/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    file_put_contents($dir . $file, "[" . gmdate("Y-m-d H:i:s") . " UTC] $msg\n", FILE_APPEND);
}

function emptyToNull($v) { return ($v === null || $v === '' || (is_string($v) && trim($v) === '')) ? null : $v; }

function saveUtmData($txId, $utm, $customer = [], $address = []) {
    if (empty($txId)) return false;
    $data = [
        'transaction_id' => $txId, 'created_at' => gmdate('Y-m-d H:i:s'),
        'utm_source' => emptyToNull($utm['utm_source'] ?? null),
        'utm_medium' => emptyToNull($utm['utm_medium'] ?? null),
        'utm_campaign' => emptyToNull($utm['utm_campaign'] ?? null),
        'utm_term' => emptyToNull($utm['utm_term'] ?? null),
        'utm_content' => emptyToNull($utm['utm_content'] ?? null),
        'sck' => emptyToNull($utm['sck'] ?? null),
        'src' => emptyToNull($utm['src'] ?? null),
        'fbc' => emptyToNull($utm['fbc'] ?? null),
        'fbp' => emptyToNull($utm['fbp'] ?? null),
        'customer_ip' => $_SERVER['REMOTE_ADDR'] ?? null,
        'customer' => $customer, 'address' => $address
    ];
    return file_put_contents(UTM_STORAGE_DIR . $txId . '.json', json_encode($data, JSON_PRETTY_PRINT)) !== false;
}

function sendToUtmify($tx, $customer, $utm, $product, $status = 'waiting_payment') {
    $phone = !empty($customer['phone']) ? '+55' . preg_replace('/\D/', '', $customer['phone']) : null;
    $info = [
        'orderId' => (string) $tx['id'], 'platform' => 'Umbrellapag', 'paymentMethod' => 'pix',
        'status' => $status, 'createdAt' => gmdate('Y-m-d H:i:s'), 'approvedDate' => null, 'refundedAt' => null,
        'customer' => ['name' => $customer['name'], 'email' => $customer['email'], 'phone' => $phone,
            'document' => $customer['document'], 'country' => 'BR', 'ip' => $_SERVER['REMOTE_ADDR'] ?? null],
        'products' => [['id' => 'PROD01', 'name' => $product['title'] ?? 'Produto Digital',
            'planId' => 'PLAN01', 'planName' => 'Plano Único', 'quantity' => 1, 'priceInCents' => (int) $tx['amount']]],
        'trackingParameters' => ['src' => emptyToNull($utm['src'] ?? null), 'sck' => emptyToNull($utm['sck'] ?? null),
            'utm_source' => emptyToNull($utm['utm_source'] ?? null), 'utm_medium' => emptyToNull($utm['utm_medium'] ?? null),
            'utm_campaign' => emptyToNull($utm['utm_campaign'] ?? null), 'utm_term' => emptyToNull($utm['utm_term'] ?? null),
            'utm_content' => emptyToNull($utm['utm_content'] ?? null)],
        'commission' => ['totalPriceInCents' => (int) $tx['amount'], 'gatewayFeeInCents' => 0,
            'userCommissionInCents' => (int) $tx['amount'], 'currency' => 'BRL'],
        'isTest' => false
    ];
    
    logMsg('utmify_request.log', "Enviando | TX: {$tx['id']} | Status: $status");
    
    $ch = curl_init(UTMIFY_URL);
    curl_setopt_array($ch, [CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($info, JSON_UNESCAPED_UNICODE),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'x-api-token: ' . UTMIFY_TOKEN],
        CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
    $res = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    logMsg('utmify_response.log', "TX: {$tx['id']} | HTTP: $code | Response: $res");
    return $code >= 200 && $code < 300;
}

function apiRequest($endpoint, $method = 'POST', $data = null) {
    $ch = curl_init(API_BASE_URL . $endpoint);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'User-Agent: ' . USER_AGENT, 'x-api-key: ' . API_TOKEN]]);
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }
    $res = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['success' => $code >= 200 && $code < 300, 'httpCode' => $code, 'data' => json_decode($res, true)];
}

function createPixTransaction($p) {
    $valor = 149.70;
    $name = $p['name'] ?? 'Cliente';
    $email = $p['email'] ?? 'cliente@email.com';
    $doc = $p['document'] ?? '00000000000';
    $phone = $p['phone'] ?? '11999999999';
    $title = $p['productTitle'] ?? 'Produto Digital';
    $cents = intval($valor * 100);
    
    $data = [
        'amount' => $cents, 'currency' => 'BRL', 'paymentMethod' => 'pix',
        'customer' => ['name' => $name, 'email' => $email,
            'document' => ['number' => preg_replace('/\D/', '', $doc), 'type' => strlen(preg_replace('/\D/', '', $doc)) > 11 ? 'CNPJ' : 'CPF'],
            'phone' => preg_replace('/\D/', '', $phone)],
        'items' => [['title' => $title, 'unitPrice' => $cents, 'quantity' => 1, 'tangible' => false]],
        'pix' => ['expiresInDays' => 1]
    ];
    
    $result = apiRequest('/api/user/transactions', 'POST', $data);
    
    if ($result['success'] && isset($result['data']['data']['id'])) {
        $txId = $result['data']['data']['id'];
        
        $utm = ['utm_source' => emptyToNull($p['utm_source'] ?? null), 'utm_medium' => emptyToNull($p['utm_medium'] ?? null),
            'utm_campaign' => emptyToNull($p['utm_campaign'] ?? null), 'utm_term' => emptyToNull($p['utm_term'] ?? null),
            'utm_content' => emptyToNull($p['utm_content'] ?? null), 'sck' => emptyToNull($p['sck'] ?? null),
            'src' => emptyToNull($p['src'] ?? null), 'fbc' => emptyToNull($p['fbc'] ?? null), 'fbp' => emptyToNull($p['fbp'] ?? null)];
        
        $customer = ['name' => $name, 'email' => $email, 'document' => preg_replace('/\D/', '', $doc), 'phone' => $phone];
        $address = ['cep' => $p['cep'] ?? null, 'cidade' => $p['cidade'] ?? null, 'estado' => $p['estado'] ?? null];
        
        saveUtmData($txId, $utm, $customer, $address);
        sendToUtmify(['id' => $txId, 'amount' => $cents], $customer, $utm, ['title' => $title], 'waiting_payment');
        
        // ✅ FACEBOOK CAPI - GenerateLead
        try {
            $fb = new FacebookCAPI();
            $fbData = array_merge($customer, $address, ['fbc' => $p['fbc'] ?? null, 'fbp' => $p['fbp'] ?? null, 'ip' => $_SERVER['REMOTE_ADDR'] ?? null]);
            $fb->generateLead($fbData, $valor, $txId, $title);
            logMsg('facebook_lead.log', "GenerateLead enviado | TX: $txId");
        } catch (Exception $e) {
            logMsg('facebook_error.log', "Erro GenerateLead | TX: $txId | " . $e->getMessage());
        }
        
        logMsg('transactions.log', "✅ TX: $txId criada");
    }
    return $result;
}

// Roteamento
$action = $_GET['action'] ?? $_POST['action'] ?? '';
$input = array_merge($_GET, $_POST, json_decode(file_get_contents('php://input'), true) ?? []);

switch ($action) {
    case 'create-pix':
        $required = ['name', 'email', 'document', 'phone'];
        foreach ($required as $f) {
            if (empty($input[$f])) { echo json_encode(['success' => false, 'error' => "Campo $f obrigatório"]); exit; }
        }
        $result = createPixTransaction($input);
        if ($result['success'] && isset($result['data']['data'])) {
            $tx = $result['data']['data'];
            $pix = $tx['qrCode'] ?? $tx['pix']['qrCode'] ?? $tx['pix']['brCode'] ?? $tx['pix']['emv'] ?? $tx['brCode'] ?? $tx['emv'] ?? null;
            echo json_encode(['success' => true, 'transactionId' => $tx['id'], 'pixCode' => $pix, 'amount' => $tx['amount'], 'status' => $tx['status'] ?? 'pending']);
        } else {
            echo json_encode(['success' => false, 'error' => $result['data']['message'] ?? 'Erro', 'httpCode' => $result['httpCode']]);
        }
        break;
        
    case 'check-status':
        $txId = $input['transactionId'] ?? '';
        if (empty($txId)) { echo json_encode(['success' => false, 'error' => 'ID não informado']); exit; }
        $result = apiRequest('/api/user/transactions/' . $txId, 'GET');
        if ($result['success'] && isset($result['data']['data'])) {
            echo json_encode(['success' => true, 'status' => $result['data']['data']['status'] ?? 'pending', 'raw' => $result['data']['data']]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Erro ao verificar']);
        }
        break;
        
    default:
        echo json_encode(['success' => false, 'error' => 'Ação não especificada']);
}