<?php
/**
 * Form Handler - Recebe dados do formulário e envia InitiateCheckout para Facebook
 */
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

require_once __DIR__ . '/facebook_capi.php';

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) { echo json_encode(['success' => false, 'error' => 'Dados inválidos']); exit; }

// Validação
$required = ['name', 'email', 'document', 'phone'];
foreach ($required as $f) {
    if (empty($input[$f])) {
        echo json_encode(['success' => false, 'error' => "Campo $f obrigatório"]);
        exit;
    }
}

// Log
$logDir = __DIR__ . '/logs/';
if (!is_dir($logDir)) mkdir($logDir, 0755, true);
file_put_contents($logDir . 'form_received.log', "[" . gmdate('Y-m-d H:i:s') . "] " . json_encode($input) . "\n", FILE_APPEND);

// Envia InitiateCheckout para Facebook CAPI
try {
    $fb = new FacebookCAPI();
    $userData = [
        'name' => $input['name'],
        'email' => $input['email'],
        'phone' => $input['phone'],
        'document' => $input['document'],
        'cep' => $input['cep'] ?? null,
        'cidade' => $input['cidade'] ?? null,
        'estado' => $input['estado'] ?? null,
        'fbc' => $input['fbc'] ?? null,
        'fbp' => $input['fbp'] ?? null,
        'ip' => $_SERVER['REMOTE_ADDR'] ?? null,
    ];
    
    $value = floatval($input['valor'] ?? 89.70);
    $product = $input['produto'] ?? 'Produto Digital';
    
    $result = $fb->initiateCheckout($userData, $value, $product);
    file_put_contents($logDir . 'facebook_initiate.log', "[" . gmdate('Y-m-d H:i:s') . "] InitiateCheckout: " . json_encode($result) . "\n", FILE_APPEND);
} catch (Exception $e) {
    file_put_contents($logDir . 'facebook_error.log', "[" . gmdate('Y-m-d H:i:s') . "] Error: " . $e->getMessage() . "\n", FILE_APPEND);
}

echo json_encode(['success' => true, 'message' => 'OK']);