<?php
/**
 * WEBHOOK ÚNICO PARA TODOS OS PRODUTOS
 */

// ========== DEBUG INICIAL ==========
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

// ========== CONFIGURAÇÕES ==========
define('UTMIFY_TOKEN', 'tNW12pQZSpOK2QOn1MG5QZ4cyHAmKUvbcibO');
define('FB_PIXEL_ID', '1426704905465356');
define('FB_ACCESS_TOKEN', 'SEU_TOKEN_FACEBOOK_AQUI');
define('LOG_FILE', __DIR__ . '/webhook.log');

// ========== LOG ==========
function logWebhook($msg, $data = null) {
    $log = "[" . date('Y-m-d H:i:s') . "] $msg";
    if ($data) $log .= " | " . json_encode($data, JSON_UNESCAPED_UNICODE);
    @file_put_contents(LOG_FILE, $log . "\n", FILE_APPEND);
}

logWebhook("=== WEBHOOK INICIADO ===");

// ========== BUSCA DADOS SALVOS ==========
function buscarDadosTransacao($txId) {
    $basePath = '/home/monitor/public_html/ofertas-mercadolivre.com/blackfriday/produtos/';
    
    $pattern1 = $basePath . 'MLB-*/checkout/api/utm_storage/' . $txId . '.json';
    $pastas = glob($pattern1);
    if (!empty($pastas) && file_exists($pastas[0])) {
        return json_decode(file_get_contents($pastas[0]), true);
    }
    
    $pattern2 = $basePath . 'MLB*/checkout/api/utm_storage/' . $txId . '.json';
    $pastas2 = glob($pattern2);
    if (!empty($pastas2) && file_exists($pastas2[0])) {
        return json_decode(file_get_contents($pastas2[0]), true);
    }
    
    return null;
}

// ========== RECEBE DADOS ==========
$payload = file_get_contents('php://input');
$data = json_decode($payload, true);

if (!$data) {
    logWebhook("ERRO: Payload vazio");
    http_response_code(400);
    die(json_encode(['error' => 'Payload inválido']));
}

logWebhook("Recebido", $data);

// ========== EXTRAI INFORMAÇÕES ==========
$webhookData = $data['data'] ?? $data;
$orderId = $webhookData['id'] ?? $data['objectId'] ?? uniqid();
$status = $webhookData['status'] ?? '';
$amountCents = $webhookData['amount'] ?? 0;
$amount = $amountCents / 100;

// ========== BUSCA DADOS SALVOS ==========
$savedData = buscarDadosTransacao($orderId);

if ($savedData) {
    $nome = $savedData['customer']['name'] ?? 'Cliente';
    $email = $savedData['customer']['email'] ?? '';
    $phone = $savedData['customer']['phone'] ?? '';
    $document = $savedData['customer']['document'] ?? '';
    $utm_source = $savedData['utm_source'] ?? '';
    $utm_medium = $savedData['utm_medium'] ?? '';
    $utm_campaign = $savedData['utm_campaign'] ?? '';
    $utm_content = $savedData['utm_content'] ?? '';
    $utm_term = $savedData['utm_term'] ?? '';
    $sck = $savedData['sck'] ?? '';
    $src = $savedData['src'] ?? '';
    $fbc = $savedData['fbc'] ?? '';
    $fbp = $savedData['fbp'] ?? '';
    logWebhook("Dados do JSON", ['nome' => $nome]);
} else {
    $customer = $webhookData['customer'] ?? [];
    $payer = $webhookData['payer'] ?? [];
    $nome = $customer['name'] ?? $payer['name'] ?? 'Cliente';
    $email = $customer['email'] ?? '';
    $phone = $customer['phone'] ?? '';
    $document = $customer['document']['number'] ?? $payer['documentNumber'] ?? '';
    $meta = $webhookData['metadata'] ?? [];
    if (is_string($meta)) $meta = json_decode($meta, true) ?? [];
    $utm_source = $meta['utm_source'] ?? '';
    $utm_medium = $meta['utm_medium'] ?? '';
    $utm_campaign = $meta['utm_campaign'] ?? '';
    $utm_content = $meta['utm_content'] ?? '';
    $utm_term = $meta['utm_term'] ?? '';
    $sck = $meta['sck'] ?? '';
    $src = $meta['src'] ?? '';
    $fbc = $meta['fbc'] ?? '';
    $fbp = $meta['fbp'] ?? '';
    logWebhook("Dados do Webhook", ['nome' => $nome, 'email' => $email]);
}

$items = $webhookData['items'] ?? [];
$produto = !empty($items) ? ($items[0]['title'] ?? 'Produto') : 'Produto';

// ========== NORMALIZA STATUS ==========
$statusMap = [
    'CONCLUIDA' => 'paid', 'paid' => 'paid', 'approved' => 'paid', 'completed' => 'paid', 'succeeded' => 'paid',
    'ATIVA' => 'waiting_payment', 'pending' => 'waiting_payment', 'waiting_payment' => 'waiting_payment',
    'DEVOLVIDA' => 'refunded', 'refunded' => 'refunded', 'cancelled' => 'refunded'
];
$statusNorm = $statusMap[$status] ?? 'waiting_payment';

logWebhook("Processando", ['order' => $orderId, 'status' => $statusNorm, 'valor' => $amount, 'produto' => $produto]);

// ========== ENVIA PARA UTMIFY ==========
function enviarUtmify($orderId, $status, $amountCents, $cliente, $produto, $utms) {
    $payload = [
        'orderId' => (string)$orderId,
        'platform' => 'Umbrellapag',
        'paymentMethod' => 'pix',
        'status' => $status,
        'createdAt' => date('Y-m-d H:i:s'),
        'approvedDate' => ($status === 'paid') ? date('Y-m-d H:i:s') : null,
        'refundedAt' => null,
        'customer' => [
            'name' => $cliente['nome'],
            'email' => $cliente['email'],
            'phone' => '+55' . preg_replace('/\D/', '', $cliente['phone']),
            'document' => preg_replace('/\D/', '', $cliente['document']),
            'country' => 'BR',
            'ip' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1'
        ],
        'products' => [[
            'id' => $produto['id'],
            'name' => $produto['nome'],
            'planId' => null,
            'planName' => null,
            'quantity' => 1,
            'priceInCents' => (int)$amountCents
        ]],
        'trackingParameters' => [
            'src' => (string)($utms['src'] ?? ''),
            'sck' => (string)($utms['sck'] ?? ''),
            'utm_source' => (string)($utms['utm_source'] ?? ''),
            'utm_medium' => (string)($utms['utm_medium'] ?? ''),
            'utm_campaign' => (string)($utms['utm_campaign'] ?? ''),
            'utm_content' => (string)($utms['utm_content'] ?? ''),
            'utm_term' => (string)($utms['utm_term'] ?? '')
        ],
        'commission' => [
            'totalPriceInCents' => (int)$amountCents,
            'gatewayFeeInCents' => 0,
            'userCommissionInCents' => (int)$amountCents
        ],
        'isTest' => false
    ];
    
    $ch = curl_init('https://api.utmify.com.br/api-credentials/orders');
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'x-api-token: ' . UTMIFY_TOKEN],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    logWebhook("Utmify", ['code' => $code, 'resp' => $resp]);
    return $code >= 200 && $code < 300;
}

// ========== ENVIA PARA FACEBOOK ==========
function enviarFacebook($evento, $amount, $cliente, $utms) {
    $url = "https://graph.facebook.com/v18.0/" . FB_PIXEL_ID . "/events?access_token=" . FB_ACCESS_TOKEN;
    
    $userData = [
        'em' => [hash('sha256', strtolower(trim($cliente['email'])))],
        'ph' => [hash('sha256', preg_replace('/\D/', '', $cliente['phone']))],
        'fn' => [hash('sha256', strtolower(trim(explode(' ', $cliente['nome'])[0])))],
        'country' => [hash('sha256', 'br')],
        'client_ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'client_user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ];
    if (!empty($utms['fbc'])) $userData['fbc'] = $utms['fbc'];
    if (!empty($utms['fbp'])) $userData['fbp'] = $utms['fbp'];
    
    $eventData = [
        'event_name' => $evento,
        'event_time' => time(),
        'action_source' => 'website',
        'user_data' => $userData,
        'custom_data' => ['currency' => 'BRL', 'value' => (float)$amount]
    ];
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode(['data' => [$eventData]]),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    logWebhook("Facebook $evento", ['code' => $code, 'resp' => $resp]);
    return $code >= 200 && $code < 300;
}

// ========== PROCESSA ==========
$clienteData = ['nome' => $nome, 'email' => $email, 'phone' => $phone, 'document' => $document];
$produtoData = ['id' => $orderId, 'nome' => $produto];
$utmData = ['utm_source' => $utm_source, 'utm_medium' => $utm_medium, 'utm_campaign' => $utm_campaign,
    'utm_content' => $utm_content, 'utm_term' => $utm_term, 'sck' => $sck, 'src' => $src, 'fbc' => $fbc, 'fbp' => $fbp];

$utmifyOk = false;
$fbOk = false;

if ($statusNorm === 'paid' || $statusNorm === 'waiting_payment') {
    $utmifyOk = enviarUtmify($orderId, $statusNorm, $amountCents, $clienteData, $produtoData, $utmData);
}

if ($statusNorm === 'waiting_payment') {
    $fbOk = enviarFacebook('AddPaymentInfo', $amount, $clienteData, $utmData);
} elseif ($statusNorm === 'paid') {
    $fbOk = enviarFacebook('Purchase', $amount, $clienteData, $utmData);
}

logWebhook("=== FINALIZADO ===", ['utmify' => $utmifyOk, 'facebook' => $fbOk]);

http_response_code(200);
echo json_encode(['success' => true, 'order_id' => $orderId, 'status' => $statusNorm, 'amount' => $amount, 'utmify' => $utmifyOk, 'facebook' => $fbOk]);