<?php
/**
 * CONFIGURAÇÃO DO CLOAKER
 */

return [
    // Página para tráfego inválido
    'safe_page' => '/informativo/',
    
    // ==========================================
    // PARÂMETROS OBRIGATÓRIOS
    // ==========================================
    
    'required_params' => [
        // Aceita todo tráfego da Meta
        'utm_source' => [
            'FB', 'fb', 'Facebook', 'facebook',
            'IG', 'ig', 'Instagram', 'instagram',
            'META', 'Meta', 'meta',
            'messenger', 'Messenger',
            'an', 'AN', 'audience_network', 'AudienceNetwork',
            'facebook_ads', 'fb_ads', 'meta_ads',
        ],
        
        // Obrigatórios, qualquer valor
        'utm_medium'   => null,
        'utm_campaign' => null,
        'utm_content'  => null,
        'utm_term'     => null,
    ],
    
    // ==========================================
    // REDIRECIONAMENTOS
    // ==========================================
    
    'campaigns' => [
        'default' => '/desconto/',
    ],
    
    // ==========================================
    // PARÂMETROS ESPECIAIS (opcional)
    // ==========================================
    
    'special_params' => [],
    
    // ==========================================
    // PAÍSES PERMITIDOS
    // ==========================================
    
    'geo' => [
        'enabled' => true,
        'allowed_countries' => ['BR'],
        'database_path' => __DIR__ . '/security.mmdb',
    ],
    
    // ==========================================
    // PARÂMETROS PRESERVADOS NO REDIRECT
    // ==========================================
    
    'preserve_params' => [
        'utm_source',
        'utm_medium',
        'utm_campaign',
        'utm_content',
        'utm_term',
        'fbclid',
    ],
    
    // ==========================================
    // DETECÇÃO DE BOTS
    // ==========================================
    
    'bot_detection' => [
        'enabled' => true,
        'block_empty_ua' => true,
        'suspicious_keywords' => [
            'bot', 'crawler', 'spider', 'scraper',
            'curl', 'wget', 'python-requests',
            'headless', 'phantom', 'selenium'
        ],
    ],
    
    // ==========================================
    // COOKIES E LOGS
    // ==========================================
    
    'cookie' => [
        'name'     => 'vld',
        'value'    => '1',
        'duration' => 3600,
        'path'     => '/',
        'secure'   => true,
        'httponly' => true,
        'samesite' => 'Lax',
    ],
    
    'logging' => [
        'enabled'  => true,
        'file'     => __DIR__ . '/logs/acessos.log',
        'max_size' => 5242880,
    ],
];