<?php
/**
 * Backend - API Umbrellapag
 * Apenas cria Pix e salva dados no JSON
 * O webhook cuida de enviar para Utmify e Facebook
 */
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

define('API_BASE_URL', 'https://api-gateway.umbrellapag.com');
define('API_TOKEN', 'd46fa92f-9484-409f-a82a-e2734029979e');
define('USER_AGENT', 'AtivoB2B/1.0');
define('UTM_STORAGE_DIR', __DIR__ . '/utm_storage/');

if (!is_dir(UTM_STORAGE_DIR)) mkdir(UTM_STORAGE_DIR, 0755, true);

function logMsg($file, $msg) {
    $dir = __DIR__ . '/logs/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    file_put_contents($dir . $file, "[" . gmdate("Y-m-d H:i:s") . " UTC] $msg\n", FILE_APPEND);
}

function emptyToNull($v) { return ($v === null || $v === '' || (is_string($v) && trim($v) === '')) ? null : $v; }

function saveUtmData($txId, $utm, $customer = [], $address = []) {
    if (empty($txId)) return false;
    $data = [
        'transaction_id' => $txId, 
        'created_at' => gmdate('Y-m-d H:i:s'),
        'utm_source' => emptyToNull($utm['utm_source'] ?? null),
        'utm_medium' => emptyToNull($utm['utm_medium'] ?? null),
        'utm_campaign' => emptyToNull($utm['utm_campaign'] ?? null),
        'utm_term' => emptyToNull($utm['utm_term'] ?? null),
        'utm_content' => emptyToNull($utm['utm_content'] ?? null),
        'sck' => emptyToNull($utm['sck'] ?? null),
        'src' => emptyToNull($utm['src'] ?? null),
        'fbc' => emptyToNull($utm['fbc'] ?? null),
        'fbp' => emptyToNull($utm['fbp'] ?? null),
        'customer_ip' => $_SERVER['REMOTE_ADDR'] ?? null,
        'customer' => $customer, 
        'address' => $address
    ];
    
    $saved = file_put_contents(UTM_STORAGE_DIR . $txId . '.json', json_encode($data, JSON_PRETTY_PRINT)) !== false;
    logMsg('utm_save.log', "TX: $txId | Saved: " . ($saved ? 'YES' : 'NO') . " | UTMs: " . json_encode($utm));
    return $saved;
}

function apiRequest($endpoint, $method = 'POST', $data = null) {
    $ch = curl_init(API_BASE_URL . $endpoint);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true, 
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json', 
            'User-Agent: ' . USER_AGENT, 
            'x-api-key: ' . API_TOKEN
        ]
    ]);
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }
    $res = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    return ['success' => $code >= 200 && $code < 300, 'httpCode' => $code, 'data' => json_decode($res, true)];
}

function createPixTransaction($p) {
    $valor = 68.70; // Altere o valor do produto aqui
    $name = $p['name'] ?? 'Cliente';
    $email = $p['email'] ?? 'cliente@email.com';
    $doc = $p['document'] ?? '00000000000';
    $phone = $p['phone'] ?? '11999999999';
    $title = $p['productTitle'] ?? 'Produto Digital';
    $cents = intval($valor * 100);
    
    $data = [
        'amount' => $cents, 
        'currency' => 'BRL', 
        'paymentMethod' => 'pix',
        'customer' => [
            'name' => $name, 
            'email' => $email,
            'document' => [
                'number' => preg_replace('/\D/', '', $doc), 
                'type' => strlen(preg_replace('/\D/', '', $doc)) > 11 ? 'CNPJ' : 'CPF'
            ],
            'phone' => preg_replace('/\D/', '', $phone)
        ],
        'items' => [[
            'title' => $title, 
            'unitPrice' => $cents, 
            'quantity' => 1, 
            'tangible' => false
        ]],
        'pix' => ['expiresInDays' => 1]
    ];
    
    $result = apiRequest('/api/user/transactions', 'POST', $data);
    
    if ($result['success'] && isset($result['data']['data']['id'])) {
        $txId = $result['data']['data']['id'];
        
        // Salva UTMs e dados do cliente no JSON
        $utm = [
            'utm_source' => emptyToNull($p['utm_source'] ?? null), 
            'utm_medium' => emptyToNull($p['utm_medium'] ?? null),
            'utm_campaign' => emptyToNull($p['utm_campaign'] ?? null), 
            'utm_term' => emptyToNull($p['utm_term'] ?? null),
            'utm_content' => emptyToNull($p['utm_content'] ?? null), 
            'sck' => emptyToNull($p['sck'] ?? null),
            'src' => emptyToNull($p['src'] ?? null), 
            'fbc' => emptyToNull($p['fbc'] ?? null), 
            'fbp' => emptyToNull($p['fbp'] ?? null)
        ];
        
        $customer = [
            'name' => $name, 
            'email' => $email, 
            'document' => preg_replace('/\D/', '', $doc), 
            'phone' => $phone
        ];
        
        $address = [
            'cep' => $p['cep'] ?? null, 
            'cidade' => $p['cidade'] ?? null, 
            'estado' => $p['estado'] ?? null
        ];
        
        // Salva os dados - o webhook vai buscar esse JSON
        saveUtmData($txId, $utm, $customer, $address);
        
        logMsg('transactions.log', "✅ TX: $txId criada | Cliente: $name | Valor: $valor");
    }
    
    return $result;
}

// Roteamento
$action = $_GET['action'] ?? $_POST['action'] ?? '';
$input = array_merge($_GET, $_POST, json_decode(file_get_contents('php://input'), true) ?? []);

switch ($action) {
    case 'create-pix':
        $required = ['name', 'email', 'document', 'phone'];
        foreach ($required as $f) {
            if (empty($input[$f])) { 
                echo json_encode(['success' => false, 'error' => "Campo $f obrigatório"]); 
                exit; 
            }
        }
        $result = createPixTransaction($input);
        if ($result['success'] && isset($result['data']['data'])) {
            $tx = $result['data']['data'];
            $pix = $tx['qrCode'] ?? $tx['pix']['qrCode'] ?? $tx['pix']['brCode'] ?? $tx['pix']['emv'] ?? $tx['brCode'] ?? $tx['emv'] ?? null;
            echo json_encode([
                'success' => true, 
                'transactionId' => $tx['id'], 
                'pixCode' => $pix, 
                'amount' => $tx['amount'], 
                'status' => $tx['status'] ?? 'pending'
            ]);
        } else {
            echo json_encode([
                'success' => false, 
                'error' => $result['data']['message'] ?? 'Erro', 
                'httpCode' => $result['httpCode']
            ]);
        }
        break;
        
    case 'check-status':
        $txId = $input['transactionId'] ?? '';
        if (empty($txId)) { 
            echo json_encode(['success' => false, 'error' => 'ID não informado']); 
            exit; 
        }
        $result = apiRequest('/api/user/transactions/' . $txId, 'GET');
        if ($result['success'] && isset($result['data']['data'])) {
            echo json_encode([
                'success' => true, 
                'status' => $result['data']['data']['status'] ?? 'pending', 
                'raw' => $result['data']['data']
            ]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Erro ao verificar']);
        }
        break;
        
    default:
        echo json_encode(['success' => false, 'error' => 'Ação não especificada']);
}