<?php
/**
 * Facebook CAPI - InitiateCheckout
 * Recebe dados do preloader e envia para o Facebook
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// ========== CONFIGURAÇÕES ==========
define('FB_PIXEL_ID', '1426704905465356');
define('FB_ACCESS_TOKEN', 'EAARtphyE16sBQBZCcZAf2KwLzTig7lHOyRbbLKK99s4BmQCXlahcxK3xZBjoZBrocpTSq6tfpUNMV0X74ifvoQULLFcagOC3UDBnc1UHf4TDaGX5WSgF8jhZCProR8q80eJL5tCkzD30eQPBpkhZCQz2p3ptQK4aSaRRDhaxNDAMgamfEM3ImlAd6oRKgkiZANM0gZDZD'); // COLOQUE SEU TOKEN
define('LOG_FILE', __DIR__ . '/initiate_checkout.log');

// ========== LOG ==========
function logEvent($msg, $data = null) {
    $log = "[" . date('Y-m-d H:i:s') . "] $msg";
    if ($data) $log .= " | " . json_encode($data, JSON_UNESCAPED_UNICODE);
    @file_put_contents(LOG_FILE, $log . "\n", FILE_APPEND);
}

// ========== RECEBE DADOS ==========
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    logEvent("ERRO: Payload vazio");
    http_response_code(400);
    die(json_encode(['success' => false, 'error' => 'Payload inválido']));
}

logEvent("Recebido", $input);

// ========== MONTA USER_DATA ==========
$userData = [];

// IP do cliente
$clientIp = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
if (strpos($clientIp, ',') !== false) {
    $clientIp = trim(explode(',', $clientIp)[0]);
}
$userData['client_ip_address'] = $clientIp;

// User Agent
$userData['client_user_agent'] = $input['user_agent'] ?? $_SERVER['HTTP_USER_AGENT'] ?? '';

// Facebook Click ID (fbc)
if (!empty($input['fbc'])) {
    $userData['fbc'] = $input['fbc'];
}

// Facebook Browser ID (fbp)
if (!empty($input['fbp'])) {
    $userData['fbp'] = $input['fbp'];
}

// País (sempre BR)
$userData['country'] = [hash('sha256', 'br')];

// ========== MONTA CUSTOM_DATA ==========
$customData = [
    'currency' => $input['currency'] ?? 'BRL',
    'value' => (float)($input['value'] ?? 0),
    'content_type' => $input['content_type'] ?? 'product',
    'content_name' => $input['content_name'] ?? 'Produto',
    'num_items' => (int)($input['num_items'] ?? 1)
];

// ========== MONTA O EVENTO ==========
$eventData = [
    'event_name' => 'InitiateCheckout',
    'event_time' => $input['event_time'] ?? time(),
    'event_id' => $input['event_id'] ?? uniqid('ic_'),
    'event_source_url' => $input['source_url'] ?? '',
    'action_source' => 'website',
    'user_data' => $userData,
    'custom_data' => $customData
];

// ========== ENVIA PARA O FACEBOOK ==========
$url = "https://graph.facebook.com/v18.0/" . FB_PIXEL_ID . "/events?access_token=" . FB_ACCESS_TOKEN;

$payload = json_encode(['data' => [$eventData]]);

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

logEvent("Facebook Response", [
    'code' => $httpCode,
    'response' => $response,
    'error' => $error,
    'event_id' => $eventData['event_id']
]);

// ========== RESPOSTA ==========
$success = $httpCode >= 200 && $httpCode < 300;

echo json_encode([
    'success' => $success,
    'event_id' => $eventData['event_id'],
    'http_code' => $httpCode,
    'facebook_response' => json_decode($response, true)
]);