<?php
/**
 * Status Check - Umbrellapag API
 */
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

define('API_BASE_URL', 'https://api-gateway.umbrellapag.com');
define('API_TOKEN', 'd46fa92f-9484-409f-a82a-e2734029979e');
define('USER_AGENT', 'AtivoB2B/1.0');

$id_transacao = $_POST['id_transacao_post'] ?? $_GET['id_transacao'] ?? $_GET['transactionId'] ?? '';

if (empty($id_transacao)) {
    echo json_encode(['success' => false, 'error' => 'ID da transação não fornecido']);
    exit;
}

$headers = ['Content-Type: application/json', 'User-Agent: ' . USER_AGENT, 'x-api-key: ' . API_TOKEN];

$curl = curl_init(API_BASE_URL . '/api/user/transactions/' . $id_transacao);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
curl_setopt($curl, CURLOPT_TIMEOUT, 30);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

if ($httpCode >= 200 && $httpCode < 300) {
    $data = json_decode($response, true);
    $txData = $data['data'] ?? $data;
    $status = $txData['status'] ?? 'unknown';
    $isPaid = in_array(strtolower($status), ['paid', 'approved', 'completed', 'success', 'confirmed']);
    
    echo json_encode([
        'success' => true,
        'transactionId' => $id_transacao,
        'status' => $status,
        'isPaid' => $isPaid,
        'amount' => $txData['amount'] ?? null,
        'raw' => $txData
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Erro na comunicação', 'httpCode' => $httpCode]);
}