<?php
/**
 * WEBHOOK COMPLETO - Utmify + Facebook CAPI
 * Versão otimizada com TODOS os parâmetros do Facebook
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

// ========== CONFIGURAÇÕES ==========
define('UTMIFY_TOKEN', 'yhqGREtGtmvoDF3qAoCIq5eU2Rv5WCkbjLNF');
define('FB_PIXEL_ID', '1426704905465356');
define('FB_ACCESS_TOKEN', 'EAARtphyE16sBQBZCcZAf2KwLzTig7lHOyRbbLKK99s4BmQCXlahcxK3xZBjoZBrocpTSq6tfpUNMV0X74ifvoQULLFcagOC3UDBnc1UHf4TDaGX5WSgF8jhZCProR8q80eJL5tCkzD30eQPBpkhZCQz2p3ptQK4aSaRRDhaxNDAMgamfEM3ImlAd6oRKgkiZANM0gZDZD'); // COLOQUE SEU TOKEN AQUI
define('LOG_FILE', __DIR__ . '/webhook.log');

// ========== LOG ==========
function logWebhook($msg, $data = null) {
    $log = "[" . date('Y-m-d H:i:s') . "] $msg";
    if ($data) $log .= " | " . json_encode($data, JSON_UNESCAPED_UNICODE);
    @file_put_contents(LOG_FILE, $log . "\n", FILE_APPEND);
}

logWebhook("=== WEBHOOK INICIADO ===");

// ========== BUSCA DADOS SALVOS ==========
function buscarDadosTransacao($txId) {
    $basePath = '/home/ofertas-mercadolivre/htdocs/ofertas-mercadolivre.com/blackfriday/produtos/';
    
    $pattern1 = $basePath . 'MLB-*/checkout/api/utm_storage/' . $txId . '.json';
    $pastas = glob($pattern1);
    if (!empty($pastas) && file_exists($pastas[0])) {
        logWebhook("JSON encontrado", ['file' => $pastas[0]]);
        return json_decode(file_get_contents($pastas[0]), true);
    }
    
    $pattern2 = $basePath . 'MLB*/checkout/api/utm_storage/' . $txId . '.json';
    $pastas2 = glob($pattern2);
    if (!empty($pastas2) && file_exists($pastas2[0])) {
        logWebhook("JSON encontrado", ['file' => $pastas2[0]]);
        return json_decode(file_get_contents($pastas2[0]), true);
    }
    
    logWebhook("JSON NAO encontrado", ['txId' => $txId]);
    return null;
}

// ========== RECEBE DADOS ==========
$payload = file_get_contents('php://input');
$data = json_decode($payload, true);

if (!$data) {
    logWebhook("ERRO: Payload vazio");
    http_response_code(400);
    die(json_encode(['error' => 'Payload inválido']));
}

logWebhook("Recebido", $data);

// ========== EXTRAI INFORMAÇÕES ==========
$webhookData = $data['data'] ?? $data;
$orderId = $webhookData['id'] ?? $data['objectId'] ?? uniqid();
$status = $webhookData['status'] ?? '';
$amountCents = $webhookData['amount'] ?? 0;
$amount = $amountCents / 100;

// IP do cliente (pega do webhook se disponível)
$clientIp = $webhookData['ip'] ?? $_SERVER['REMOTE_ADDR'] ?? '';

// ========== BUSCA DADOS SALVOS ==========
$savedData = buscarDadosTransacao($orderId);

if ($savedData) {
    // Dados do JSON salvo pelo umbrela.php
    $nome = $savedData['customer']['name'] ?? 'Cliente';
    $email = $savedData['customer']['email'] ?? '';
    $phone = $savedData['customer']['phone'] ?? '';
    $document = $savedData['customer']['document'] ?? '';
    $cidade = $savedData['address']['cidade'] ?? '';
    $estado = $savedData['address']['estado'] ?? '';
    $cep = $savedData['address']['cep'] ?? '';
    $utm_source = $savedData['utm_source'] ?? '';
    $utm_medium = $savedData['utm_medium'] ?? '';
    $utm_campaign = $savedData['utm_campaign'] ?? '';
    $utm_content = $savedData['utm_content'] ?? '';
    $utm_term = $savedData['utm_term'] ?? '';
    $sck = $savedData['sck'] ?? '';
    $src = $savedData['src'] ?? '';
    $fbc = $savedData['fbc'] ?? '';
    $fbp = $savedData['fbp'] ?? '';
    $clientIp = $savedData['customer_ip'] ?? $clientIp;
    
    logWebhook("Dados do JSON", [
        'nome' => $nome, 
        'email' => $email,
        'cidade' => $cidade, 
        'estado' => $estado,
        'utm_source' => $utm_source,
        'utm_campaign' => $utm_campaign
    ]);
} else {
    // Fallback: dados do webhook do Umbrellapag
    $customer = $webhookData['customer'] ?? [];
    $payer = $webhookData['payer'] ?? [];
    $nome = $customer['name'] ?? $payer['name'] ?? 'Cliente';
    $email = $customer['email'] ?? '';
    $phone = $customer['phone'] ?? '';
    $document = $customer['document']['number'] ?? $payer['documentNumber'] ?? '';
    
    // Endereço do webhook
    $address = $customer['address'] ?? [];
    $cidade = $address['city'] ?? $address['cidade'] ?? '';
    $estado = $address['state'] ?? $address['estado'] ?? '';
    $cep = $address['zipCode'] ?? $address['cep'] ?? '';
    
    // Metadata
    $meta = $webhookData['metadata'] ?? [];
    if (is_string($meta)) $meta = json_decode($meta, true) ?? [];
    $utm_source = $meta['utm_source'] ?? '';
    $utm_medium = $meta['utm_medium'] ?? '';
    $utm_campaign = $meta['utm_campaign'] ?? '';
    $utm_content = $meta['utm_content'] ?? '';
    $utm_term = $meta['utm_term'] ?? '';
    $sck = $meta['sck'] ?? '';
    $src = $meta['src'] ?? '';
    $fbc = $meta['fbc'] ?? '';
    $fbp = $meta['fbp'] ?? '';
    
    logWebhook("Dados do Webhook (fallback)", ['nome' => $nome, 'email' => $email]);
}

// Produto
$items = $webhookData['items'] ?? [];
$produto = !empty($items) ? ($items[0]['title'] ?? 'Produto') : 'Produto';
$produtoId = !empty($items) ? ($items[0]['externalRef'] ?? 'PROD01') : 'PROD01';

// ========== NORMALIZA STATUS ==========
$statusMap = [
    'CONCLUIDA' => 'paid', 'paid' => 'paid', 'approved' => 'paid', 
    'completed' => 'paid', 'succeeded' => 'paid',
    'ATIVA' => 'waiting_payment', 'pending' => 'waiting_payment', 
    'waiting_payment' => 'waiting_payment',
    'DEVOLVIDA' => 'refunded', 'refunded' => 'refunded', 'cancelled' => 'refunded'
];
$statusNorm = $statusMap[$status] ?? 'waiting_payment';

logWebhook("Processando", [
    'order' => $orderId, 
    'status' => $statusNorm, 
    'valor' => $amount, 
    'produto' => $produto
]);

// ========== ENVIA PARA UTMIFY ==========
function enviarUtmify($orderId, $status, $amountCents, $cliente, $produto, $utms) {
    $payload = [
        'orderId' => (string)$orderId,
        'platform' => 'Umbrellapag',
        'paymentMethod' => 'pix',
        'status' => $status,
        'createdAt' => date('Y-m-d H:i:s'),
        'approvedDate' => ($status === 'paid') ? date('Y-m-d H:i:s') : null,
        'refundedAt' => ($status === 'refunded') ? date('Y-m-d H:i:s') : null,
        'customer' => [
            'name' => $cliente['nome'],
            'email' => $cliente['email'],
            'phone' => '+55' . preg_replace('/\D/', '', $cliente['phone']),
            'document' => preg_replace('/\D/', '', $cliente['document']),
            'country' => 'BR',
            'ip' => $cliente['ip'] ?? '127.0.0.1'
        ],
        'products' => [[
            'id' => $produto['id'],
            'name' => $produto['nome'],
            'planId' => null,
            'planName' => null,
            'quantity' => 1,
            'priceInCents' => (int)$amountCents
        ]],
        'trackingParameters' => [
            'src' => (string)($utms['src'] ?? ''),
            'sck' => (string)($utms['sck'] ?? ''),
            'utm_source' => (string)($utms['utm_source'] ?? ''),
            'utm_medium' => (string)($utms['utm_medium'] ?? ''),
            'utm_campaign' => (string)($utms['utm_campaign'] ?? ''),
            'utm_content' => (string)($utms['utm_content'] ?? ''),
            'utm_term' => (string)($utms['utm_term'] ?? '')
        ],
        'commission' => [
            'totalPriceInCents' => (int)$amountCents,
            'gatewayFeeInCents' => 0,
            'userCommissionInCents' => (int)$amountCents
        ],
        'isTest' => false
    ];
    
    $ch = curl_init('https://api.utmify.com.br/api-credentials/orders');
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'x-api-token: ' . UTMIFY_TOKEN],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    logWebhook("Utmify", ['code' => $code, 'resp' => $resp]);
    return $code >= 200 && $code < 300;
}

// ========== ENVIA PARA FACEBOOK CAPI ==========
function enviarFacebook($evento, $amount, $cliente, $utms, $orderId, $produto) {
    $url = "https://graph.facebook.com/v18.0/" . FB_PIXEL_ID . "/events?access_token=" . FB_ACCESS_TOKEN;
    
    // ===== SEPARA NOME E SOBRENOME =====
    $nomeParts = explode(' ', trim($cliente['nome']));
    $firstName = strtolower(trim($nomeParts[0] ?? ''));
    
    // Sobrenome = último nome (se tiver mais de 1 nome)
    $lastName = '';
    if (count($nomeParts) > 1) {
        $lastName = strtolower(trim(end($nomeParts)));
    }
    
    // ===== MONTA USER_DATA COM TODOS OS PARÂMETROS =====
    $userData = [];
    
    // Email (obrigatório) - lowercase, trim, hash
    if (!empty($cliente['email'])) {
        $emailClean = strtolower(trim($cliente['email']));
        $userData['em'] = [hash('sha256', $emailClean)];
    }
    
    // Telefone - formato: 5511999999999 (sem +, sem espaços)
    if (!empty($cliente['phone'])) {
        $phone = preg_replace('/\D/', '', $cliente['phone']);
        if (strlen($phone) <= 11) $phone = '55' . $phone;
        $userData['ph'] = [hash('sha256', $phone)];
    }
    
    // Primeiro nome
    if (!empty($firstName)) {
        $userData['fn'] = [hash('sha256', $firstName)];
    }
    
    // Sobrenome
    if (!empty($lastName)) {
        $userData['ln'] = [hash('sha256', $lastName)];
    }
    
    // Data de nascimento (se disponível) - formato: YYYYMMDD
    // $userData['db'] = [hash('sha256', '19900101')];
    
    // Gênero (se disponível) - 'm' ou 'f'
    // $userData['ge'] = [hash('sha256', 'm')];
    
    // Cidade - lowercase, sem acentos, sem espaços
    if (!empty($cliente['cidade'])) {
        $cidadeClean = strtolower(trim($cliente['cidade']));
        // Remove acentos
        $cidadeClean = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $cidadeClean);
        // Remove caracteres especiais
        $cidadeClean = preg_replace('/[^a-z]/', '', $cidadeClean);
        if (!empty($cidadeClean)) {
            $userData['ct'] = [hash('sha256', $cidadeClean)];
        }
    }
    
    // Estado - 2 letras minúsculas
    if (!empty($cliente['estado'])) {
        $estadoClean = strtolower(substr(trim($cliente['estado']), 0, 2));
        $userData['st'] = [hash('sha256', $estadoClean)];
    }
    
    // CEP - só números, sem hífen
    if (!empty($cliente['cep'])) {
        $cepClean = preg_replace('/\D/', '', $cliente['cep']);
        if (!empty($cepClean)) {
            $userData['zp'] = [hash('sha256', $cepClean)];
        }
    }
    
    // País - sempre 'br' para Brasil
    $userData['country'] = [hash('sha256', 'br')];
    
    // External ID - CPF hasheado (ajuda no match)
    if (!empty($cliente['document'])) {
        $docClean = preg_replace('/\D/', '', $cliente['document']);
        $userData['external_id'] = [hash('sha256', $docClean)];
    }
    
    // IP do cliente (NÃO hashear)
    if (!empty($cliente['ip'])) {
        $userData['client_ip_address'] = $cliente['ip'];
    }
    
    // User Agent (NÃO hashear)
    $userData['client_user_agent'] = $_SERVER['HTTP_USER_AGENT'] ?? 'Mozilla/5.0';
    
    // Facebook Click ID - fbc (NÃO hashear)
    if (!empty($utms['fbc'])) {
        $userData['fbc'] = $utms['fbc'];
    }
    
    // Facebook Browser ID - fbp (NÃO hashear)
    if (!empty($utms['fbp'])) {
        $userData['fbp'] = $utms['fbp'];
    }
    
    // ===== EVENT ID PARA DEDUPLICAÇÃO =====
    $eventId = $orderId . '_' . $evento . '_' . time();
    
    // ===== CUSTOM DATA =====
    $customData = [
        'currency' => 'BRL',
        'value' => (float)$amount,
        'content_type' => 'product',
        'content_ids' => [$produto['id']],
        'content_name' => $produto['nome'],
        'content_category' => 'Produtos',
        'num_items' => 1,
        'order_id' => $orderId
    ];
    
    // ===== MONTA O EVENTO =====
    $eventData = [
        'event_name' => $evento,
        'event_time' => time(),
        'event_id' => $eventId,
        'event_source_url' => 'https://ofertas-mercadolivre.com/blackfriday/',
        'action_source' => 'website',
        'user_data' => $userData,
        'custom_data' => $customData
    ];
    
    // ===== ENVIA =====
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode(['data' => [$eventData]]),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    logWebhook("Facebook $evento", [
        'code' => $code, 
        'resp' => $resp, 
        'event_id' => $eventId,
        'user_data_keys' => array_keys($userData)
    ]);
    
    return $code >= 200 && $code < 300;
}

// ========== PROCESSA ==========
$clienteData = [
    'nome' => $nome,
    'email' => $email,
    'phone' => $phone,
    'document' => $document,
    'cidade' => $cidade ?? '',
    'estado' => $estado ?? '',
    'cep' => $cep ?? '',
    'ip' => $clientIp
];

$produtoData = [
    'id' => $produtoId,
    'nome' => $produto
];

$utmData = [
    'utm_source' => $utm_source,
    'utm_medium' => $utm_medium,
    'utm_campaign' => $utm_campaign,
    'utm_content' => $utm_content,
    'utm_term' => $utm_term,
    'sck' => $sck,
    'src' => $src,
    'fbc' => $fbc,
    'fbp' => $fbp
];

// ========== ENVIA PARA UTMIFY ==========
$utmifyOk = false;
if ($statusNorm === 'paid' || $statusNorm === 'waiting_payment') {
    $utmifyOk = enviarUtmify($orderId, $statusNorm, $amountCents, $clienteData, $produtoData, $utmData);
}

// ========== ENVIA PARA FACEBOOK ==========
$fbLeadOk = false;
$fbPaymentOk = false;
$fbPurchaseOk = false;

if ($statusNorm === 'waiting_payment') {
    // Pix gerado: Lead + AddPaymentInfo
    $fbLeadOk = enviarFacebook('Lead', $amount, $clienteData, $utmData, $orderId, $produtoData);
    $fbPaymentOk = enviarFacebook('AddPaymentInfo', $amount, $clienteData, $utmData, $orderId, $produtoData);
} elseif ($statusNorm === 'paid') {
    // Pix pago: Purchase
    $fbPurchaseOk = enviarFacebook('Purchase', $amount, $clienteData, $utmData, $orderId, $produtoData);
}

logWebhook("=== FINALIZADO ===", [
    'utmify' => $utmifyOk,
    'fb_lead' => $fbLeadOk,
    'fb_payment' => $fbPaymentOk,
    'fb_purchase' => $fbPurchaseOk
]);

http_response_code(200);
echo json_encode([
    'success' => true,
    'order_id' => $orderId,
    'status' => $statusNorm,
    'amount' => $amount,
    'utmify' => $utmifyOk,
    'facebook' => [
        'lead' => $fbLeadOk,
        'payment' => $fbPaymentOk,
        'purchase' => $fbPurchaseOk
    ]
]);