<?php
/**
 * Facebook CAPI - Lead
 * Recebe dados do checkout e envia para o Facebook com dados do cliente
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// ========== CONFIGURAÇÕES ==========
define('FB_PIXEL_ID', '1426704905465356');
define('FB_ACCESS_TOKEN', 'EAARtphyE16sBQBZCcZAf2KwLzTig7lHOyRbbLKK99s4BmQCXlahcxK3xZBjoZBrocpTSq6tfpUNMV0X74ifvoQULLFcagOC3UDBnc1UHf4TDaGX5WSgF8jhZCProR8q80eJL5tCkzD30eQPBpkhZCQz2p3ptQK4aSaRRDhaxNDAMgamfEM3ImlAd6oRKgkiZANM0gZDZD'); // COLOQUE SEU TOKEN
define('LOG_FILE', __DIR__ . '/facebook_lead.log');

// ========== LOG ==========
function logEvent($msg, $data = null) {
    $log = "[" . date('Y-m-d H:i:s') . "] $msg";
    if ($data) $log .= " | " . json_encode($data, JSON_UNESCAPED_UNICODE);
    @file_put_contents(LOG_FILE, $log . "\n", FILE_APPEND);
}

// ========== RECEBE DADOS ==========
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    logEvent("ERRO: Payload vazio");
    http_response_code(400);
    die(json_encode(['success' => false, 'error' => 'Payload inválido']));
}

logEvent("Recebido", $input);

// ========== MONTA USER_DATA ==========
$userData = [];

// Email (hash SHA256)
if (!empty($input['email'])) {
    $email = strtolower(trim($input['email']));
    $userData['em'] = [hash('sha256', $email)];
}

// Telefone (hash SHA256) - formato: 5511999999999
if (!empty($input['phone'])) {
    $phone = preg_replace('/\D/', '', $input['phone']);
    if (strlen($phone) <= 11) $phone = '55' . $phone;
    $userData['ph'] = [hash('sha256', $phone)];
}

// Nome e Sobrenome
if (!empty($input['name'])) {
    $nameParts = explode(' ', trim($input['name']));
    $firstName = strtolower($nameParts[0]);
    $userData['fn'] = [hash('sha256', $firstName)];
    
    if (count($nameParts) > 1) {
        $lastName = strtolower(end($nameParts));
        $userData['ln'] = [hash('sha256', $lastName)];
    }
}

// CPF como external_id
if (!empty($input['document'])) {
    $doc = preg_replace('/\D/', '', $input['document']);
    $userData['external_id'] = [hash('sha256', $doc)];
}

// Cidade (hash SHA256) - sem acentos, minúsculo
if (!empty($input['cidade'])) {
    $cidade = strtolower(trim($input['cidade']));
    $cidade = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $cidade);
    $cidade = preg_replace('/[^a-z]/', '', $cidade);
    if (!empty($cidade)) {
        $userData['ct'] = [hash('sha256', $cidade)];
    }
}

// Estado (hash SHA256) - 2 letras minúsculas
if (!empty($input['estado'])) {
    $estado = strtolower(substr(trim($input['estado']), 0, 2));
    $userData['st'] = [hash('sha256', $estado)];
}

// CEP (hash SHA256) - só números
if (!empty($input['cep'])) {
    $cep = preg_replace('/\D/', '', $input['cep']);
    if (!empty($cep)) {
        $userData['zp'] = [hash('sha256', $cep)];
    }
}

// País
$userData['country'] = [hash('sha256', 'br')];

// IP do cliente
$clientIp = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
if (strpos($clientIp, ',') !== false) {
    $clientIp = trim(explode(',', $clientIp)[0]);
}
$userData['client_ip_address'] = $clientIp;

// User Agent
$userData['client_user_agent'] = $input['user_agent'] ?? $_SERVER['HTTP_USER_AGENT'] ?? '';

// Facebook Click ID (fbc)
if (!empty($input['fbc'])) {
    $userData['fbc'] = $input['fbc'];
}

// Facebook Browser ID (fbp)
if (!empty($input['fbp'])) {
    $userData['fbp'] = $input['fbp'];
}

// ========== MONTA CUSTOM_DATA ==========
$customData = [
    'currency' => $input['currency'] ?? 'BRL',
    'value' => (float)($input['value'] ?? 0),
    'content_type' => $input['content_type'] ?? 'product',
    'content_name' => $input['content_name'] ?? 'Produto'
];

// ========== MONTA O EVENTO ==========
$eventData = [
    'event_name' => 'Lead',
    'event_time' => $input['event_time'] ?? time(),
    'event_id' => $input['event_id'] ?? uniqid('lead_'),
    'event_source_url' => $input['source_url'] ?? '',
    'action_source' => 'website',
    'user_data' => $userData,
    'custom_data' => $customData
];

// ========== ENVIA PARA O FACEBOOK ==========
$url = "https://graph.facebook.com/v18.0/" . FB_PIXEL_ID . "/events?access_token=" . FB_ACCESS_TOKEN;

$payload = json_encode(['data' => [$eventData]]);

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

logEvent("Facebook Response", [
    'code' => $httpCode,
    'response' => $response,
    'error' => $error,
    'event_id' => $eventData['event_id'],
    'user_data_keys' => array_keys($userData)
]);

// ========== RESPOSTA ==========
$success = $httpCode >= 200 && $httpCode < 300;

echo json_encode([
    'success' => $success,
    'event_id' => $eventData['event_id'],
    'http_code' => $httpCode,
    'facebook_response' => json_decode($response, true)
]);