<?php
/**
 * Facebook Conversions API (CAPI)
 */

define('FB_PIXEL_ID', '1426704905465356');
define('FB_ACCESS_TOKEN', 'EAARtphyE16sBQPNJNsIaLAZBFmZCqFkkxwb8VYZANZBHDztF8sPJVvDs5USDqxmB0EVB5lL1hjr28792Uu50SxYB4zZB9ct2ZCdYYSIDI8nZAwZCsi96gzi1a9hZBLzoWW0epCTtdYBoL8jUcFegwc9EsmfXfpDzqauHqQGY0zmUPn0NV91jyQVWEWIeTzbc95gZDZD');

class FacebookCAPI {
    
    private function hash($data) {
        return empty($data) ? null : hash('sha256', strtolower(trim($data)));
    }
    
    private function buildUserData($d) {
        $names = explode(' ', trim($d['name'] ?? ''));
        $u = [
            'client_ip_address' => $d['ip'] ?? $_SERVER['REMOTE_ADDR'] ?? null,
            'client_user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? null,
            'country' => [$this->hash('br')],
        ];
        if (!empty($d['email'])) $u['em'] = [$this->hash($d['email'])];
        if (!empty($d['phone'])) $u['ph'] = [$this->hash('55' . preg_replace('/\D/', '', $d['phone']))];
        if (!empty($names[0])) $u['fn'] = [$this->hash($names[0])];
        if (count($names) > 1) $u['ln'] = [$this->hash(end($names))];
        if (!empty($d['document'])) $u['external_id'] = [$this->hash(preg_replace('/\D/', '', $d['document']))];
        if (!empty($d['cep'])) $u['zp'] = [$this->hash(preg_replace('/\D/', '', $d['cep']))];
        if (!empty($d['cidade'])) $u['ct'] = [$this->hash($d['cidade'])];
        if (!empty($d['estado'])) $u['st'] = [$this->hash($d['estado'])];
        if (!empty($d['fbc'])) $u['fbc'] = $d['fbc'];
        if (!empty($d['fbp'])) $u['fbp'] = $d['fbp'];
        return $u;
    }
    
    public function send($event, $userData, $custom = []) {
        $eventId = $event . '_' . uniqid();
        $payload = ['data' => [[
            'event_name' => $event,
            'event_time' => time(),
            'event_id' => $eventId,
            'action_source' => 'website',
            'user_data' => $this->buildUserData($userData),
            'custom_data' => $custom
        ]]];
        
        $ch = curl_init("https://graph.facebook.com/v18.0/" . FB_PIXEL_ID . "/events?access_token=" . FB_ACCESS_TOKEN);
        curl_setopt_array($ch, [CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($payload), 
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'], CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
        $res = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        @file_put_contents(__DIR__ . '/logs/facebook.log', "[" . gmdate('Y-m-d H:i:s') . "] $event | $code | $res\n", FILE_APPEND);
        return ['success' => $code >= 200 && $code < 300, 'event_id' => $eventId];
    }
    
    public function initiateCheckout($data, $value, $product = 'Produto') {
        return $this->send('InitiateCheckout', $data, ['value' => $value, 'currency' => 'BRL', 'content_name' => $product]);
    }
    
    public function generateLead($data, $value, $txId, $product = 'Produto') {
        return $this->send('GenerateLead', $data, ['value' => $value, 'currency' => 'BRL', 'content_name' => $product, 'lead_id' => $txId]);
    }
    
    public function purchase($data, $value, $txId, $product = 'Produto') {
        return $this->send('Purchase', $data, ['value' => $value, 'currency' => 'BRL', 'content_name' => $product, 'order_id' => $txId]);
    }
}