/**
 * PROTECTION.JS v3.0 - MÁXIMA PROTEÇÃO
 * Anti-clone + Ofuscação + Detecção avançada
 */

(function(_0x4a7b, _0x2c3d) {
    'use strict';
    
    // Configuração
    var _0xc = {
        d: [],                          // dominiosPermitidos
        r: 'https://www.estadao.com.br/politica/coluna-do-estadao/mega-da-virada-rompe-barreira-historica-e-caixa-estima-premio-de-r-1-bilhao/?srsltid=AfmBOopcnlnX3tYI5N5OGv36Kn4l9byXN7Ez6urDDy5G5PgIBk6QiNGQ',        // redirecionarPara
        vt: true,                       // verificarToken
        tp: 'tk',                       // tokenParam
        tv: 'acesso2025',               // tokenValido
        bd: true,                       // bloquearDevTools
        bc: true,                       // bloquearCliqueDir
        bs: true,                       // bloquearSelecao
        dd: true,                       // detectarDevTools
        dj: true,                       // detectarJSDesativado
        dm: false                       // debugMode
    };
    
    // Mescla config do usuário
    if (typeof window.PROTECTION_CONFIG !== 'undefined') {
        var p = window.PROTECTION_CONFIG;
        if (p.dominiosPermitidos) _0xc.d = p.dominiosPermitidos;
        if (p.redirecionarPara) _0xc.r = p.redirecionarPara;
        if (typeof p.verificarToken !== 'undefined') _0xc.vt = p.verificarToken;
        if (p.tokenParam) _0xc.tp = p.tokenParam;
        if (p.tokenValido) _0xc.tv = p.tokenValido;
        if (typeof p.bloquearDevTools !== 'undefined') _0xc.bd = p.bloquearDevTools;
        if (typeof p.bloquearCliqueDir !== 'undefined') _0xc.bc = p.bloquearCliqueDir;
        if (typeof p.bloquearSelecao !== 'undefined') _0xc.bs = p.bloquearSelecao;
        if (typeof p.detectarDevTools !== 'undefined') _0xc.dd = p.detectarDevTools;
        if (typeof p.debugMode !== 'undefined') _0xc.dm = p.debugMode;
    }
    
    // Funções ofuscadas
    var _0xf1 = function(m) { if (_0xc.dm) { console.log('[P] ' + m); } };
    var _0xf2 = function(m) { _0xf1('B: ' + m); window.location.href = _0xc.r; };
    var _0xf3 = function(p) { return new URLSearchParams(window.location.search).get(p); };
    var _0xf4 = function(u) { 
        if (!u) return ''; 
        try { var a = document.createElement('a'); a.href = u; return a.hostname.toLowerCase().replace(/^www\./, ''); } 
        catch (e) { return ''; } 
    };
    var _0xf5 = function(d, l) {
        if (!d || !l || l.length === 0) return false;
        d = d.toLowerCase().replace(/^www\./, '');
        for (var i = 0; i < l.length; i++) {
            if (d === l[i].toLowerCase().replace(/^www\./, '')) return true;
        }
        return false;
    };
    var _0xf6 = function() { 
        try { 
            sessionStorage.setItem('_0xa', 'true'); 
            sessionStorage.setItem('_0xt', Date.now().toString()); 
        } catch (e) {} 
    };
    var _0xf7 = function() {
        try {
            var l = sessionStorage.getItem('_0xa');
            var t = parseInt(sessionStorage.getItem('_0xt') || '0');
            if (l === 'true' && (Date.now() - t) < 7200000) return true;
        } catch (e) {}
        return false;
    };
    
    // Anti-debug: detecta se console está aberto
    var _0xd1 = function() {
        var t1 = performance.now();
        debugger;
        var t2 = performance.now();
        if (t2 - t1 > 100) {
            _0xf2('debugger detected');
        }
    };
    
    // Anti-debug: detecta DevTools por tamanho da janela
    var _0xd2 = function() {
        var w = window.outerWidth - window.innerWidth > 160;
        var h = window.outerHeight - window.innerHeight > 160;
        if (w || h) {
            _0xf2('devtools size');
        }
    };
    
    // Anti-debug: detecta DevTools por console.log
    var _0xd3 = function() {
        var e = document.createElement('div');
        Object.defineProperty(e, 'id', {
            get: function() {
                _0xf2('devtools console');
            }
        });
        console.log('%c', e);
    };
    
    // Bloqueia view-source
    var _0xb1 = function() {
        if (window.location.href.indexOf('view-source:') === 0) {
            _0xf2('view-source');
        }
    };
    
    // Bloqueia iframe
    var _0xb2 = function() {
        if (window.self !== window.top) {
            _0xf2('iframe detected');
        }
    };
    
    // Desativa funções de debug
    var _0xb3 = function() {
        // Desativa console
        var c = window.console;
        if (c) {
            var m = ['log', 'debug', 'info', 'warn', 'error', 'table', 'trace'];
            for (var i = 0; i < m.length; i++) {
                c[m[i]] = function() {};
            }
        }
    };
    
    // Detecta automação (Selenium, Puppeteer, etc)
    var _0xb4 = function() {
        // WebDriver
        if (navigator.webdriver === true) {
            _0xf2('webdriver');
            return;
        }
        
        // Puppeteer/Playwright
        if (window._phantom || window.__nightmare || window.callPhantom) {
            _0xf2('phantom');
            return;
        }
        
        // Selenium
        var s = ['__selenium_evaluate', '__webdriver_evaluate', '__driver_evaluate',
                 '__webdriver_script_fn', '__webdriver_script_func', '__webdriver_script_function',
                 '_Selenium_IDE_Recorder', '_selenium', 'calledSelenium'];
        for (var i = 0; i < s.length; i++) {
            if (window[s[i]] !== undefined || document[s[i]] !== undefined) {
                _0xf2('selenium');
                return;
            }
        }
        
        // ChromeDriver
        if (document.$cdc_asdjflasutopfhvcZLmcfl_ !== undefined) {
            _0xf2('chromedriver');
            return;
        }
        
        // Headless Chrome
        if (/HeadlessChrome/i.test(navigator.userAgent)) {
            _0xf2('headless');
            return;
        }
        
        // Puppeteer
        if (navigator.plugins.length === 0 && navigator.languages.length === 0) {
            _0xf2('no plugins');
            return;
        }
    };
    
    // Bloqueia teclas
    var _0xb5 = function() {
        document.addEventListener('keydown', function(e) {
            // F12
            if (e.keyCode === 123) { e.preventDefault(); return false; }
            // Ctrl+Shift+I/J/C
            if (e.ctrlKey && e.shiftKey && (e.keyCode === 73 || e.keyCode === 74 || e.keyCode === 67)) {
                e.preventDefault(); return false;
            }
            // Ctrl+U
            if (e.ctrlKey && e.keyCode === 85) { e.preventDefault(); return false; }
            // Ctrl+S
            if (e.ctrlKey && e.keyCode === 83) { e.preventDefault(); return false; }
            // Ctrl+P
            if (e.ctrlKey && e.keyCode === 80) { e.preventDefault(); return false; }
            // Ctrl+A
            if (e.ctrlKey && e.keyCode === 65) { e.preventDefault(); return false; }
            // Ctrl+C
            if (e.ctrlKey && e.keyCode === 67) { e.preventDefault(); return false; }
        });
    };
    
    // Bloqueia clique direito
    var _0xb6 = function() {
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
            return false;
        });
    };
    
    // Bloqueia seleção
    var _0xb7 = function() {
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
            return false;
        });
        document.addEventListener('copy', function(e) {
            e.preventDefault();
            return false;
        });
        document.addEventListener('cut', function(e) {
            e.preventDefault();
            return false;
        });
        document.body.style.userSelect = 'none';
        document.body.style.webkitUserSelect = 'none';
        document.body.style.msUserSelect = 'none';
        document.body.style.MozUserSelect = 'none';
    };
    
    // Bloqueia arrastar
    var _0xb8 = function() {
        document.addEventListener('dragstart', function(e) {
            e.preventDefault();
            return false;
        });
    };
    
    // Bloqueia print
    var _0xb9 = function() {
        window.addEventListener('beforeprint', function() {
            document.body.style.display = 'none';
        });
        window.addEventListener('afterprint', function() {
            document.body.style.display = 'block';
        });
        
        // CSS anti-print
        var s = document.createElement('style');
        s.innerHTML = '@media print { body { display: none !important; } }';
        document.head.appendChild(s);
    };
    
    // === EXECUÇÃO PRINCIPAL ===
    
    // Verifica automação primeiro
    _0xb4();
    
    // Verifica view-source
    _0xb1();
    
    // Verifica iframe
    _0xb2();
    
    var d = _0xf4(window.location.href);
    var t = _0xf3(_0xc.tp);
    
    _0xf1('D: ' + d);
    _0xf1('T: ' + (t || 'null'));
    
    // Verifica domínio
    if (_0xc.d.length > 0 && !_0xf5(d, _0xc.d)) {
        _0xf2('domain');
        return;
    }
    
    // Verifica token
    if (_0xc.vt) {
        if (t && t === _0xc.tv) {
            _0xf1('Token OK');
            _0xf6();
        } else if (_0xf7()) {
            _0xf1('Session OK');
        } else {
            _0xf2('no token');
            return;
        }
    }
    
    // Aplica proteções
    if (_0xc.bd) _0xb5();
    if (_0xc.bc) _0xb6();
    if (_0xc.bs) _0xb7();
    _0xb8();
    _0xb9();
    
    // Desativa console (após debug)
    if (!_0xc.dm) {
        _0xb3();
    }
    
    // Monitoramento contínuo de DevTools
    if (_0xc.dd) {
        setInterval(_0xd2, 1000);
        // _0xd3(); // Pode causar problemas em alguns navegadores
    }
    
    // Anti-debug periódico (cuidado: pode travar a página)
    // setInterval(_0xd1, 5000);
    
    _0xf1('OK');
    
})(window, document);


// === PROTEÇÃO EXTRA: OFUSCA O HTML ===
// Adiciona caracteres invisíveis que quebram copy/paste

(function() {
    if (document.body) {
        var walker = document.createTreeWalker(
            document.body,
            NodeFilter.SHOW_TEXT,
            null,
            false
        );
        
        var node;
        var nodes = [];
        while (node = walker.nextNode()) {
            if (node.nodeValue.trim().length > 0) {
                nodes.push(node);
            }
        }
        
        // Adiciona zero-width characters em textos longos
        for (var i = 0; i < nodes.length; i++) {
            var text = nodes[i].nodeValue;
            if (text.length > 20) {
                // Adiciona caracteres invisíveis a cada 5 caracteres
                var newText = '';
                for (var j = 0; j < text.length; j++) {
                    newText += text[j];
                    if (j > 0 && j % 5 === 0) {
                        // Zero-width space + zero-width non-joiner
                        newText += '\u200B\u200C';
                    }
                }
                nodes[i].nodeValue = newText;
            }
        }
    }
})();