<?php
/**
 * ============================================
 * CONFIGURAÇÃO CENTRALIZADA DO CHECKOUT
 * ============================================
 */

// ============================================
// 🔄 GATEWAY ATIVO - MUDE AQUI PARA ALTERNAR
// ============================================
// Opções disponíveis: 'umbrella' ou 'techbynet'
define('GATEWAY_ATIVO', 'umbrella');

// ============================================
// CONFIGURAÇÕES DOS GATEWAYS
// ============================================
$GATEWAYS = [
    
    // ----------------------------------------
    // UMBRELLA API
    // ----------------------------------------
    'umbrella' => [
        'enabled' => true,
        'name' => 'Umbrella',
        'api_url' => 'https://api-gateway.umbrellapag.com',
        'api_key' => 'd46fa92f-9484-409f-a82a-e2734029979e',
        'webhook_secret' => '',
        'user_agent' => 'UMBRELLAB2B/1.0',
        'auth_header' => 'x-api-key',
        
        // Endpoints
        'endpoints' => [
            'pix_create' => '/api/user/transactions',
            'pix_status' => '/api/user/transactions',  // GET com ?id=
        ],
        
        // Mapeamento de status da API para status interno
        // Status possíveis: PROCESSING, AUTHORIZED, PAID, REFUNDED, WAITING_PAYMENT, REFUSED, CHARGEDBACK, CANCELED, IN_PROTEST
        'status_map' => [
            'PAID' => 'paid',
            'AUTHORIZED' => 'paid',
            'CONCLUIDA' => 'paid',
            'APPROVED' => 'paid',
            'COMPLETED' => 'paid',
            'CONFIRMED' => 'paid',
            'PENDING' => 'pending',
            'WAITING' => 'pending',
            'WAITING_PAYMENT' => 'pending',
            'PROCESSING' => 'pending',
            'ATIVA' => 'pending',
            'EXPIRED' => 'expired',
            'CANCELLED' => 'cancelled',
            'CANCELED' => 'cancelled',
            'REFUSED' => 'cancelled',
            'CHARGEDBACK' => 'refunded',
            'REFUNDED' => 'refunded',
            'IN_PROTEST' => 'pending',
        ],
        
        // Campos de resposta (múltiplos nomes possíveis)
        'response_fields' => [
            'id' => ['id', 'txid', 'transaction_id'],
            'qrcode' => ['qrcode', 'pix_code', 'emv', 'copiaecola'],
            'qrcode_base64' => ['qrcodeBase64', 'qrcode_base64', 'qr_code_base64'],
            'status' => ['status', 'payment_status'],
        ],
    ],
    
    // ----------------------------------------
    // TECHBYNET API
    // ----------------------------------------
    'techbynet' => [
        'enabled' => true,
        'name' => 'TechByNet',
        'api_url' => 'https://api-gateway.techbynet.com/api/user/transactions',
        'api_key' => 'b43ab2b9-a9de-43ce-8dbc-6ec8cc1204dd',
        'webhook_secret' => '',
        'user_agent' => 'SmartCheckout/2.0',
        'auth_header' => 'x-api-key',
        
        // Endpoints
        'endpoints' => [
            'pix_create' => '',  // URL base já é o endpoint
            'pix_status' => '/', // GET /{id}
        ],
        
        // Mapeamento de status
        'status_map' => [
            'PAID' => 'paid',
            'CONCLUIDA' => 'paid',
            'APPROVED' => 'paid',
            'COMPLETED' => 'paid',
            'CONFIRMED' => 'paid',
            'PENDING' => 'pending',
            'ATIVA' => 'pending',
            'WAITING' => 'pending',
            'WAITING_PAYMENT' => 'pending',
            'EXPIRED' => 'expired',
            'CANCELLED' => 'cancelled',
        ],
        
        // Campos de resposta
        'response_fields' => [
            'id' => ['id', 'transaction_id', 'external_reference'],
            'qrcode' => ['pix_code', 'qrcode', 'emv'],
            'qrcode_base64' => ['qrcode_base64', 'qrcodeBase64'],
            'status' => ['status'],
        ],
    ],
];

/**
 * Retorna configuração do gateway ativo
 */
function getGatewayConfig() {
    global $GATEWAYS;
    $gateway = GATEWAY_ATIVO;
    
    if (!isset($GATEWAYS[$gateway])) {
        throw new Exception("Gateway '$gateway' não configurado");
    }
    
    if (!$GATEWAYS[$gateway]['enabled']) {
        throw new Exception("Gateway '$gateway' está desabilitado");
    }
    
    return $GATEWAYS[$gateway];
}

/**
 * Retorna nome do gateway ativo
 */
function getGatewayName() {
    return GATEWAY_ATIVO;
}

/**
 * Mapeia status da API para status interno
 */
function mapStatus($apiStatus, $gatewayConfig = null) {
    if (!$gatewayConfig) {
        $gatewayConfig = getGatewayConfig();
    }
    
    $status = strtoupper(trim($apiStatus));
    return $gatewayConfig['status_map'][$status] ?? 'unknown';
}

/**
 * Extrai campo da resposta da API (tenta múltiplos nomes)
 */
function extractField($data, $fieldType, $gatewayConfig = null) {
    if (!$gatewayConfig) {
        $gatewayConfig = getGatewayConfig();
    }
    
    $possibleNames = $gatewayConfig['response_fields'][$fieldType] ?? [];
    
    foreach ($possibleNames as $name) {
        // Tenta no nível raiz
        if (isset($data[$name]) && !empty($data[$name])) {
            return $data[$name];
        }
        // Tenta em data (Umbrella)
        if (isset($data['data'][$name]) && !empty($data['data'][$name])) {
            return $data['data'][$name];
        }
        // Tenta em data.data
        if (isset($data['data']['data'][$name]) && !empty($data['data']['data'][$name])) {
            return $data['data']['data'][$name];
        }
        // Tenta em pix
        if (isset($data['pix'][$name]) && !empty($data['pix'][$name])) {
            return $data['pix'][$name];
        }
    }
    
    return null;
}

// ========== UTMIFY (GIRO DA SORTE) ==========
define('UTMIFY_TOKEN', 'JgzvS7Z6nDEYeyh5XXAj0nS1XPcZVya9aKUf');

// ========== PRODUTO - GIRO DA SORTE ==========
define('PRODUTO_NOME', 'Giro da Sorte');
define('PRODUTO_SLUG', 'giro');
define('PRODUTO_ID', 'GIRO001');
define('VALOR_PADRAO_CENTAVOS', 990);
define('COTAS_PADRAO', 10);

// ========== URLs ==========
define('SITE_URL', 'https://checkout-carlinhosmaia.com');
define('WEBHOOK_URL', SITE_URL . '/uppsell/api/webhook.php');

// ========== ANTI-CLONE ==========
define('ANTI_CLONE_SECRET', 'CM2025_SecretKey_!@#$%');
define('DOMINIOS_PERMITIDOS', [
    'checkout-carlinhosmaia.com',
    'www.checkout-carlinhosmaia.com',
    'localhost',
    '127.0.0.1'
]);

// ========== LOGS ==========
define('LOG_DIR', __DIR__ . '/logs/');
define('UTM_STORAGE_DIR', __DIR__ . '/utm_storage/');

if (!is_dir(LOG_DIR)) @mkdir(LOG_DIR, 0755, true);
if (!is_dir(UTM_STORAGE_DIR)) @mkdir(UTM_STORAGE_DIR, 0755, true);

/**
 * Função de log unificada
 */
function logCheckout($file, $msg, $data = null) {
    $log = "[" . date('Y-m-d H:i:s') . "] $msg";
    if ($data) $log .= " | " . json_encode($data, JSON_UNESCAPED_UNICODE);
    @file_put_contents(LOG_DIR . $file, $log . "\n", FILE_APPEND);
}

/**
 * Headers CORS padrão
 */
function setCorsHeaders() {
    header('Content-Type: application/json; charset=utf-8');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, X-Requested-With');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

/**
 * Proteção anti-clone - valida origem
 */
function validarOrigem() {
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    $referer = $_SERVER['HTTP_REFERER'] ?? '';
    $host = $_SERVER['HTTP_HOST'] ?? '';
    
    if (empty($origin) && empty($referer)) {
        return true;
    }
    
    $dominioValido = false;
    foreach (DOMINIOS_PERMITIDOS as $dominio) {
        if (strpos($origin, $dominio) !== false || 
            strpos($referer, $dominio) !== false ||
            strpos($host, $dominio) !== false) {
            $dominioValido = true;
            break;
        }
    }
    
    if (!$dominioValido) {
        logCheckout('security.log', 'Origem bloqueada', [
            'origin' => $origin,
            'referer' => $referer,
            'ip' => $_SERVER['REMOTE_ADDR'] ?? ''
        ]);
        http_response_code(403);
        die(json_encode(['error' => 'Acesso não autorizado']));
    }
    
    return true;
}

/**
 * Gera token anti-clone criptografado
 */
function gerarTokenAntiClone() {
    $dados = [
        'ts' => time(),
        'exp' => time() + 3600,
        'ip' => $_SERVER['REMOTE_ADDR'] ?? '',
        'ua' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 50)
    ];
    $iv = substr(ANTI_CLONE_SECRET, 0, 16);
    return base64_encode(openssl_encrypt(json_encode($dados), 'AES-256-CBC', ANTI_CLONE_SECRET, 0, $iv));
}

/**
 * Valida token anti-clone
 */
function validarTokenAntiClone($token) {
    if (empty($token)) return false;
    
    try {
        $iv = substr(ANTI_CLONE_SECRET, 0, 16);
        $dados = json_decode(openssl_decrypt(base64_decode($token), 'AES-256-CBC', ANTI_CLONE_SECRET, 0, $iv), true);
        
        if (!$dados || !isset($dados['exp'])) return false;
        if ($dados['exp'] < time()) return false;
        
        return true;
    } catch (Exception $e) {
        return false;
    }
}

/**
 * Converte valor para null se vazio
 */
function emptyToNull($v) {
    return ($v === null || $v === '' || (is_string($v) && trim($v) === '')) ? null : $v;
}

/**
 * Formata telefone para padrão brasileiro
 */
function formatPhone($phone) {
    $phone = preg_replace('/\D/', '', $phone);
    if (strlen($phone) <= 11) {
        $phone = '55' . $phone;
    }
    return $phone;
}

/**
 * Valida CPF
 */
function validaCPF($cpf) {
    $cpf = preg_replace('/\D/', '', $cpf);
    if (strlen($cpf) !== 11 || preg_match('/^(\d)\1+$/', $cpf)) {
        return false;
    }
    
    $soma = 0;
    for ($i = 0; $i < 9; $i++) {
        $soma += intval($cpf[$i]) * (10 - $i);
    }
    $resto = $soma % 11;
    $dv1 = ($resto < 2) ? 0 : 11 - $resto;
    
    if (intval($cpf[9]) !== $dv1) return false;
    
    $soma = 0;
    for ($i = 0; $i < 10; $i++) {
        $soma += intval($cpf[$i]) * (11 - $i);
    }
    $resto = $soma % 11;
    $dv2 = ($resto < 2) ? 0 : 11 - $resto;
    
    return intval($cpf[10]) === $dv2;
}