<?php
/**
 * DIAGNÓSTICO DO TRACKING
 */

header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

require_once __DIR__ . '/config.php';

echo "<h1>🔍 Diagnóstico do Tracking</h1>";
echo "<style>body{font-family:system-ui;padding:20px;background:#111;color:#fff}
.ok{color:#4ade80}.erro{color:#f87171}.aviso{color:#fbbf24}
pre{background:#1a1a1a;padding:10px;border-radius:8px;overflow-x:auto}</style>";

// 1. Verifica arquivos
echo "<h2>1. Arquivos</h2>";

$arquivos = [
    'config.php' => __DIR__ . '/config.php',
    'facebook_capi.php' => __DIR__ . '/facebook_capi.php',
    'utmify.php' => __DIR__ . '/utmify.php',
    'tracking.php' => __DIR__ . '/tracking.php',
    'smart-tracking.js' => __DIR__ . '/smart-tracking.js',
    'webhook.php' => __DIR__ . '/webhook.php'
];

foreach ($arquivos as $nome => $caminho) {
    $existe = file_exists($caminho);
    $status = $existe ? '✅' : '❌';
    $classe = $existe ? 'ok' : 'erro';
    echo "<p class='$classe'>$status $nome</p>";
}

// 2. Verifica constantes
echo "<h2>2. Configuração Facebook</h2>";

$constantes = ['FB_PIXEL_ID', 'FB_ACCESS_TOKEN', 'FB_API_VERSION'];
foreach ($constantes as $c) {
    if (defined($c)) {
        $valor = constant($c);
        $mascarado = substr($valor, 0, 10) . '...';
        echo "<p class='ok'>✅ $c = $mascarado</p>";
    } else {
        echo "<p class='erro'>❌ $c não definido!</p>";
    }
}

// 3. Verifica logs de tracking
echo "<h2>3. Últimos eventos do tracking.php</h2>";

$trackingLog = __DIR__ . '/logs/tracking.log';
if (file_exists($trackingLog)) {
    $linhas = file($trackingLog);
    $ultimas = array_slice($linhas, -10);
    echo "<pre>" . htmlspecialchars(implode("", $ultimas)) . "</pre>";
} else {
    echo "<p class='aviso'>⚠️ Log de tracking não encontrado</p>";
    echo "<p>Caminho: $trackingLog</p>";
}

// 4. Verifica logs do Facebook CAPI
echo "<h2>4. Últimos eventos do Facebook CAPI</h2>";

$fbLog = __DIR__ . '/logs/facebook_capi.log';
if (file_exists($fbLog)) {
    $linhas = file($fbLog);
    $ultimas = array_slice($linhas, -10);
    echo "<pre>" . htmlspecialchars(implode("", $ultimas)) . "</pre>";
} else {
    echo "<p class='aviso'>⚠️ Log do Facebook CAPI não encontrado</p>";
}

// 5. Testa envio direto para o Facebook
echo "<h2>5. Teste de envio para Facebook CAPI</h2>";

if (class_exists('FacebookCAPI') || file_exists(__DIR__ . '/facebook_capi.php')) {
    require_once __DIR__ . '/facebook_capi.php';
    
    $fb = new FacebookCAPI();
    
    $testData = [
        'email' => 'teste@diagnostico.com',
        'phone' => '11999999999',
        'name' => 'Teste Diagnostico',
        'ip' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1'
    ];
    
    echo "<p>Enviando PageView de teste...</p>";
    
    $result = $fb->pageView($testData, 'https://diagnostico.test');
    
    if ($result['success']) {
        echo "<p class='ok'>✅ Facebook CAPI funcionando!</p>";
        echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT) . "</pre>";
    } else {
        echo "<p class='erro'>❌ Erro no Facebook CAPI</p>";
        echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT) . "</pre>";
    }
} else {
    echo "<p class='erro'>❌ Classe FacebookCAPI não encontrada</p>";
}

// 6. Verifica tracking.php
echo "<h2>6. Verifica tracking.php</h2>";

$trackingFile = __DIR__ . '/tracking.php';
if (file_exists($trackingFile)) {
    $conteudo = file_get_contents($trackingFile);
    
    // Verifica se tem as funções necessárias
    $temFacebookCAPI = strpos($conteudo, 'FacebookCAPI') !== false;
    $temPageView = strpos($conteudo, 'pageView') !== false || strpos($conteudo, 'PageView') !== false;
    
    echo "<p class='" . ($temFacebookCAPI ? 'ok' : 'erro') . "'>" . ($temFacebookCAPI ? '✅' : '❌') . " Usa FacebookCAPI</p>";
    echo "<p class='" . ($temPageView ? 'ok' : 'erro') . "'>" . ($temPageView ? '✅' : '❌') . " Tem PageView</p>";
    
    echo "<p>Primeiras 50 linhas:</p>";
    $linhas = explode("\n", $conteudo);
    echo "<pre>" . htmlspecialchars(implode("\n", array_slice($linhas, 0, 50))) . "</pre>";
} else {
    echo "<p class='erro'>❌ tracking.php não existe!</p>";
    echo "<p>Este arquivo é necessário para receber eventos do smart-tracking.js</p>";
}

echo "<h2>📋 Resumo</h2>";
echo "<p>Se o tracking.php não existe ou não está funcionando, os eventos do smart-tracking.js não são enviados para o Facebook CAPI.</p>";