<?php
/**
 * PROTEÇÃO DO PAINEL DE CHAT - BRASICRED
 * Coloque este arquivo em: /admin/auth.php
 */

session_start();

// ==================== CONFIGURAÇÕES ====================
// MUDE ESTES DADOS!
define('ADMIN_USUARIO', 'admin');
define('ADMIN_SENHA', '@brasicred2025'); // TROQUE POR UMA SENHA FORTE!
define('ADMIN_TOKEN_SECRET', 'BrasiCred_SecretKey_2025!@#'); // Chave para tokens

// Tempo de sessão em segundos (2 horas)
define('SESSAO_DURACAO', 7200);

// ==================== FUNÇÕES ====================

/**
 * Verifica se está logado
 */
function estaLogado() {
    if (!isset($_SESSION['admin_logado']) || $_SESSION['admin_logado'] !== true) {
        return false;
    }
    
    // Verifica se a sessão expirou
    if (isset($_SESSION['admin_tempo']) && (time() - $_SESSION['admin_tempo']) > SESSAO_DURACAO) {
        logout();
        return false;
    }
    
    // Atualiza tempo da sessão
    $_SESSION['admin_tempo'] = time();
    return true;
}

/**
 * Faz login
 */
function login($usuario, $senha) {
    if ($usuario === ADMIN_USUARIO && $senha === ADMIN_SENHA) {
        $_SESSION['admin_logado'] = true;
        $_SESSION['admin_tempo'] = time();
        $_SESSION['admin_usuario'] = $usuario;
        $_SESSION['admin_ip'] = $_SERVER['REMOTE_ADDR'];
        return true;
    }
    
    // Log de tentativa falha
    $logDir = __DIR__ . '/../data/logs';
    if (!is_dir($logDir)) mkdir($logDir, 0755, true);
    
    $log = [
        'time' => date('Y-m-d H:i:s'),
        'ip' => $_SERVER['REMOTE_ADDR'],
        'usuario' => $usuario,
        'ua' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ];
    file_put_contents($logDir . '/login_falho_' . date('Y-m-d') . '.log', json_encode($log) . "\n", FILE_APPEND);
    
    return false;
}

/**
 * Faz logout
 */
function logout() {
    $_SESSION = array();
    session_destroy();
}

/**
 * Protege uma página (redireciona se não logado)
 */
function protegerPagina() {
    if (!estaLogado()) {
        header('Location: login.html');
        exit;
    }
}

/**
 * Protege API (retorna JSON de erro se não logado)
 */
function protegerAPI() {
    if (!estaLogado()) {
        header('Content-Type: application/json');
        http_response_code(401);
        echo json_encode(['error' => 'Não autorizado', 'redirect' => 'login.html']);
        exit;
    }
}

// ==================== ROTEAMENTO ====================

// Se chamado diretamente como API
if (basename($_SERVER['PHP_SELF']) === 'auth.php') {
    header('Content-Type: application/json');
    
    $action = $_GET['action'] ?? $_POST['action'] ?? '';
    
    switch ($action) {
        case 'login':
            $input = json_decode(file_get_contents('php://input'), true);
            $usuario = $input['usuario'] ?? $_POST['usuario'] ?? '';
            $senha = $input['senha'] ?? $_POST['senha'] ?? '';
            
            if (login($usuario, $senha)) {
                echo json_encode(['success' => true, 'message' => 'Login realizado!']);
            } else {
                http_response_code(401);
                echo json_encode(['success' => false, 'error' => 'Usuário ou senha incorretos']);
            }
            break;
            
        case 'logout':
            logout();
            echo json_encode(['success' => true, 'message' => 'Logout realizado']);
            break;
            
        case 'check':
            echo json_encode([
                'logado' => estaLogado(),
                'usuario' => $_SESSION['admin_usuario'] ?? null
            ]);
            break;
            
        default:
            echo json_encode(['error' => 'Ação inválida']);
    }
    exit;
}
